/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.patrol.list;

import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.service.BusinessModuleService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.bean.UserVaadinBean;
import com.neogls.prism.central.vaadin.service.i18n.PrismI18NProvider;
import com.neogls.prism.central.vaadin.service.mapper.UserVaadinBeanMapper;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.service.util.AuthenticatedUserUtils;
import com.neogls.prism.central.vaadin.view.mct.common.list.AbstractMctListService;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctList;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.filter.PatrolFilter;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolDetailsGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolListItemGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolMctListService;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolRetrieverService;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolSelectionActionGeneratorService;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasEnabled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public abstract class AbstractPatrolMctListService
extends AbstractMctListService<VehiculeEnIntervention, PatrolFilter, PatrolActionListener>
implements PatrolMctListService {
    private final IBusinessService businessService;
    private final UserPermissionService userPermissionService;
    private final BusinessModuleService businessModuleService;
    private final ConfigurationService configurationService;
    private final PatrolRetrieverService patrolRetrieverService;
    private final PatrolListItemGeneratorService patrolListItemGeneratorService;
    private final PatrolDetailsGeneratorService patrolDetailsGeneratorService;
    private final PatrolSelectionActionGeneratorService patrolSelectionActionGeneratorService;
    private final PrismI18NProvider i18NProvider;

    protected AbstractPatrolMctListService(IBusinessService businessService, UserPermissionService userPermissionService, BusinessModuleService businessModuleService, ConfigurationService configurationService, PatrolRetrieverService patrolRetrieverService, PatrolListItemGeneratorService patrolListItemGeneratorService, PatrolDetailsGeneratorService patrolDetailsGeneratorService, PatrolSelectionActionGeneratorService patrolSelectionActionGeneratorService, PrismI18NProvider i18NProvider) {
        super(businessService, userPermissionService, businessModuleService);
        this.businessService = businessService;
        this.userPermissionService = userPermissionService;
        this.businessModuleService = businessModuleService;
        this.configurationService = configurationService;
        this.patrolRetrieverService = patrolRetrieverService;
        this.patrolListItemGeneratorService = patrolListItemGeneratorService;
        this.patrolDetailsGeneratorService = patrolDetailsGeneratorService;
        this.patrolSelectionActionGeneratorService = patrolSelectionActionGeneratorService;
        this.i18NProvider = i18NProvider;
    }

    public List<PatrolFilter> getFilters() {
        int id = 0;
        AuthenticatedUser currentUser = this.getCurrentUser();
        String delegation = AuthenticatedUserUtils.getDeletationString((AuthenticatedUser)currentUser);
        String centre = AuthenticatedUserUtils.getCenterString((AuthenticatedUser)currentUser);
        List mmCodes = this.getBusinessModuleCodes();
        String mmName = this.businessModuleService.findBusinessModuleByCode(Integer.valueOf(this.getPrimaryBusinessModuleCode())).map(ModuleMetier::getNom).orElseThrow();
        ArrayList<PatrolFilter> filters = new ArrayList<PatrolFilter>();
        PatrolFilter fCustom = PatrolFilter.builder().unlocalizedName("mct.filtre.patrouilles.perso").vehicleFilter(new IBusinessService.VehiculeFiltre()).isCustom(true).build();
        fCustom.getVehicleFilter().codeModuleMetier = mmCodes;
        filters.add(fCustom);
        if (this.userPermissionService.canShowInProgressPatrols()) {
            PatrolFilter fEncours = PatrolFilter.builder().id(id++).unlocalizedName("mct.filtre.patrouilles.encours").vehicleFilter(IBusinessService.VehiculeFiltre.encours((String)delegation, (String)centre, (List)mmCodes)).build();
            filters.add(fEncours);
        }
        int n = id++;
        PatrolFilter fJournee = PatrolFilter.builder().id(n).unlocalizedName(Optional.of("mct.filtre.patrouilles.%s.journee".formatted(mmName)).filter(arg_0 -> ((PrismI18NProvider)this.i18NProvider).hasKey(arg_0)).orElse("mct.filtre.patrouilles.journee")).vehicleFilter(IBusinessService.VehiculeFiltre.deLaJournee((String)delegation, (String)centre, (List)mmCodes)).build();
        filters.add(fJournee);
        int n2 = id++;
        PatrolFilter fVeille = PatrolFilter.builder().id(n2).unlocalizedName(Optional.of("mct.filtre.patrouilles.%s.veille".formatted(mmName)).filter(arg_0 -> ((PrismI18NProvider)this.i18NProvider).hasKey(arg_0)).orElse("mct.filtre.patrouilles.veille")).vehicleFilter(IBusinessService.VehiculeFiltre.deLaVeille((String)delegation, (String)centre, (List)mmCodes)).build();
        filters.add(fVeille);
        if (this.configurationService.isPatrolVisaActive() && this.userPermissionService.canVisaPatrols()) {
            int n3 = id++;
            PatrolFilter fAViser = PatrolFilter.builder().id(n3).unlocalizedName(Optional.of("mct.filtre.patrouilles.%s.aviser".formatted(mmName)).filter(arg_0 -> ((PrismI18NProvider)this.i18NProvider).hasKey(arg_0)).orElse("mct.filtre.patrouilles.aviser")).vehicleFilter(IBusinessService.VehiculeFiltre.aViser((String)delegation, (String)centre, (List)mmCodes)).build();
            filters.add(fAViser);
        }
        if (this.isDiffusionWaze()) {
            PatrolFilter fWaze = PatrolFilter.builder().unlocalizedName("mct.filtre.patrouilles.waze").vehicleFilter(IBusinessService.VehiculeFiltre.waze((String)delegation, (String)centre, (List)this.getBusinessModuleCodes())).build();
            filters.add(fWaze);
        }
        return filters;
    }

    public PatrolFilter getDefaultFilter() {
        return (PatrolFilter)this.getFilters().get(1);
    }

    public Collection<ModuleMetier> getBusinessModulesForFiltering() {
        return this.businessModuleService.getInheritedBusinessModules(this.getBusinessModuleCodes());
    }

    public List<VehiculeEnIntervention> getItems(PatrolFilter filter) {
        return this.patrolRetrieverService.getPatrols(filter);
    }

    public Component createListItem(VehiculeEnIntervention item) {
        return this.patrolListItemGeneratorService.createPatrolListItem(item);
    }

    public Component createDetails(VehiculeEnIntervention item, PatrolActionListener actionListener) {
        return this.patrolDetailsGeneratorService.createPatrolDetails(item, (Collection)this.getBusinessModuleCodes(), actionListener);
    }

    public HasEnabled createSelectionActionComponent(PatrolActionListener actionListener, MctList<?, VehiculeEnIntervention, ?, ?> patrolMctList) {
        return this.patrolSelectionActionGeneratorService.createSelectionActionComponent((PatrolMctListService)this, actionListener, patrolMctList);
    }

    public boolean canShowInProgressPatrols() {
        return this.userPermissionService.canShowInProgressPatrols();
    }

    public boolean isAutoLockDelegationAndCenter() {
        return this.businessModuleService.isAutoLockDelegationAndCenter(this.getBusinessModulesForFiltering().stream().findFirst().map(ModuleMetier::getCode).orElse(-1).intValue());
    }

    public boolean isPatrolVisaActive() {
        return this.configurationService.isPatrolVisaActive();
    }

    public boolean isPatrolVisaAllowedForCurrentUser() {
        return this.userPermissionService.canVisaPatrols();
    }

    public Collection<UserVaadinBean> getAgents() {
        return this.businessService.rechercheToutUtilisateur().stream().filter(Predicate.not(PrismCentralUser::isSysteme)).map(arg_0 -> ((UserVaadinBeanMapper)UserVaadinBeanMapper.INSTANCE).mapToVaadinBean(arg_0)).toList();
    }

    public boolean isDiffusionWaze() {
        return !"".equals(this.configurationService.getString(ConfigurationService.ConfigurationType.DATABASE, "publication.waze.polyline.vitesse").orElse(""));
    }
}

