/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.patrol.filter;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.google.common.collect.Maps;
import com.neogls.prism.central.vaadin.common.component.ComboBoxWithDefaultValue;
import com.neogls.prism.central.vaadin.common.component.dateinterval.DateRangePicker;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenter;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenterField;
import com.neogls.prism.central.vaadin.service.bean.DateRange;
import com.neogls.prism.central.vaadin.service.bean.UserVaadinBean;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.util.vaadin.DatePickerI18nUtils;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.filter.PatrolFilter;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.filter.PatrolFilterEditForm;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.filter.VehicleFilter;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolMctListService;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.checkbox.CheckboxGroup;
import com.vaadin.flow.component.checkbox.CheckboxGroupVariant;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.html.Hr;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.function.SerializablePredicate;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class PatrolFilterEditForm
extends VerticalLayout {
    private final Checkbox dateRangeEnable = new Checkbox(this.getTranslation("report.evenement.date.intervalle", new Object[0]), (HasValue.ValueChangeListener & Serializable)event -> this.updateDateFieldsVisibility());
    private final DatePicker datePicker = new DatePicker(this.getTranslation("report.evenement.date.jour", new Object[0]) + "*");
    private final DateRangePicker dateRangePicker = new DateRangePicker(this.getTranslation("report.evenement.date.intervalle", new Object[0]) + "*");
    private final ComboBoxWithDefaultValue<PatrolStateValue> cbPatrolState = new ComboBoxWithDefaultValue(this.getTranslation("mct.filtre.patrouilles.etat", new Object[0]));
    private final ComboBoxWithDefaultValue<VisaValue> cbPatrolVisa = new ComboBoxWithDefaultValue("Patrouilles concern\u00e9es");
    private final DelegationAndCenterField delegationAndCenterField;
    private final MultiSelectComboBox<UserVaadinBean> mscbAgent = new MultiSelectComboBox(this.getTranslation("report.evenement.agents.titre", new Object[0]));
    private final CheckboxGroup<ModuleMetier> cbgBusinessModule = new CheckboxGroup(this.getTranslation("mct.filtre.mm", new Object[0]));
    private final Checkbox diffusionWaze = new Checkbox(this.getTranslation("mct.filtre.patrouilles.waze", new Object[0]));
    private final PatrolFilter oldValue;
    private final PatrolMctListService patrolMctListService;
    private final AuthenticatedUser currentUser;
    private final Map<Integer, UserVaadinBean> agents;
    private final Map<Integer, ModuleMetier> businessModules;

    public PatrolFilterEditForm(PatrolFilter oldValue, PatrolMctListService patrolMctListService) {
        this.oldValue = oldValue;
        this.patrolMctListService = patrolMctListService;
        this.currentUser = patrolMctListService.getCurrentUser();
        this.agents = Maps.uniqueIndex((Iterable)patrolMctListService.getAgents(), UserVaadinBean::getId);
        this.businessModules = Maps.uniqueIndex((Iterable)patrolMctListService.getBusinessModulesForFiltering(), ModuleMetier::getCode);
        this.delegationAndCenterField = new DelegationAndCenterField(patrolMctListService.getActiveDelegations());
        this.addDateFields();
        this.addPatrolStateFields();
        if (patrolMctListService.isPatrolVisaActive() && patrolMctListService.isPatrolVisaAllowedForCurrentUser()) {
            this.addPatrolVisaFields();
        }
        if (patrolMctListService.isDiffusionWaze()) {
            this.addDiffusionWaze();
        }
        this.add(new Component[]{new Hr()});
        this.addDelegationAndCenterFields();
        this.addAgentField();
        this.configureDelegationAndCenterRestrictions();
        this.addBusinessModuleFields();
        this.setPadding(false);
        this.setSpacing(false);
        this.setAlignItems(FlexComponent.Alignment.STRETCH);
        this.readValue(oldValue);
    }

    private void addDateFields() {
        this.datePicker.addValueChangeListener(arg_0 -> this.onDateValueChange(arg_0));
        this.dateRangePicker.addValueChangeListener(arg_0 -> this.onDateRangeValueChange(arg_0));
        this.datePicker.setI18n(DatePickerI18nUtils.getDatePickerI18n());
        this.updateDateFieldsVisibility();
        this.add(new Component[]{this.dateRangeEnable, this.datePicker, this.dateRangePicker});
    }

    private void addDiffusionWaze() {
        this.add(new Component[]{this.diffusionWaze});
    }

    private void addPatrolStateFields() {
        this.cbPatrolState.setItemLabelGenerator((ItemLabelGenerator & Serializable)patrolState -> this.getTranslation(patrolState.getUnlocalizedName(), new Object[0]));
        this.cbPatrolState.setItems((Object[])PatrolStateValue.values());
        this.cbPatrolState.setDefaultValue((Object)PatrolStateValue.ALL);
        if (!this.patrolMctListService.canShowInProgressPatrols()) {
            this.cbPatrolState.setReadOnly(true);
            this.cbPatrolState.setValue((Object)PatrolStateValue.COMPLETED);
        }
        this.add(new Component[]{this.cbPatrolState});
    }

    private void addPatrolVisaFields() {
        this.cbPatrolVisa.setItemLabelGenerator(VisaValue::getUnlocalizedName);
        this.cbPatrolVisa.setItems((Object[])VisaValue.values());
        this.cbPatrolVisa.setDefaultValue((Object)VisaValue.BOTH);
        this.add(new Component[]{new Hr(), this.cbPatrolVisa});
    }

    private void addDelegationAndCenterFields() {
        this.delegationAndCenterField.setDelegationPlaceholder(this.getTranslation("mct.filtre.delegation.toutes", new Object[0]));
        this.delegationAndCenterField.setCenterPlaceholder(this.getTranslation("mct.filtre.centre.tous", new Object[0]));
        this.add(new Component[]{this.delegationAndCenterField});
    }

    private void addAgentField() {
        this.mscbAgent.setItemLabelGenerator((ItemLabelGenerator & Serializable)user -> user.getNom() + " (" + user.getCode() + ")");
        this.mscbAgent.setAutoExpand(MultiSelectComboBox.AutoExpandMode.VERTICAL);
        this.mscbAgent.setPlaceholder("Tous les agents");
        this.mscbAgent.setClearButtonVisible(true);
        this.mscbAgent.setItems(this.agents.values());
        this.delegationAndCenterField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            DelegationAndCenter value = (DelegationAndCenter)event.getValue();
            String delegation = value.getDelegation();
            String center = value.getCenter();
            this.mscbAgent.clear();
            if (value.isEmpty()) {
                this.mscbAgent.getListDataView().removeFilters();
            } else {
                this.mscbAgent.getListDataView().setFilter((SerializablePredicate & Serializable)userVaadinBean -> !(delegation != null && !delegation.equalsIgnoreCase(userVaadinBean.getDelegation()) && userVaadinBean.getDelegation() != null || center != null && !center.equalsIgnoreCase(userVaadinBean.getCentre()) && userVaadinBean.getCentre() != null));
            }
        });
        this.add(new Component[]{this.mscbAgent});
    }

    private void configureDelegationAndCenterRestrictions() {
        if (this.patrolMctListService.isAutoLockDelegationAndCenter() && this.currentUser.getDelegation() != null) {
            this.delegationAndCenterField.setValue((Object)DelegationAndCenter.of((Delegation)this.currentUser.getDelegation(), (Centre)this.currentUser.getCentre()));
            if (this.currentUser.getCentre() != null) {
                this.delegationAndCenterField.setReadOnly(true);
            } else {
                this.delegationAndCenterField.setDelegationReadOnly();
            }
        }
    }

    private void addBusinessModuleFields() {
        this.cbgBusinessModule.setItemLabelGenerator(ModuleMetier::getLibelle);
        this.cbgBusinessModule.addThemeVariants((ThemeVariant[])new CheckboxGroupVariant[]{CheckboxGroupVariant.LUMO_VERTICAL});
        this.cbgBusinessModule.setItems(this.businessModules.values());
        this.cbgBusinessModule.setVisible(this.businessModules.size() > 1);
        this.add(new Component[]{this.cbgBusinessModule});
    }

    private void readValue(PatrolFilter patrolFilter) {
        VehicleFilter vehicleFilter = patrolFilter.getVehicleFilter();
        LocalDate minDate = PatrolFilterEditForm.sqlTimestampToLocalDate((Timestamp)vehicleFilter.dateMin);
        LocalDate maxDate = PatrolFilterEditForm.sqlTimestampToLocalDate((Timestamp)vehicleFilter.dateMax);
        this.datePicker.setValue(minDate);
        this.dateRangePicker.setValue((Object)new DateRange(minDate, maxDate));
        this.dateRangeEnable.setValue((Object)(minDate != null && maxDate != null && !minDate.equals(maxDate) ? 1 : 0));
        if (this.patrolMctListService.canShowInProgressPatrols()) {
            this.cbPatrolState.setValue((Object)PatrolStateValue.getByFilterValue((int)vehicleFilter.termine));
        }
        if (this.patrolMctListService.isPatrolVisaActive() && this.patrolMctListService.isPatrolVisaAllowedForCurrentUser()) {
            this.cbPatrolVisa.setValue((Object)VisaValue.getByFilterValue((Boolean)vehicleFilter.patrouillesVisees));
        }
        this.diffusionWaze.setValue((Object)vehicleFilter.diffusionWaze);
        this.delegationAndCenterField.setValue((Object)new DelegationAndCenter(vehicleFilter.delegation, vehicleFilter.centre));
        this.mscbAgent.setValue(vehicleFilter.agents == null ? Set.of() : vehicleFilter.agents.stream().map(this.agents::get).collect(Collectors.toSet()));
        this.cbgBusinessModule.setValue(vehicleFilter.codeModuleMetier == null ? Set.of() : vehicleFilter.codeModuleMetier.stream().map(this.businessModules::get).collect(Collectors.toUnmodifiableSet()));
    }

    private void updateDateFieldsVisibility() {
        boolean dateRangeEnabled = (Boolean)this.dateRangeEnable.getValue();
        this.datePicker.setVisible(!dateRangeEnabled);
        this.dateRangePicker.setVisible(dateRangeEnabled);
    }

    private void onDateValueChange(HasValue.ValueChangeEvent<LocalDate> event) {
        if (event.isFromClient()) {
            this.dateRangePicker.setValue((Object)new DateRange((LocalDate)event.getValue(), ((DateRange)this.dateRangePicker.getValue()).getEnd()));
            if (this.patrolMctListService.canShowInProgressPatrols() && ((PatrolStateValue)this.cbPatrolState.getValue()).equals((Object)PatrolStateValue.IN_PROGRESS) && this.datePicker.getValue() != null) {
                if (((LocalDate)this.datePicker.getValue()).isBefore(LocalDate.now())) {
                    this.cbPatrolState.setValue((Object)PatrolStateValue.COMPLETED);
                } else {
                    this.cbPatrolState.setValue((Object)PatrolStateValue.ALL);
                }
            }
        }
    }

    private void onDateRangeValueChange(HasValue.ValueChangeEvent<DateRange> event) {
        if (event.isFromClient()) {
            this.datePicker.setValue(((DateRange)event.getValue()).getBeginning());
            if (this.patrolMctListService.canShowInProgressPatrols() && ((PatrolStateValue)this.cbPatrolState.getValue()).equals((Object)PatrolStateValue.IN_PROGRESS) && ((DateRange)this.dateRangePicker.getValue()).getEnd() != null) {
                if (((DateRange)this.dateRangePicker.getValue()).getEnd().isBefore(LocalDate.now())) {
                    this.cbPatrolState.setValue((Object)PatrolStateValue.COMPLETED);
                } else {
                    this.cbPatrolState.setValue((Object)PatrolStateValue.ALL);
                }
            }
        }
    }

    public PatrolFilter getValue() {
        IBusinessService.VehiculeFiltre filter;
        IBusinessService.VehiculeFiltre vehiculeFiltre = filter = this.oldValue != null ? (IBusinessService.VehiculeFiltre)DeepCopy.copy((Object)this.oldValue.getVehicleFilter()) : new IBusinessService.VehiculeFiltre();
        if (((Boolean)this.dateRangeEnable.getValue()).booleanValue()) {
            DateRange dateRange = (DateRange)this.dateRangePicker.getValue();
            filter.dateMin = PatrolFilterEditForm.localDateToSqlTimestamp((LocalDate)dateRange.getBeginning(), (boolean)false);
            filter.dateMax = PatrolFilterEditForm.localDateToSqlTimestamp((LocalDate)(dateRange.getEnd() != null ? dateRange.getEnd() : LocalDate.now()), (boolean)true);
        } else if (!this.datePicker.isEmpty()) {
            LocalDate date = (LocalDate)this.datePicker.getValue();
            filter.dateMin = PatrolFilterEditForm.localDateToSqlTimestamp((LocalDate)date, (boolean)false);
            filter.dateMax = PatrolFilterEditForm.localDateToSqlTimestamp((LocalDate)date, (boolean)true);
        } else {
            filter.dateMin = null;
            filter.dateMax = null;
        }
        filter.termine = ((PatrolStateValue)this.cbPatrolState.getValue()).getFilterValue();
        if (this.patrolMctListService.isPatrolVisaActive() && this.patrolMctListService.isPatrolVisaAllowedForCurrentUser()) {
            filter.patrouillesVisees = ((VisaValue)this.cbPatrolVisa.getValue()).getFilterValue();
        }
        filter.diffusionWaze = (Boolean)this.diffusionWaze.getValue();
        DelegationAndCenter delegationAndCenter = (DelegationAndCenter)this.delegationAndCenterField.getValue();
        filter.delegation = delegationAndCenter.getDelegation();
        filter.centre = delegationAndCenter.getCenter();
        filter.agents = this.mscbAgent.isEmpty() ? null : this.mscbAgent.getValue().stream().map(UserVaadinBean::getId).toList();
        filter.codeModuleMetier = ((Set)this.cbgBusinessModule.getValue()).stream().map(ModuleMetier::getCode).toList();
        return PatrolFilter.builder().unlocalizedName("mct.filtre.patrouilles.perso").vehicleFilter(filter).isCustom(true).build();
    }

    private static LocalDate sqlTimestampToLocalDate(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return timestamp.toLocalDateTime().toLocalDate();
    }

    private static Timestamp localDateToSqlTimestamp(LocalDate localDate, boolean end) {
        if (localDate == null) {
            return null;
        }
        return Timestamp.valueOf(end ? localDate.plusDays(1L).atStartOfDay().minus(1L, ChronoUnit.MILLIS) : localDate.atStartOfDay());
    }
}

