/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.patrol.filter;

import com.neogls.prism.central.vaadin.view.mct.common.patrol.filter.PatrolFilter;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.filter.PatrolFilterEditDialog;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.filter.PatrolFilterEditForm;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolMctListService;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.shared.ThemeVariant;

public class PatrolFilterEditDialog
extends Dialog {
    private final Button bValidate = new Button(this.getTranslation("mct.filtre.valider", new Object[0]), arg_0 -> this.onValidateClick(arg_0));
    private final Button bCancel = new Button(this.getTranslation("mct.filtre.annuler", new Object[0]), arg_0 -> this.onCancelClick(arg_0));
    private final PatrolFilterEditForm patrolFilterEditForm;

    public PatrolFilterEditDialog(PatrolFilter value, PatrolMctListService patrolMctListService) {
        this.bValidate.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.bCancel.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
        this.patrolFilterEditForm = new PatrolFilterEditForm(value, patrolMctListService);
        this.patrolFilterEditForm.setSizeFull();
        this.setHeaderTitle(this.getTranslation("mct.filter.edit", new Object[0]));
        this.add(new Component[]{this.patrolFilterEditForm});
        this.getFooter().add(new Component[]{this.bCancel, this.bValidate});
        this.setCloseOnOutsideClick(false);
        this.setCloseOnEsc(false);
        this.setWidth(500.0f, Unit.PIXELS);
    }

    private void onValidateClick(ClickEvent<Button> event) {
        PatrolFilter filter = this.patrolFilterEditForm.getValue();
        if (filter.getVehicleFilter().dateMin == null && filter.getVehicleFilter().dateMax == null) {
            Notification notification = Notification.show((String)(this.getTranslation("filter.champ.erreur", new Object[0]) + " " + this.getTranslation("filter.date.obligatoire", new Object[0])));
            notification.addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_ERROR});
        } else {
            this.fireEvent((ComponentEvent)new ValidateEvent(this, event.isFromClient(), filter));
            this.close();
        }
    }

    private void onCancelClick(ClickEvent<Button> event) {
        this.fireEvent((ComponentEvent)new CancelEvent(this, event.isFromClient()));
        this.close();
    }

    public void addValidateListener(ComponentEventListener<ValidateEvent> listener) {
        this.addListener(ValidateEvent.class, listener);
    }

    public void addCancelListener(ComponentEventListener<CancelEvent> listener) {
        this.addListener(CancelEvent.class, listener);
    }
}

