/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.patrol.filter;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctFilterComponent;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.filter.PatrolFilter;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.filter.PatrolFilterEditDialog;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.list.PatrolMctListService;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

/*
 * Exception performing whole class analysis ignored.
 */
public class PatrolFilterComponent
extends FormLayout
implements MctFilterComponent<PatrolFilter> {
    private final ComboBox<PatrolFilter> cbFilter = new ComboBox();
    private final PatrolMctListService patrolMctListService;
    private PatrolFilter currentValue;

    public PatrolFilterComponent(PatrolMctListService patrolMctListService) {
        this.patrolMctListService = patrolMctListService;
        this.currentValue = (PatrolFilter)patrolMctListService.getDefaultFilter();
        this.cbFilter.setPlaceholder(this.getTranslation("mct.filtre.patrouilles.perso", new Object[0]));
        this.cbFilter.setItemLabelGenerator((ItemLabelGenerator & Serializable)filter -> this.getTranslation(filter.getUnlocalizedName(), new Object[0]));
        this.cbFilter.setItems((Collection)patrolMctListService.getFilters());
        this.cbFilter.setValue((Object)this.currentValue);
        this.cbFilter.addValueChangeListener(arg_0 -> this.onCbFilterValueChange(arg_0));
        Button bEditFilter = new Button((Component)VaadinIcon.PENCIL.create(), (ComponentEventListener & Serializable)event -> this.openFilterEditDialog(this.currentValue));
        HorizontalLayout filterContainer = new HorizontalLayout(new Component[]{this.cbFilter, bEditFilter});
        filterContainer.setSpacing(false);
        filterContainer.addClassName("gap-s");
        filterContainer.setFlexGrow(1.0, new HasElement[]{this.cbFilter});
        this.addFormItem((Component)filterContainer, this.getTranslation("mct.filtre.titre", new Object[0]));
        this.setResponsiveSteps(List.of(new FormLayout.ResponsiveStep("0", 1)));
    }

    private void openFilterEditDialog(PatrolFilter filterToEdit) {
        PatrolFilterEditDialog dialog = new PatrolFilterEditDialog(filterToEdit, this.patrolMctListService);
        dialog.addCancelListener((ComponentEventListener & Serializable)event -> this.cbFilter.setValue((Object)this.currentValue));
        dialog.addValidateListener((ComponentEventListener & Serializable)event -> {
            this.currentValue = event.getFilter();
            this.cbFilter.setValue((Object)this.currentValue);
            this.fireFilterChangeEvent();
        });
        dialog.open();
    }

    private void fireFilterChangeEvent() {
        this.currentValue = PatrolFilterComponent.clonePatrolFilter((PatrolFilter)this.currentValue);
        this.fireEvent((ComponentEvent)new MctFilterComponent.FilterChangeEvent((Component)this, true, (Object)this.currentValue));
    }

    private void onCbFilterValueChange(HasValue.ValueChangeEvent<PatrolFilter> event) {
        if (!event.isFromClient()) {
            return;
        }
        if (this.cbFilter.isEmpty()) {
            this.cbFilter.setValue((Object)((PatrolFilter)event.getOldValue()));
        } else if (((PatrolFilter)event.getValue()).isCustom()) {
            this.openFilterEditDialog((PatrolFilter)event.getValue());
        } else {
            this.currentValue = (PatrolFilter)event.getValue();
            this.fireFilterChangeEvent();
        }
    }

    public PatrolFilter getFilter() {
        return this.currentValue;
    }

    public void setFilter(PatrolFilter filter) {
        if (!Objects.equals(this.currentValue, filter)) {
            this.cbFilter.setValue((Object)filter);
            this.currentValue = filter;
            this.fireFilterChangeEvent();
        }
    }

    private static PatrolFilter clonePatrolFilter(PatrolFilter filter) {
        return filter.toBuilder().vehicleFilter((IBusinessService.VehiculeFiltre)DeepCopy.copy((Object)filter.getVehicleFilter())).build();
    }
}

