/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.patrol;

import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismandroid.model.TronconStats;
import com.geolocsystems.prismcentral.beans.MCIG;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.neogls.prism.central.vaadin.service.PatrolService;
import com.neogls.prism.central.vaadin.service.bean.SaltSpreaderData;
import com.neogls.prism.central.vaadin.service.logbook.LogBookService;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialogFactory;
import com.vaadin.flow.server.VaadinSession;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class PatrolDetailsDialogService {
    private final LogBookService logBookService;
    private final PatrolService patrolService;
    private final EventSheetDialogFactory eventSheetDialogFactory;

    @Nullable
    public MCIG getPatrolMcig(@Nonnull VehiculeEnIntervention patrol) {
        return this.logBookService.findMcigById(patrol.getMcigId()).orElse(null);
    }

    @Nonnull
    public Collection<SaltSpreaderData> getSaltSpreaderLocationData(@Nonnull VehiculeEnIntervention patrol) {
        return this.patrolService.getSaltSpreaderLocationData(patrol.getIdPatrouille(), VaadinSession.getCurrent().getLocale());
    }

    public boolean canShowPatrolImage() {
        return this.logBookService.canShowPatrolImage();
    }

    public List<TronconStats> getResumeRoads(VehiculeEnIntervention patrol) {
        return this.patrolService.getResumeRoads(patrol);
    }

    public void aDefinir(String codeModuleMetier) {
        String[] listeMmBilan = this.patrolService.getTableauString("mct.bilanLineaire.mm", ConstantesPrismCommun.CONFIG_MCT_BILAN_LINEAIRE_ACTIVITE_MM_DEFAUT);
        String[] listeCchBilan = this.patrolService.getTableauString("mct.bilanLineaire.cch".concat(".").concat(codeModuleMetier), null);
    }

    @Generated
    public PatrolDetailsDialogService(LogBookService logBookService, PatrolService patrolService, EventSheetDialogFactory eventSheetDialogFactory) {
        this.logBookService = logBookService;
        this.patrolService = patrolService;
        this.eventSheetDialogFactory = eventSheetDialogFactory;
    }

    @Generated
    public LogBookService getLogBookService() {
        return this.logBookService;
    }

    @Generated
    public EventSheetDialogFactory getEventSheetDialogFactory() {
        return this.eventSheetDialogFactory;
    }
}

