/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.patrol;

import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismandroid.model.TronconStats;
import com.geolocsystems.prismcentral.beans.MCIG;
import com.geolocsystems.prismcentral.beans.VehiculeEnIntervention;
import com.neogls.prism.central.vaadin.common.component.tabsheet.PrismTabSheet;
import com.neogls.prism.central.vaadin.rest.export.patrol.PatrolExportController;
import com.neogls.prism.central.vaadin.rest.export.patrol.SaltSpreaderDataExportController;
import com.neogls.prism.central.vaadin.view.export.logbook.LogBookViewer;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.PatrolDetailsDialogService;
import com.neogls.prism.central.vaadin.view.mct.common.patrol.SaltSpreaderDataGrid;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.checkbox.CheckboxGroup;
import com.vaadin.flow.component.checkbox.CheckboxGroupVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.dataview.GridListDataView;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.AnchorTarget;
import com.vaadin.flow.component.html.AnchorTargetValue;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.VaadinSession;
import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PatrolDetailsDialog
extends Dialog {
    private final VehiculeEnIntervention patrol;
    private final Collection<Integer> mmCodes;
    private final PatrolDetailsDialogService service;

    public PatrolDetailsDialog(@Nonnull VehiculeEnIntervention patrol, @Nonnull Collection<Integer> mmCodes, @Nonnull PatrolDetailsDialogService service) {
        this.patrol = patrol;
        this.mmCodes = mmCodes;
        this.service = service;
        PrismTabSheet tabSheet = new PrismTabSheet();
        tabSheet.add("Main courante", this.createLogBookViewer());
        tabSheet.add("Localisation", this.createLocalisationTab());
        tabSheet.add("R\u00e9sum\u00e9", this.createResumeTab());
        tabSheet.setSizeFull();
        this.add(new Component[]{tabSheet});
        this.getFooter().add(new Component[]{this.createCloseButton()});
        this.setSizeFull();
    }

    @Nonnull
    private Component createLogBookViewer() {
        MCIG mcig = this.service.getPatrolMcig(this.patrol);
        if (mcig == null) {
            return new Span("Pas de main courante");
        }
        LogBookViewer logBookViewer = new LogBookViewer(mcig, this.service.getLogBookService(), this.service.getEventSheetDialogFactory());
        logBookViewer.setSizeFull();
        return logBookViewer;
    }

    @Nonnull
    private Component createLocalisationTab() {
        Collection saltSpreaderData = this.service.getSaltSpreaderLocationData(this.patrol);
        SaltSpreaderDataGrid grid = new SaltSpreaderDataGrid(this.mmCodes, saltSpreaderData);
        Anchor bDownloadCSV = new Anchor(SaltSpreaderDataExportController.Helper.createSaltSpreaderDataExportURL((String)this.patrol.getIdPatrouille(), (Collection)this.mmCodes, (Locale)VaadinSession.getCurrent().getLocale()), new Component[]{new Button(this.getTranslation("mct.action.export.csv", new Object[0]), (Component)new Image("images/ico/export.png", ""))});
        bDownloadCSV.setTarget((AnchorTargetValue)AnchorTarget.BLANK);
        bDownloadCSV.addClassName("mx-auto");
        VerticalLayout layoutLocalisation = new VerticalLayout(new Component[]{grid, bDownloadCSV});
        layoutLocalisation.setSizeFull();
        layoutLocalisation.setPadding(false);
        return layoutLocalisation;
    }

    @Nonnull
    private Component createResumeTab() {
        List tronconsData = this.service.getResumeRoads(this.patrol);
        Grid grid = new Grid();
        grid.setWidth(100.0f, Unit.PERCENTAGE);
        grid.setHeight(800.0f, Unit.PIXELS);
        grid.addColumn(Troncon::getAxe).setHeader(this.getTranslation("localisation.axe", new Object[0])).setVisible(true);
        grid.addColumn(Troncon::getClassification).setHeader(this.getTranslation("patrouille.resume.etat", new Object[0])).setVisible(true);
        grid.addColumn((ValueProvider & Serializable)t -> String.valueOf(t.getPrDebut()) + "+" + String.valueOf(t.getAbscissePrDebut())).setHeader(this.getTranslation("localisation.prdeb", new Object[0])).setVisible(true);
        grid.addColumn((ValueProvider & Serializable)t -> String.valueOf(t.getPrFin()) + "+" + String.valueOf(t.getAbscissePrFin())).setHeader(this.getTranslation("localisation.prfin", new Object[0])).setVisible(true);
        grid.addColumn(Troncon::getSensNumerique).setHeader(this.getTranslation("localisation.pr.sens", new Object[0])).setVisible(true);
        grid.addColumn((ValueProvider & Serializable)t -> t.getLongueur() + "m").setHeader(this.getTranslation("patrouille.resume.distance", new Object[0])).setVisible(true);
        grid.addColumn((ValueProvider & Serializable)t -> (t.getDerniereDate() - t.getPremiereDate()) / 1000L + "s").setHeader(this.getTranslation("patrouille.resume.duree", new Object[0])).setVisible(true);
        GridListDataView dataView = (GridListDataView)grid.setItems((Collection)tronconsData);
        HashMap<String, Integer> lengthByCch = new HashMap<String, Integer>();
        for (TronconStats t2 : tronconsData) {
            Integer length = (Integer)lengthByCch.get(t2.getClassification());
            if (length == null) {
                lengthByCch.put(t2.getClassification(), t2.getLongueur());
                continue;
            }
            lengthByCch.put(t2.getClassification(), length + t2.getLongueur());
        }
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        checkboxGroup.setLabel("Filtrer");
        checkboxGroup.setItems(lengthByCch.keySet());
        checkboxGroup.select(lengthByCch.keySet());
        checkboxGroup.addThemeVariants((ThemeVariant[])new CheckboxGroupVariant[]{CheckboxGroupVariant.LUMO_VERTICAL});
        this.add(new Component[]{checkboxGroup});
        checkboxGroup.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> dataView.refreshAll());
        Anchor bDownloadCSV = new Anchor(PatrolExportController.Helper.createPatrolResumeExportURL((VehiculeEnIntervention)this.patrol, (Collection)this.mmCodes, (Locale)VaadinSession.getCurrent().getLocale(), (List)this.getCodesForExport(checkboxGroup)), new Component[]{new Button(this.getTranslation("mct.action.export.csv", new Object[0]), (Component)new Image("images/ico/export.png", ""))});
        dataView.addFilter((SerializablePredicate & Serializable)troncon -> {
            Set searchTerm = checkboxGroup.getSelectedItems();
            if (searchTerm.isEmpty()) {
                return true;
            }
            bDownloadCSV.setHref(PatrolExportController.Helper.createPatrolResumeExportURL((VehiculeEnIntervention)this.patrol, (Collection)this.mmCodes, (Locale)VaadinSession.getCurrent().getLocale(), (List)this.getCodesForExport(checkboxGroup)));
            return searchTerm.contains(troncon.getClassification());
        });
        bDownloadCSV.setTarget((AnchorTargetValue)AnchorTarget.BLANK);
        bDownloadCSV.addClassName("mx-auto");
        Grid gridTotal = new Grid();
        gridTotal.setWidth(100.0f, Unit.PERCENTAGE);
        gridTotal.setHeight(800.0f, Unit.PIXELS);
        gridTotal.addColumn(Map.Entry::getKey).setHeader(this.getTranslation("patrouille.resume.etat", new Object[0])).setVisible(true);
        gridTotal.addColumn(Map.Entry::getValue).setHeader(this.getTranslation("patrouille.resume.distance", new Object[0])).setVisible(true);
        gridTotal.setItems((Collection)lengthByCch.entrySet().stream().collect(Collectors.toSet()));
        VerticalLayout layoutLocalisation = new VerticalLayout(new Component[]{checkboxGroup, grid, gridTotal, bDownloadCSV});
        layoutLocalisation.setSizeFull();
        layoutLocalisation.setPadding(false);
        return layoutLocalisation;
    }

    private List<String> getCodesForExport(CheckboxGroup checkboxGroup) {
        Set searchTerm = checkboxGroup.getSelectedItems();
        return searchTerm.stream().collect(Collectors.toUnmodifiableList());
    }

    @Nonnull
    private Button createCloseButton() {
        Button closeButton = new Button(this.getTranslation("generic.close", new Object[0]), (ComponentEventListener & Serializable)event -> this.close());
        closeButton.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        return closeButton;
    }

    private String mapCCh(String classification) {
        switch (classification) {
            case "NR": {
                return "";
            }
            case "FA": {
                return "Fauchage";
            }
        }
        return classification;
    }

    private String mapSensPr(int sensNumerique) {
        switch (sensNumerique) {
            case 1: {
                return "Positif";
            }
            case 2: {
                return "N\u00e9gatif";
            }
        }
        return "NC";
    }
}

