/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.list;

import com.google.common.collect.Maps;
import com.neogls.prism.central.vaadin.view.mct.common.list.ActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctCartoComponent;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctFilterComponent;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctListItemFocusChangeEvent;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctListItemsClearEvent;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctListItemsLoadEvent;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctListItemsSelectionChangeEvent;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctListRefreshRequestEvent;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctListService;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctSortComponent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridMultiSelectionModel;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.grid.dataview.GridListDataView;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.progressbar.ProgressBar;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.renderer.ComponentRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.data.selection.SelectionListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.server.Command;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.concurrent.DelegatingSecurityContextRunnable;

public abstract class MctList<K, T, F, L extends ActionListener<T>>
extends VerticalLayout {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MctList.class);
    private final MctListService<T, F, L> mctListService;
    @Nullable
    private final MctFilterComponent<F> mctFilterComponent;
    @Nullable
    private final MctSortComponent<T> mctSortComponent;
    private final MctCartoComponent<T> mctCartoComponent;
    private final L actionListener;
    private final Span labelItemCount = new Span();
    private final Button bSelectAll = new Button(this.getTranslation("mct.action.select.all", new Object[0]));
    private final Button bDeselectAll = new Button(this.getTranslation("mct.multiple.clear", new Object[0]), (Component)new Image("images/ico/clear.png", null));
    private final HorizontalLayout selectionButtons = new HorizontalLayout(new Component[]{this.bSelectAll, this.bDeselectAll});
    private final Grid<T> grid = new Grid();
    private final Span labelSelectedItemCount = new Span();
    @Nullable
    private final HasEnabled selectionActionComponent;
    private final VerticalLayout gridContainer = new VerticalLayout(new Component[]{this.labelItemCount, this.grid});
    private final ProgressBar progressBar = new ProgressBar();
    private final String logPrefix = this.getClass().getSimpleName();
    private List<T> items = List.of();
    private Set<T> selectedItems = Set.of();
    private Map<K, T> itemsByKey = Map.of();
    @Nullable
    private K focusedItem = null;

    protected MctList(MctListService<T, F, L> mctListService, @Nullable MctFilterComponent<F> mctFilterComponent, @Nullable MctSortComponent<T> mctSortComponent, MctCartoComponent<T> mctCartoComponent, L actionListener) {
        this.mctListService = mctListService;
        this.mctFilterComponent = mctFilterComponent;
        this.mctSortComponent = mctSortComponent;
        this.mctCartoComponent = mctCartoComponent;
        this.actionListener = actionListener;
        this.selectionActionComponent = mctListService.createSelectionActionComponent(actionListener, this);
        this.init();
    }

    private void init() {
        this.bSelectAll.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.bDeselectAll.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.selectionButtons.setSpacing(false);
        this.selectionButtons.setFlexGrow(1.0, new HasElement[]{this.bSelectAll, this.bDeselectAll});
        this.selectionButtons.setWidthFull();
        this.selectionButtons.addClassName("gap-s");
        this.grid.setDetailsVisibleOnClick(false);
        this.grid.addComponentColumn(arg_0 -> ((MctListService)this.mctListService).createListItem(arg_0));
        this.grid.setItemDetailsRenderer((Renderer)new ComponentRenderer((SerializableFunction & Serializable)item -> this.mctListService.createDetails(item, (Object)this.actionListener)));
        this.grid.addThemeVariants(new GridVariant[]{GridVariant.LUMO_ROW_STRIPES, GridVariant.LUMO_COMPACT});
        this.grid.addClassName("mct-list");
        this.grid.setSizeFull();
        this.labelSelectedItemCount.setWidthFull();
        this.labelSelectedItemCount.addClassNames(new String[]{"text-center"});
        this.updateLabelSelectionItemCount(0);
        Button bRefresh = new Button((Component)VaadinIcon.REFRESH.create(), (ComponentEventListener & Serializable)event -> this.requestRefresh());
        bRefresh.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        FlexLayout itemCountContainer = new FlexLayout(new Component[]{this.labelItemCount, bRefresh});
        itemCountContainer.setAlignItems(FlexComponent.Alignment.CENTER);
        itemCountContainer.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        itemCountContainer.addClassName("gap-s");
        this.gridContainer.add(new Component[]{itemCountContainer, this.selectionButtons, this.grid});
        this.gridContainer.setSpacing(false);
        this.gridContainer.setPadding(false);
        this.gridContainer.setSizeFull();
        this.gridContainer.setAlignItems(FlexComponent.Alignment.STRETCH);
        if (this.selectionActionComponent != null) {
            this.gridContainer.add(new Component[]{this.labelSelectedItemCount});
            this.gridContainer.getElement().appendChild(new Element[]{this.selectionActionComponent.getElement()});
            this.grid.setSelectionMode(Grid.SelectionMode.MULTI);
            this.selectionActionComponent.setEnabled(false);
        } else {
            this.selectionButtons.setVisible(false);
            this.grid.setSelectionMode(Grid.SelectionMode.NONE);
        }
        this.progressBar.setWidthFull();
        this.progressBar.setMaxWidth(50.0f, Unit.EM);
        this.progressBar.setIndeterminate(true);
        this.progressBar.addClassNames(new String[]{"mx-auto", "my-xl", "px-l", "box-border"});
        this.progressBar.setVisible(false);
        this.add(new Component[]{this.gridContainer, this.progressBar});
        this.setSpacing(false);
        this.setPadding(false);
        this.addListeners();
    }

    private void addListeners() {
        this.bSelectAll.addClickListener((ComponentEventListener & Serializable)event -> ((GridMultiSelectionModel)this.grid.getSelectionModel()).selectAll());
        this.bDeselectAll.addClickListener((ComponentEventListener & Serializable)event -> this.grid.getSelectionModel().deselectAll());
        this.grid.addItemClickListener((ComponentEventListener & Serializable)event -> this.focusItem(this.grid.isDetailsVisible(event.getItem()) ? null : this.getKey(event.getItem())));
        if (this.selectionActionComponent != null) {
            this.grid.addSelectionListener((SelectionListener & Serializable)event -> {
                this.selectedItems = event.getAllSelectedItems();
                MctListItemsSelectionChangeEvent itemsSelectionChangeEvent = new MctListItemsSelectionChangeEvent(this, event.isFromClient(), this.selectedItems);
                this.fireEvent((ComponentEvent)itemsSelectionChangeEvent);
                this.getUI().ifPresent(ui -> ui.access((Command & Serializable)() -> {
                    this.updateLabelSelectionItemCount(this.selectedItems.size());
                    this.selectionActionComponent.setEnabled(!this.selectedItems.isEmpty());
                    itemsSelectionChangeEvent.executeUiAccesses(ui);
                }));
            });
        }
        if (this.mctFilterComponent != null) {
            this.mctFilterComponent.addFilterChangeListener((ComponentEventListener & Serializable)e -> this.requestRefresh());
        }
        if (this.mctSortComponent != null) {
            this.mctSortComponent.addSortChangeListener((ComponentEventListener & Serializable)e -> this.grid.getListDataView().setSortComparator(e.getSort()));
        }
        this.mctCartoComponent.addItemClickListener(arg_0 -> this.onItemClickedInMap(arg_0));
        this.mctCartoComponent.addItemDoubleClickListener(arg_0 -> this.onItemDoubleClickedInMap(arg_0));
        this.actionListener.setRefreshItemCallback((ActionListener.RefreshItemCallback & Serializable)item -> this.grid.getListDataView().refreshItem(item));
        this.actionListener.setRefreshAllCallback(() -> this.requestRefresh());
    }

    private void updateLabelSelectionItemCount(int selectionItemCount) {
        this.labelSelectedItemCount.setText(selectionItemCount + " " + this.getTranslation("mct.multiple.nbselect", new Object[0]));
    }

    private void onItemClickedInMap(MctCartoComponent.ItemClickEvent<T> event) {
        Object item = event.getItem();
        this.fireEvent((ComponentEvent)new MctCartoComponent.ItemClickEvent((Component)this, event.isFromClient(), item));
        this.focusItem(this.getKey(item));
        this.getUI().ifPresent(ui -> ui.access((Command & Serializable)() -> {
            try {
                ui.push();
                Thread.sleep(200L);
                this.grid.scrollToIndex((int)this.grid.getListDataView().getItems().takeWhile(Predicate.not(item::equals)).count());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }));
    }

    private void onItemDoubleClickedInMap(MctCartoComponent.ItemDoubleClickEvent<T> event) {
        this.fireEvent((ComponentEvent)new MctCartoComponent.ItemDoubleClickEvent((Component)this, event.isFromClient(), event.getItem()));
    }

    private void focusItem(@Nullable K key) {
        Object item = this.itemsByKey.get(key);
        Object previousItem = this.itemsByKey.get(this.focusedItem);
        if (item == null || key == null) {
            if (previousItem != null) {
                this.grid.setDetailsVisible(previousItem, false);
            }
            this.mctCartoComponent.focusOn(null);
        } else {
            if (previousItem != null) {
                this.grid.setDetailsVisible(previousItem, false);
            }
            this.grid.setDetailsVisible(item, true);
            this.mctCartoComponent.focusOn(item, !key.equals(this.focusedItem));
        }
        this.focusedItem = key;
        MctListItemFocusChangeEvent focusChangeEvent = new MctListItemFocusChangeEvent(this, previousItem, item);
        this.fireEvent((ComponentEvent)focusChangeEvent);
        this.getUI().ifPresent(ui -> ui.access((Command & Serializable)() -> focusChangeEvent.executeUiAccesses(ui)));
    }

    protected abstract String getItemCountLabelText(int var1);

    @Nullable
    protected abstract K getKey(@Nullable T var1);

    private void requestRefresh() {
        log.debug("[{}] Requesting refresh", (Object)this.logPrefix);
        this.fireEvent((ComponentEvent)new MctListRefreshRequestEvent(this));
    }

    public CompletableFuture<Void> refreshItems() {
        List<Object> selectedItemKeys = this.selectedItems.stream().map(arg_0 -> this.getKey(arg_0)).toList();
        this.mctCartoComponent.renderItems(List.of());
        this.labelItemCount.setText(null);
        if (this.mctFilterComponent != null) {
            this.mctFilterComponent.setEnabled(false);
        }
        if (this.mctSortComponent != null) {
            this.mctSortComponent.setEnabled(false);
        }
        this.gridContainer.setVisible(false);
        this.progressBar.setVisible(true);
        MctListItemsClearEvent itemsClearEvent = new MctListItemsClearEvent(this);
        this.fireEvent((ComponentEvent)itemsClearEvent);
        this.getUI().ifPresent(ui -> ui.access((Command & Serializable)() -> itemsClearEvent.executeUiAccesses(ui)));
        return CompletableFuture.runAsync((Runnable)new DelegatingSecurityContextRunnable(() -> {
            try {
                Object filter = this.mctListService.editFilterBeforeItemRequest(this.mctFilterComponent != null ? this.mctFilterComponent.getFilter() : this.mctListService.getDefaultFilter());
                log.debug("[{}] Loading items", (Object)this.logPrefix);
                this.items = this.mctListService.getItems(filter);
                this.itemsByKey = Maps.uniqueIndex((Iterable)this.items, arg_0 -> this.getKey(arg_0));
                log.debug("[{}] Items loaded", (Object)this.logPrefix);
                MctListItemsLoadEvent itemsLoadEvent = new MctListItemsLoadEvent(this);
                this.fireEvent((ComponentEvent)itemsLoadEvent);
                this.getUI().ifPresent(ui -> ui.access((Command & Serializable)() -> {
                    this.labelItemCount.setText(this.getItemCountLabelText(this.items.size()));
                    GridListDataView dataView = (GridListDataView)this.grid.setItems((Collection)this.items);
                    if (this.mctSortComponent != null) {
                        dataView.setSortComparator(this.mctSortComponent.getSort());
                    }
                    itemsLoadEvent.executeUiAccesses(ui);
                }));
            }
            catch (Exception e) {
                log.error("[{}] Error while loading items", (Object)this.logPrefix, (Object)e);
                this.items = List.of();
                this.getUI().ifPresent(ui -> ui.access((Command & Serializable)() -> this.grid.setItems(List.of())));
            }
            finally {
                this.getUI().ifPresent(ui -> ui.access((Command & Serializable)() -> {
                    this.mctCartoComponent.renderItems((Collection)this.items);
                    this.focusItem(this.focusedItem);
                    selectedItemKeys.stream().map(this.itemsByKey::get).filter(Objects::nonNull).forEach(arg_0 -> ((Grid)this.grid).select(arg_0));
                    if (this.mctFilterComponent != null) {
                        this.mctFilterComponent.setEnabled(true);
                    }
                    if (this.mctSortComponent != null) {
                        this.mctSortComponent.setEnabled(true);
                    }
                    this.gridContainer.setVisible(true);
                    this.progressBar.setVisible(false);
                }));
            }
        }));
    }

    public void addItemsLoadListener(ComponentEventListener<MctListItemsLoadEvent<T>> listener) {
        this.addListener(MctListItemsLoadEvent.class, listener);
    }

    public void addItemsClearListener(ComponentEventListener<MctListItemsClearEvent<T>> listener) {
        this.addListener(MctListItemsClearEvent.class, listener);
    }

    public void addItemsSelectionChangeListener(ComponentEventListener<MctListItemsSelectionChangeEvent<T>> listener) {
        this.addListener(MctListItemsSelectionChangeEvent.class, listener);
    }

    public void addRefreshRequestListener(ComponentEventListener<MctListRefreshRequestEvent<T>> listener) {
        this.addListener(MctListRefreshRequestEvent.class, listener);
    }

    public void addItemFocusChangeListener(ComponentEventListener<MctListItemFocusChangeEvent<T>> listener) {
        this.addListener(MctListItemFocusChangeEvent.class, listener);
    }

    public void addInMapItemClickListener(ComponentEventListener<MctCartoComponent.ItemClickEvent<T>> listener) {
        this.addListener(MctCartoComponent.ItemClickEvent.class, listener);
    }

    public void addInMapItemDoubleClickListener(ComponentEventListener<MctCartoComponent.ItemDoubleClickEvent<T>> listener) {
        this.addListener(MctCartoComponent.ItemDoubleClickEvent.class, listener);
    }

    @Nullable
    @Generated
    public MctFilterComponent<F> getMctFilterComponent() {
        return this.mctFilterComponent;
    }

    @Generated
    public List<T> getItems() {
        return this.items;
    }

    @Generated
    public Set<T> getSelectedItems() {
        return this.selectedItems;
    }
}

