/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.list;

import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenter;
import com.neogls.prism.central.vaadin.service.BusinessModuleService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctListService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;

public abstract class AbstractMctListService<T, F, L>
implements MctListService<T, F, L> {
    private final IBusinessService businessService;
    private final UserPermissionService userPermissionService;
    private final BusinessModuleService businessModuleService;

    public List<F> getFilters() {
        return List.of(this.getDefaultFilter());
    }

    public F editFilterBeforeItemRequest(F filter) {
        return filter;
    }

    public List<Integer> getBusinessModuleCodes() {
        int primaryMmCode = this.getPrimaryBusinessModuleCode();
        if (primaryMmCode == -1) {
            throw new IllegalStateException("Primary business module code not found");
        }
        return this.businessModuleService.getInheritedBusinessModules(List.of(Integer.valueOf(primaryMmCode))).stream().flatMap(businessModule -> Stream.concat(Stream.of(Integer.valueOf(businessModule.getCode())), this.businessModuleService.getOtherBusinessModulesParameter(businessModule).stream().map(ModuleMetier::getCode))).distinct().toList();
    }

    public AuthenticatedUser getCurrentUser() {
        return this.userPermissionService.getCurrentUser();
    }

    public DelegationAndCenter getCurrentUserDelegationAndCenter() {
        return DelegationAndCenter.of((Delegation)this.getCurrentUser().getDelegation(), (Centre)this.getCurrentUser().getCentre());
    }

    public Collection<Delegation> getActiveDelegations() {
        return this.businessService.getDelegationsActives();
    }

    public Collection<Centre> getActiveCenters() {
        return this.getActiveDelegations().stream().map(Delegation::getCentres).flatMap(Collection::stream).toList();
    }

    @Generated
    public AbstractMctListService(IBusinessService businessService, UserPermissionService userPermissionService, BusinessModuleService businessModuleService) {
        this.businessService = businessService;
        this.userPermissionService = userPermissionService;
        this.businessModuleService = businessModuleService;
    }
}

