/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field.localisation.prabs;

import com.neogls.prism.central.vaadin.view.mct.common.field.localisation.prabs.PrAbsLabel;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public class PrAbsLabel
extends Composite<TextField> {
    private final Button bEdit = new Button();
    private final IntSupplier prGetter;
    private final IntSupplier absGetter;
    private final Supplier<String> deptGetter;

    public PrAbsLabel(IntSupplier prGetter, IntSupplier absGetter, Supplier<String> deptGetter) {
        this.prGetter = prGetter;
        this.absGetter = absGetter;
        this.deptGetter = deptGetter;
        ((TextField)this.getContent()).setReadOnly(true);
    }

    public PrAbsLabel(IntSupplier prGetter, IntSupplier absGetter, Supplier<String> deptGetter, EditButtonClickListener editButtonClickListener) {
        this(prGetter, absGetter, deptGetter);
        Icon icon = VaadinIcon.PENCIL.create();
        icon.setColor("var(--lumo-primary-color)");
        this.bEdit.setIcon((Component)icon);
        this.bEdit.addClickListener((ComponentEventListener & Serializable)event -> editButtonClickListener.onClick(prGetter.getAsInt(), absGetter.getAsInt(), (String)deptGetter.get()));
        ((TextField)this.getContent()).setSuffixComponent((Component)this.bEdit);
    }

    public void updateUI() {
        ((TextField)this.getContent()).setValue(this.valueToString());
    }

    private String valueToString() {
        int pr = this.prGetter.getAsInt();
        int abs = this.absGetter.getAsInt();
        String dept = (String)this.deptGetter.get();
        if (pr == -1) {
            return this.getTranslation("localisation.aucunpr", new Object[0]);
        }
        String deptPart = dept == null || "-1".equals(dept) ? "" : "(%s) ".formatted(dept);
        String prPart = String.valueOf(pr);
        String absPart = abs == -1 ? "" : " + %s".formatted(abs);
        return deptPart + prPart + absPart;
    }

    public void setReadOnly(boolean readOnly) {
        this.bEdit.setVisible(!readOnly);
    }
}

