/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field.localisation.prabs;

import com.neogls.prism.central.vaadin.view.mct.common.field.localisation.prabs.PrAbsSaveEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.dialog.DialogVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.IntegerField;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public final class PrAbsDialog
extends Dialog {
    private final ComboBox<String> dept = new ComboBox("D\u00e9partement");
    private final IntegerField pr = new IntegerField("PR");
    private final IntegerField abs = new IntegerField("ABS");

    public PrAbsDialog(int prValue, int absValue, String deptValue, List<String> departements) {
        departements = Objects.requireNonNullElse(departements, List.of());
        this.dept.setItems(departements);
        this.dept.setVisible(departements.size() > 1);
        if (departements.size() == 1) {
            this.dept.setValue((Object)departements.get(0));
        }
        this.pr.setPlaceholder(this.getTranslation("localisation.aucunpr", new Object[0]));
        HorizontalLayout content = new HorizontalLayout(new Component[]{this.dept, this.pr, new Text("+"), this.abs});
        content.setAlignItems(FlexComponent.Alignment.BASELINE);
        content.setSpacing(false);
        content.addClassNames(new String[]{"pt-0", "px-m", "pb-s", "gap-xs"});
        this.add(new Component[]{content});
        this.addThemeVariants((ThemeVariant[])new DialogVariant[]{DialogVariant.LUMO_NO_PADDING});
        Button bValidate = new Button(this.getTranslation("generic.validate", new Object[0]), (ComponentEventListener & Serializable)event -> {
            this.fireEvent((ComponentEvent)new PrAbsSaveEvent((Component)this, (Integer)this.pr.getValue(), (Integer)this.abs.getValue(), (String)this.dept.getValue()));
            this.close();
        });
        bValidate.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        bValidate.addClassName("ml-auto");
        this.getFooter().add(new Component[]{new Button(this.getTranslation("generic.cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close()), bValidate});
        this.pr.addValueChangeListener(arg_0 -> this.onPrValueChange(arg_0));
        this.setValue(prValue, absValue, deptValue);
    }

    private void onPrValueChange(HasValue.ValueChangeEvent<Integer> event) {
        this.abs.setEnabled(!event.getHasValue().isEmpty());
    }

    public void setValue(int pr, int abs, String dept) {
        if (pr != -1) {
            this.pr.setValue((Number)pr);
        } else {
            this.pr.clear();
        }
        if (abs != -1) {
            this.abs.setValue((Number)abs);
        } else {
            this.abs.clear();
        }
        if (dept != null) {
            this.dept.setValue((Object)dept);
        } else {
            this.dept.clear();
        }
    }

    public void addPrAbsSaveListener(ComponentEventListener<PrAbsSaveEvent> listener) {
        this.addListener(PrAbsSaveEvent.class, listener);
    }
}

