/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field.localisation;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLocalisation;
import com.geolocsystems.prismandroid.model.tunnel.PointParticulier;
import com.geolocsystems.prismandroid.model.tunnel.Tube;
import com.geolocsystems.prismandroid.model.tunnel.Tunnel;
import com.neogls.prism.central.vaadin.common.component.PrismFormItem;
import com.neogls.prism.central.vaadin.view.mct.common.field.localisation.ChampLocalisationComponentService;
import com.neogls.prism.central.vaadin.view.mct.common.field.localisation.TunnelSubComponent;
import com.neogls.prism.central.vaadin.view.mct.common.field.localisation.prabs.PrAbsLabel;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.binder.ValidationResult;
import java.util.Collection;
import java.util.List;

public class TunnelSubComponent
extends VerticalLayout {
    private final ComboBox<Tunnel> cbTunnel = new ComboBox();
    private final ComboBox<Tube> cbTube = new ComboBox();
    private final ComboBox<PointParticulier> cbPp = new ComboBox();
    private final Span labelAxe = new Span();
    private final PrAbsLabel labelPrDebut;
    private final ChampLocalisation field;
    private final ChampLocalisationComponentService service;
    private boolean readOnly;

    public TunnelSubComponent(ChampLocalisation field, ChampLocalisationComponentService service) {
        this.field = field;
        this.service = service;
        this.labelPrDebut = new PrAbsLabel(() -> ((ChampLocalisation)field).getPrDebut(), () -> ((ChampLocalisation)field).getAbsPrDebut(), () -> ((ChampLocalisation)field).getDeptDebut());
        this.initUI();
        this.updateUI();
    }

    private void initUI() {
        List tunnelList = this.service.getTunnelList();
        this.labelPrDebut.setReadOnly(true);
        this.cbTunnel.setItems((Collection)tunnelList);
        this.cbTunnel.addValueChangeListener(arg_0 -> this.onCbTunnelValueChange(arg_0));
        this.cbTube.setReadOnly(true);
        this.cbTube.addValueChangeListener(arg_0 -> this.onCbTubeValueChange(arg_0));
        this.cbPp.setReadOnly(true);
        this.cbPp.addValueChangeListener(arg_0 -> this.onCbPpValueChange(arg_0));
        this.add(new Component[]{new PrismFormItem(this.getTranslation("localisation.tunnel", new Object[0]), (Component)this.cbTunnel), new PrismFormItem(this.getTranslation("localisation.tube", new Object[0]), (Component)this.cbTube), new PrismFormItem(this.getTranslation("localisation.pp", new Object[0]), (Component)this.cbPp), new PrismFormItem(this.getTranslation("localisation.axe", new Object[0]), (Component)this.labelAxe), new PrismFormItem(this.getTranslation("localisation.prdeb", new Object[0]), (Component)this.labelPrDebut)});
        this.setSpacing(false);
        this.setPadding(false);
        this.setAlignItems(FlexComponent.Alignment.STRETCH);
    }

    public void updateUI() {
        Tunnel currentTunnel;
        this.cbTunnel.setReadOnly(this.readOnly);
        this.cbTunnel.clear();
        this.labelAxe.setText(this.field.getAxe());
        this.labelPrDebut.updateUI();
        int pointParticulierId = this.field.getPointParticulier();
        if (pointParticulierId == -1) {
            return;
        }
        List tunnelList = this.service.getTunnelList();
        PointParticulier pointParticulier = MetierCommun.getPointParticulier((int)pointParticulierId, (List)tunnelList);
        if (pointParticulier != null && (currentTunnel = MetierCommun.getTunnel((int)pointParticulier.getTunnel(), (List)tunnelList)) != null) {
            this.cbTunnel.setValue((Object)currentTunnel);
            Tube currentTube = MetierCommun.getTube((int)pointParticulier.getTube(), (List)tunnelList);
            if (currentTube != null) {
                this.cbTube.setValue((Object)currentTube);
                this.cbPp.setValue((Object)pointParticulier);
            }
        }
    }

    private void onCbTunnelValueChange(HasValue.ValueChangeEvent<Tunnel> event) {
        Tunnel value = (Tunnel)event.getValue();
        HasValue source = event.getHasValue();
        if (source.isEmpty()) {
            if (event.isFromClient()) {
                source.setValue((Object)((Tunnel)event.getOldValue()));
            } else {
                this.cbTube.setReadOnly(true);
                this.cbTube.clear();
            }
        } else {
            this.cbTube.setItems((Collection)value.getTubes());
            this.cbTube.setReadOnly(this.readOnly);
        }
    }

    private void onCbTubeValueChange(HasValue.ValueChangeEvent<Tube> event) {
        Tube value = (Tube)event.getValue();
        HasValue source = event.getHasValue();
        if (source.isEmpty()) {
            if (event.isFromClient()) {
                source.setValue((Object)((Tube)event.getOldValue()));
            } else {
                this.cbPp.setReadOnly(true);
                this.cbPp.clear();
            }
        } else {
            this.cbPp.setItems((Collection)value.getPp());
            this.cbPp.setReadOnly(this.readOnly);
        }
    }

    private void onCbPpValueChange(HasValue.ValueChangeEvent<PointParticulier> event) {
        if (event.getHasValue().isEmpty()) {
            if (event.isFromClient()) {
                event.getHasValue().setValue((Object)((PointParticulier)event.getOldValue()));
            } else {
                this.labelAxe.setText(null);
                this.labelPrDebut.updateUI();
            }
        } else if (event.isFromClient()) {
            this.fireEvent((ComponentEvent)new TunnelSubComponentValueChangeEvent(this, (PointParticulier)event.getValue()));
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.updateUI();
    }

    public ValidationResult validate() {
        if (this.cbPp.isEmpty()) {
            return ValidationResult.error((String)"INVALID VALUE");
        }
        return ValidationResult.ok();
    }

    public void addValueChangeListener(ComponentEventListener<TunnelSubComponentValueChangeEvent> listener) {
        this.addListener(TunnelSubComponentValueChangeEvent.class, listener);
    }
}

