/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field.localisation;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Direction;
import com.geolocsystems.prismandroid.model.Position;
import com.geolocsystems.prismandroid.model.Troncon;
import com.geolocsystems.prismandroid.model.Voie;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismandroid.model.tunnel.PointParticulier;
import com.geolocsystems.prismandroid.model.tunnel.Tunnel;
import com.geolocsystems.prismcentral.beans.LocalisationPr;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.ICartoService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.bean.Point;
import com.neogls.prism.central.vaadin.view.mct.common.field.localisation.ChampLocalisationComponentService;
import commun.UnPoint;
import gls.localisation.pr.LocalisantPr;
import gls.localisation.recherche.Recherche;
import gls.outils.ConstantesGLS;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ChampLocalisationComponentService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChampLocalisationComponentService.class);
    private final ConfigurationService configurationService;
    private final UserPermissionService userPermissionService;
    private final IBusinessService businessService;
    private final ICartoService cartoService;

    public boolean isDirectionConfigEnable() {
        return this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "gestionDirections").orElse(false);
    }

    public Optional<String> getLaneTypeLabel(@Nullable String laneType) {
        if (laneType != null && !laneType.isEmpty()) {
            return Optional.of(laneType);
        }
        if (!this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "voie.affectation").orElse(false).booleanValue()) {
            return Optional.ofNullable(laneType);
        }
        MapDescription laneAffectationDefinition = MapDescription.parse((String)this.configurationService.getString(ConfigurationService.ConfigurationType.DATABASE, "voie.affectation.definition").orElse(""));
        String configVoieAffectationType = this.configurationService.getString(ConfigurationService.ConfigurationType.DATABASE, "voie.affectation.type").orElse("centre");
        log.trace("ConfigVoieAffectationType: {}", (Object)configVoieAffectationType);
        return Optional.ofNullable(switch (configVoieAffectationType) {
            case "centre" -> {
                Centre centre = this.userPermissionService.getCurrentUser().getCentre();
                if (centre != null) {
                    yield laneAffectationDefinition.getString(centre.getNom(), null);
                }
                yield null;
            }
            case "profil" -> laneAffectationDefinition.getString(this.userPermissionService.getCurrentUser().getProfil().getName(), null);
            default -> null;
        });
    }

    public List<Tunnel> getTunnelList() {
        return this.businessService.getTunnels();
    }

    public int getUTMZone() {
        return this.configurationService.getInt(ConfigurationService.ConfigurationType.DATABASE, "zoneUTM").orElse(30);
    }

    public boolean hasEndPoint(ChampLocalisation field) {
        return !field.getType().equals("ponctuel");
    }

    public void applyTunnelPointParticulier(ChampLocalisation field, PointParticulier pointParticulier) {
        LocalisantPr localisantPr = new LocalisantPr(pointParticulier.getPr());
        field.setPrDebut(localisantPr.getPr());
        field.setAbsPrDebut((int)localisantPr.getDistancePr());
        field.setPrFin(-1);
        field.setAbsPrFin(-1);
        field.setAxe(pointParticulier.getAxe());
        field.setDeptDebut(String.valueOf(localisantPr.getDepartement()));
        UnPoint point = new UnPoint(pointParticulier.getCoordonnees().getX(), pointParticulier.getCoordonnees().getY()).toUTM(this.getUTMZone());
        field.setCommune(Recherche.rechercherPremiereCommune((float)point.x, (float)point.y));
        Position position = new Position();
        position.setX(pointParticulier.getCoordonnees().getX());
        position.setY(pointParticulier.getCoordonnees().getY());
        field.setX(new float[]{position.getX()});
        field.setY(new float[]{position.getY()});
        field.setPositionDebut(position);
        field.setPositionFin(position);
        field.setPointParticulier(pointParticulier.getId());
    }

    public void setStartPoint(ChampLocalisation field, Point point) throws CartoServiceException {
        try {
            this.cartoService.setDebut((ValeurChampLocalisation)field.getValeurChamp(), point.getLat(), point.getLng());
        }
        catch (ICartoService.LocalisationException e) {
            throw CartoServiceException.fromLocalisationException((ICartoService.LocalisationException)e);
        }
        catch (Exception e) {
            throw CartoServiceException.fromException((Exception)e);
        }
    }

    public void setEndPoint(ChampLocalisation field, Point point) throws CartoServiceException {
        try {
            this.cartoService.setFin((ValeurChampLocalisation)field.getValeurChamp(), point.getLat(), point.getLng());
        }
        catch (ICartoService.LocalisationException e) {
            throw CartoServiceException.fromLocalisationException((ICartoService.LocalisationException)e);
        }
        catch (Exception e) {
            throw CartoServiceException.fromException((Exception)e);
        }
    }

    public Optional<Voie> getCurrentLaneType(ChampLocalisation field) {
        return field.getVoies().stream().filter(voie -> voie.getLibelle().equals(field.getVoie())).findFirst();
    }

    public void setStartPR(ChampLocalisation field, @Nullable Integer pr, @Nullable Integer abs, @Nullable String dept) {
        LocalisationPr localisationPr = new LocalisationPr(field.getAxe(), Objects.requireNonNullElse(pr, -1).intValue(), Objects.requireNonNullElse(abs, -1).intValue(), Objects.requireNonNullElse(dept, "-1"));
        try {
            this.cartoService.setPrDebut((ValeurChampLocalisation)field.getValeurChamp(), localisationPr);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setEndPR(ChampLocalisation field, @Nullable Integer pr, @Nullable Integer abs, @Nullable String dept) {
        LocalisationPr localisationPr = new LocalisationPr(field.getAxe(), Objects.requireNonNullElse(pr, -1).intValue(), Objects.requireNonNullElse(abs, -1).intValue(), Objects.requireNonNullElse(dept, "-1"));
        try {
            this.cartoService.setPrFin((ValeurChampLocalisation)field.getValeurChamp(), localisationPr);
        }
        catch (ICartoService.LocalisationException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public Direction getDirection(ChampLocalisation field) {
        return this.getDirection(field.getAxe(), field.getPrDebut(), field.getAbsPrDebut());
    }

    @Nullable
    private Direction getDirection(String axe, int pr, int abs) {
        if (StringUtils.isBlank((CharSequence)axe)) {
            return null;
        }
        List directions = this.businessService.getDirections().getOrDefault(axe, List.of());
        if (directions.isEmpty()) {
            return ConstantesGLS.egal((String)axe, (String)"*") ? null : this.getDirection("*", -1, -1);
        }
        if (pr == -1 && abs == -1) {
            return (Direction)directions.get(0);
        }
        Direction dDefault = null;
        Direction dOk = null;
        for (Direction d : directions) {
            if (d.getPrDebut() != -1 && d.getAbscissePrDebut() != -1) {
                if (!this.tronconContainsPrAbs((Troncon)d, pr, abs)) continue;
                dOk = d;
                continue;
            }
            dDefault = d;
        }
        if (dOk != null) {
            return dOk;
        }
        if (dDefault != null) {
            return dDefault;
        }
        return ConstantesGLS.egal((String)axe, (String)"*") ? null : this.getDirection("*", -1, -1);
    }

    private boolean tronconContainsPrAbs(Troncon troncon, int pr, int abs) {
        LocalisantPr localisantPr = new LocalisantPr(pr, (long)abs);
        LocalisantPr localisantPrDebut = new LocalisantPr(troncon.getPrDebut(), (long)troncon.getAbscissePrDebut());
        LocalisantPr localisantPrFin = new LocalisantPr(troncon.getPrFin(), (long)troncon.getAbscissePrFin());
        return localisantPr.equals(localisantPrDebut, true) || localisantPr.equals(localisantPrFin, true) || localisantPr.estApres(localisantPrDebut) && localisantPr.estAvant(localisantPrFin);
    }

    public void inverserSens(ChampLocalisation field) {
        try {
            if (field.getPrDebut() > -1 && field.getPrFin() == -1) {
                int prFin = field.getPrFin();
                int absFin = field.getAbsPrFin();
                String deptFin = field.getDeptFin();
                field.setPrFin(field.getPrDebut());
                field.setAbsPrFin(field.getAbsPrDebut());
                field.setDeptFin(field.getDeptDebut());
                this.cartoService.inverserSens((ValeurChampLocalisation)field.getValeurChamp());
                field.setPrFin(prFin);
                field.setAbsPrFin(absFin);
                field.setDeptFin(deptFin);
            } else {
                this.cartoService.inverserSens((ValeurChampLocalisation)field.getValeurChamp());
            }
        }
        catch (ICartoService.LocalisationException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public ChampLocalisationComponentService(ConfigurationService configurationService, UserPermissionService userPermissionService, IBusinessService businessService, ICartoService cartoService) {
        this.configurationService = configurationService;
        this.userPermissionService = userPermissionService;
        this.businessService = businessService;
        this.cartoService = cartoService;
    }
}

