/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field.localisation;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.ConstantesPrismCommun;
import com.geolocsystems.prismandroid.model.Direction;
import com.geolocsystems.prismandroid.model.Position;
import com.geolocsystems.prismandroid.model.ValeurSens;
import com.geolocsystems.prismandroid.model.Voie;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.neogls.prism.central.vaadin.common.component.ErrorDialog;
import com.neogls.prism.central.vaadin.common.component.PrismFormItem;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.util.leaflet.LatLngUtils;
import com.neogls.prism.central.vaadin.view.mct.common.field.AbstractFieldComponent;
import com.neogls.prism.central.vaadin.view.mct.common.field.localisation.ChampLocalisationComponent;
import com.neogls.prism.central.vaadin.view.mct.common.field.localisation.ChampLocalisationComponentService;
import com.neogls.prism.central.vaadin.view.mct.common.field.localisation.PositionLabel;
import com.neogls.prism.central.vaadin.view.mct.common.field.localisation.TunnelSubComponent;
import com.neogls.prism.central.vaadin.view.mct.common.field.localisation.prabs.PrAbsDialog;
import com.neogls.prism.central.vaadin.view.mct.common.field.localisation.prabs.PrAbsLabel;
import com.neogls.prism.central.vaadin.view.mct.common.field.localisation.prabs.PrAbsSaveEvent;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.ValidationResult;
import gls.localisation.LocalisationInfo;
import gls.outils.ConstantesGLS;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.vaadin.addons.componentfactory.leaflet.LeafletMap;
import org.vaadin.addons.componentfactory.leaflet.layer.Layer;
import org.vaadin.addons.componentfactory.leaflet.layer.events.MouseEvent;
import org.vaadin.addons.componentfactory.leaflet.layer.groups.LayerGroup;
import org.vaadin.addons.componentfactory.leaflet.layer.ui.marker.Marker;
import org.vaadin.addons.componentfactory.leaflet.types.Icon;
import org.vaadin.addons.componentfactory.leaflet.types.LatLng;
import org.vaadin.addons.componentfactory.leaflet.types.Point;

public class ChampLocalisationComponent
extends AbstractFieldComponent<ChampLocalisation> {
    private final PrismFormItem<ComboBox<Voie>> cbLaneType;
    private final TunnelSubComponent tunnelSubComponent;
    private final LeafletMap map;
    private final ChampLocalisationComponentService service;
    private final HorizontalLayout actionLayout = new HorizontalLayout();
    private final Button bPointDebut = new Button(this.getTranslation("localisation.pointdeb", new Object[0]), (Component)new Image("images/ico/prdeb.png", null), arg_0 -> this.onPointDebutClick(arg_0));
    private final Button bPointFin = new Button(this.getTranslation("localisation.pointfin", new Object[0]), (Component)new Image("images/ico/prfin.png", null), arg_0 -> this.onPointFinClick(arg_0));
    private final PrismFormItem<TextField> tfAxe = new PrismFormItem(this.getTranslation("localisation.axe", new Object[0]), (Component)new TextField(arg_0 -> this.onTfAxeValueChange(arg_0)));
    private final PrismFormItem<Span> labelComplement = new PrismFormItem(this.getTranslation("localisation.complement", new Object[0]), (Component)new Span());
    private final PrismFormItem<PrAbsLabel> prAbsDebut;
    private final PrismFormItem<PrAbsLabel> prAbsFin;
    private final PrismFormItem<PositionLabel> labelPositionDebut = new PrismFormItem(this.getTranslation("localisation.coordonneesdeb", new Object[0]), (Component)new PositionLabel());
    private final PrismFormItem<PositionLabel> labelPositionFin = new PrismFormItem(this.getTranslation("localisation.coordonneesfin", new Object[0]), (Component)new PositionLabel());
    private final PrismFormItem<ComboBox<ValeurSens>> cbDirection = new PrismFormItem(this.getTranslation("localisation.direction", new Object[0]), (Component)new ComboBox(arg_0 -> this.onDirectionValueChange(arg_0)));
    private final LayerGroup layerGroup = new LayerGroup(new Layer[0]);
    private final boolean hasEndPoint;
    private final boolean isDirectionConfigEnable;
    private MapState mapState = MapState.NONE;
    private boolean readOnly = false;
    private boolean localizationChanged = false;

    public ChampLocalisationComponent(ChampLocalisation field, LeafletMap map, ChampLocalisationComponentService service) {
        super((Champ)field);
        this.map = Objects.requireNonNull(map);
        this.service = service;
        this.hasEndPoint = service.hasEndPoint(field);
        this.isDirectionConfigEnable = service.isDirectionConfigEnable();
        this.cbLaneType = this.createLaneTypeSelection();
        this.tunnelSubComponent = this.initTunnelSubComponent();
        this.prAbsDebut = this.initPrAbsDebutComponent();
        this.prAbsFin = this.initPrAbsFinComponent();
        this.cbDirection.setVisible(this.isDirectionConfigEnable);
        map.onClick(arg_0 -> this.onMapClick(arg_0));
        this.addContent(new Component[]{this.cbLaneType, this.tunnelSubComponent, this.createActionLayout(), this.tfAxe, this.labelComplement, this.prAbsDebut, this.prAbsFin, this.labelPositionDebut, this.labelPositionFin, this.cbDirection});
        this.layerGroup.addTo(map);
        this.addClassName("champ-localisation");
        this.addComponentValueChangeListener((ComponentEventListener & Serializable)event -> this.updateUI());
        this.updateUI();
    }

    private PrismFormItem<ComboBox<Voie>> createLaneTypeSelection() {
        ComboBox component = new ComboBox();
        List<Voie> availableLaneTypes = Optional.ofNullable(((ChampLocalisation)this.getField()).getVoies()).filter(Predicate.not(List::isEmpty)).orElse(List.of(ConstantesPrismCommun.VOIE_DEFAUT));
        component.setItems(availableLaneTypes);
        component.addValueChangeListener(arg_0 -> this.onCbLaneTypeValueChange(arg_0));
        ImmutableMap availableLaneTypesByLabel = Maps.uniqueIndex(availableLaneTypes, Voie::getLibelle);
        Voie currentValue = this.service.getLaneTypeLabel(((ChampLocalisation)this.getField()).getVoie()).map(((Map)availableLaneTypesByLabel)::get).orElse(availableLaneTypes.get(0));
        component.setValue((Object)currentValue);
        PrismFormItem container = new PrismFormItem(this.getTranslation("localisation.voie", new Object[0]), (Component)component);
        container.setVisible(availableLaneTypes.size() > 1);
        return container;
    }

    private TunnelSubComponent initTunnelSubComponent() {
        TunnelSubComponent component = new TunnelSubComponent((ChampLocalisation)this.getField(), this.service);
        component.addValueChangeListener((ComponentEventListener & Serializable)event -> {
            this.service.applyTunnelPointParticulier((ChampLocalisation)this.getField(), event.getPointParticulier());
            this.fireChangeEvent();
        });
        return component;
    }

    private PrismFormItem<PrAbsLabel> initPrAbsDebutComponent() {
        ChampLocalisation field = (ChampLocalisation)this.getField();
        PrAbsLabel component = new PrAbsLabel(() -> ((ChampLocalisation)field).getPrDebut(), () -> ((ChampLocalisation)field).getAbsPrDebut(), () -> ((ChampLocalisation)field).getDeptDebut(), (arg_0, arg_1, arg_2) -> this.openPrAbsDebutPopup(arg_0, arg_1, arg_2));
        return new PrismFormItem(this.getTranslation("localisation.prdeb", new Object[0]), (Component)component);
    }

    private PrismFormItem<PrAbsLabel> initPrAbsFinComponent() {
        ChampLocalisation field = (ChampLocalisation)this.getField();
        PrAbsLabel component = new PrAbsLabel(() -> ((ChampLocalisation)field).getPrFin(), () -> ((ChampLocalisation)field).getAbsPrFin(), () -> ((ChampLocalisation)field).getDeptFin(), (arg_0, arg_1, arg_2) -> this.openPrAbsFinPopup(arg_0, arg_1, arg_2));
        return new PrismFormItem(this.getTranslation("localisation.prfin", new Object[0]), (Component)component);
    }

    private Component createActionLayout() {
        this.bPointDebut.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.bPointFin.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        this.bPointDebut.setWidth("0");
        this.bPointFin.setWidth("0");
        this.bPointDebut.addClassName("btn-pr-selection");
        this.bPointFin.addClassName("btn-pr-selection");
        this.actionLayout.add(new Component[]{this.bPointDebut, this.bPointFin});
        this.actionLayout.setFlexGrow(1.0, new HasElement[]{this.bPointDebut, this.bPointFin});
        this.bPointFin.setVisible(this.hasEndPoint);
        this.actionLayout.setSpacing(false);
        this.actionLayout.addClassName("gap-s");
        return this.actionLayout;
    }

    private void updateUI() {
        boolean isNone;
        ChampLocalisation field = (ChampLocalisation)this.getField();
        Voie laneType = this.service.getCurrentLaneType(field).orElse(null);
        if (laneType == null) {
            this.getChildren().forEach(child -> child.setVisible(false));
            return;
        }
        boolean isPr = LocalisationInfo.estLocalisableParPrpk && laneType.isPr();
        boolean isAddress = LocalisationInfo.estLocalisableParAdresse && laneType.isAdresse();
        boolean isTunnel = laneType.isTunnel();
        boolean bl = isNone = !isPr && !isAddress && !isTunnel;
        if (this.isDirectionConfigEnable) {
            this.updateCbDirection();
            this.localizationChanged = false;
        }
        ((ComboBox)this.cbLaneType.getField()).setReadOnly(this.readOnly);
        this.tunnelSubComponent.setVisible(isTunnel);
        this.tunnelSubComponent.setReadOnly(this.readOnly);
        this.tunnelSubComponent.updateUI();
        this.actionLayout.setVisible(!this.readOnly && !isTunnel);
        this.tfAxe.setVisible(!isTunnel);
        ((TextField)this.tfAxe.getField()).setReadOnly(this.readOnly || !isPr);
        ((TextField)this.tfAxe.getField()).setValue(!ConstantesGLS.estVide((String)field.getAxe()) ? field.getAxe() : this.getTranslation("localisation.aucunaxe", new Object[0]));
        this.prAbsDebut.setVisible(isPr);
        this.prAbsFin.setVisible(isPr && this.hasEndPoint);
        ((PrAbsLabel)this.prAbsDebut.getField()).setReadOnly(this.readOnly);
        ((PrAbsLabel)this.prAbsFin.getField()).setReadOnly(this.readOnly);
        ((PrAbsLabel)this.prAbsDebut.getField()).updateUI();
        ((PrAbsLabel)this.prAbsFin.getField()).updateUI();
        this.labelPositionDebut.setVisible(isNone);
        this.labelPositionFin.setVisible(isNone && this.hasEndPoint);
        ((PositionLabel)this.labelPositionDebut.getField()).setValue(field.getPositionDebut());
        ((PositionLabel)this.labelPositionFin.getField()).setValue(field.getPositionFin());
        this.labelComplement.setVisible(MetierCommun.estComplementDiffrentRD((ValeurChampLocalisation)((ValeurChampLocalisation)field.getValeurChamp())));
        ((Span)this.labelComplement.getField()).setText(field.getComplementLocalisation());
        this.updateMap();
    }

    private void updateCbDirection() {
        ChampLocalisation field = (ChampLocalisation)this.getField();
        ComboBox cbField = (ComboBox)this.cbDirection.getField();
        cbField.clear();
        if (ConstantesGLS.estVide((String)field.getAxe())) {
            cbField.setReadOnly(true);
        } else {
            Direction direction = this.service.getDirection(field);
            if (direction == null) {
                cbField.setReadOnly(true);
            } else {
                cbField.setItems((Collection)direction.getListeSens());
                this.selectDirection(direction.getListeSens());
                cbField.setReadOnly(this.readOnly);
            }
        }
    }

    private void selectDirection(List<ValeurSens> directions) {
        ChampLocalisation field = (ChampLocalisation)this.getField();
        int sens = -1;
        if (!StringUtils.isBlank((CharSequence)field.getDirection())) {
            sens = MetierCommun.getIndiceSens(directions, (Object)field.getDirection());
        } else if (field.getSensPr() != -1) {
            sens = MetierCommun.getIndiceSens(directions, (Object)field.getSensPr());
        }
        if (sens > -1) {
            ((ComboBox)this.cbDirection.getField()).setValue((Object)directions.get(sens));
        } else {
            ((ComboBox)this.cbDirection.getField()).clear();
        }
    }

    private void updateMap() {
        this.layerGroup.clearLayers();
        ChampLocalisation field = (ChampLocalisation)this.getField();
        if (field.isComplexe()) {
            return;
        }
        int length = field.getX().length;
        if (field.getX() == null || length == 0) {
            return;
        }
        Icon iconStart = new Icon("images/ico/prdeb.png", 16);
        iconStart.setShadowSize(null);
        iconStart.setIconAnchor(Point.of((double)3.0, (double)16.0));
        Marker markerStart = new Marker(LatLngUtils.fromPosition((Position)field.getPositionDebut()));
        markerStart.setIcon(iconStart);
        markerStart.addTo(this.layerGroup);
        if (field.getPositionFin() != null && !field.getPositionFin().equals((Object)field.getPositionDebut())) {
            Icon iconEnd = new Icon("images/ico/prfin.png", 16);
            iconEnd.setShadowSize(null);
            iconEnd.setIconAnchor(Point.of((double)3.0, (double)16.0));
            Marker markerEnd = new Marker(LatLngUtils.fromPosition((Position)field.getPositionFin()));
            markerEnd.setIcon(iconEnd);
            markerEnd.addTo(this.layerGroup);
        }
    }

    private void setMapState(MapState mapState) {
        this.mapState = mapState;
        this.bPointDebut.setClassName("selected", mapState == MapState.PR_DEBUT);
        this.bPointFin.setClassName("selected", mapState == MapState.PR_FIN);
        this.map.setThemeName("cursor-pointer", mapState != MapState.NONE);
    }

    private void onCbLaneTypeValueChange(HasValue.ValueChangeEvent<Voie> event) {
        HasValue source = event.getHasValue();
        if (!event.isFromClient()) {
            return;
        }
        if (source.isEmpty()) {
            source.setValue((Object)((Voie)event.getOldValue()));
            return;
        }
        ((ChampLocalisation)this.getField()).setVoie(((Voie)event.getValue()).getLibelle());
        this.fireChangeEvent();
    }

    private void onPointDebutClick(ClickEvent<Button> event) {
        this.setMapState(this.mapState == MapState.PR_DEBUT ? MapState.NONE : MapState.PR_DEBUT);
    }

    private void onPointFinClick(ClickEvent<Button> event) {
        this.setMapState(this.mapState == MapState.PR_FIN ? MapState.NONE : MapState.PR_FIN);
    }

    private void onMapClick(MouseEvent event) {
        com.neogls.prism.central.vaadin.service.bean.Point point = LeafletUtils.latLngToPoint((LatLng)event.getLatLng());
        MapState oldMapState = this.mapState;
        if (oldMapState == MapState.NONE) {
            return;
        }
        this.setMapState(MapState.NONE);
        try {
            if (oldMapState == MapState.PR_DEBUT) {
                this.service.setStartPoint((ChampLocalisation)this.getField(), point);
            } else if (oldMapState == MapState.PR_FIN) {
                this.service.setEndPoint((ChampLocalisation)this.getField(), point);
            }
            this.localizationChanged = true;
            this.fireChangeEvent();
        }
        catch (ChampLocalisationComponentService.CartoServiceException e) {
            ErrorDialog.builder().title(this.getTranslation(e.getTitleI18n(), new Object[0])).message(this.getTranslation(e.getMessageI18n(), new Object[0])).build().open();
        }
    }

    private void onTfAxeValueChange(HasValue.ValueChangeEvent<String> event) {
        if (event.isFromClient()) {
            ((ChampLocalisation)this.getField()).setAxe((String)event.getValue());
            this.localizationChanged = true;
            this.fireChangeEvent();
        }
    }

    private void openPrAbsDebutPopup(int currentPr, int currentAbs, String currentDept) {
        PrAbsDialog dialog = new PrAbsDialog(currentPr, currentAbs, currentDept, ((ChampLocalisation)this.getField()).getDepartements());
        dialog.addPrAbsSaveListener(arg_0 -> this.onPrAbsDebutValueChange(arg_0));
        dialog.open();
    }

    private void onPrAbsDebutValueChange(PrAbsSaveEvent event) {
        if (event.isFromClient()) {
            this.service.setStartPR((ChampLocalisation)this.getField(), event.getPr(), event.getAbs(), event.getDept());
            this.localizationChanged = true;
            this.fireChangeEvent();
        }
    }

    private void openPrAbsFinPopup(int currentPr, int currentAbs, String currentDept) {
        PrAbsDialog dialog = new PrAbsDialog(currentPr, currentAbs, currentDept, ((ChampLocalisation)this.getField()).getDepartements());
        dialog.addPrAbsSaveListener(arg_0 -> this.onPrAbsFinValueChange(arg_0));
        dialog.open();
    }

    private void onPrAbsFinValueChange(PrAbsSaveEvent event) {
        if (event.isFromClient()) {
            this.service.setEndPR((ChampLocalisation)this.getField(), event.getPr(), event.getAbs(), event.getDept());
            this.localizationChanged = true;
            this.fireChangeEvent();
        }
    }

    private void onDirectionValueChange(HasValue.ValueChangeEvent<ValeurSens> event) {
        boolean inverserSens2;
        if (!event.isFromClient()) {
            return;
        }
        if (event.getHasValue().isEmpty()) {
            return;
        }
        ChampLocalisation field = (ChampLocalisation)this.getField();
        ValeurSens value = (ValeurSens)event.getValue();
        field.setDirection(value.getLibelle());
        int nouveauSens = value.getSens();
        int ancienSens = field.getSensPr();
        boolean inverserSens1 = (nouveauSens == 2 || nouveauSens == 1) && ancienSens == 0;
        boolean bl = inverserSens2 = nouveauSens == 0 && (ancienSens == 2 || ancienSens == 1);
        if (inverserSens1 || inverserSens2) {
            this.service.inverserSens(field);
        }
        field.setSensPr(nouveauSens);
        this.localizationChanged = true;
        this.fireChangeEvent();
    }

    protected void onSetReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.updateUI();
    }

    protected ValidationResult validate() {
        if (this.tunnelSubComponent.isVisible()) {
            return this.tunnelSubComponent.validate();
        }
        return ValidationResult.ok();
    }

    public boolean isEmpty() {
        return false;
    }
}

