/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field.choiximage;

import com.neogls.prism.central.vaadin.rest.comboitemicon.ComboItemIconController;
import com.neogls.prism.central.vaadin.view.mct.common.field.choiximage.ImageChoiceDialog;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import java.io.Serializable;
import java.util.Collection;

public class ImageChoiceDialog
extends Dialog {
    private final String name;
    private final int imageSize;

    protected ImageChoiceDialog(String name, Collection<String> values, int imageSize) {
        this.name = name;
        this.imageSize = imageSize <= 0 ? 50 : imageSize;
        Div layout = new Div((Component[])values.stream().map(arg_0 -> this.createImage(arg_0)).toArray(Component[]::new));
        layout.addClassName("image-choice-dialog-container");
        this.add(new Component[]{layout});
        this.getFooter().add(new Component[]{new Button(this.getTranslation("generic.cancel", new Object[0]), (ComponentEventListener & Serializable)event -> this.close())});
        this.setCloseOnOutsideClick(false);
    }

    private Component createImage(String value) {
        Image image = new Image();
        image.setSrc(ComboItemIconController.Helper.createComboItemIconURL((String)this.name, (String)value));
        image.setWidth((float)this.imageSize, Unit.PIXELS);
        image.addClickListener((ComponentEventListener & Serializable)event -> this.onImageClick(event, value));
        Span label = new Span(value);
        label.setWidth((float)this.imageSize, Unit.PIXELS);
        Div imgContainer = new Div(new Component[]{label, image});
        imgContainer.addClassName("image-container");
        return imgContainer;
    }

    private void onImageClick(ClickEvent<Image> event, String value) {
        this.fireEvent((ComponentEvent)new ImageChoiceEvent(this, event.isFromClient(), value));
        this.close();
    }

    public void addImageChoiceListener(ComponentEventListener<ImageChoiceEvent> listener) {
        this.addListener(ImageChoiceEvent.class, listener);
    }
}

