/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field.choiximage;

import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampChoixImage;
import com.neogls.prism.central.vaadin.rest.comboitemicon.ComboItemIconController;
import com.neogls.prism.central.vaadin.view.mct.common.field.AbstractFieldComponent;
import com.neogls.prism.central.vaadin.view.mct.common.field.choiximage.ImageChoiceDialog;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.Tooltip;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChampChoixImageComponent
extends AbstractFieldComponent<ChampChoixImage> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChampChoixImageComponent.class);
    private final Image image = new Image();
    private final Tooltip imageTooltip = Tooltip.forComponent((Component)this.image);
    private final Button bEdit = new Button((Component)VaadinIcon.PENCIL.create(), (ComponentEventListener & Serializable)event -> this.openImageChoiceDialog());
    private final TextField textField = new TextField();

    public ChampChoixImageComponent(ChampChoixImage field) {
        super((Champ)field);
        this.image.setHeight((float)field.getHauteurImage(), Unit.PIXELS);
        this.image.addClickListener(arg_0 -> this.onImageClick(arg_0));
        this.textField.addValueChangeListener(arg_0 -> this.onTextFieldValueChange(arg_0));
        this.updateUI();
        this.addContent(new Component[]{this.image, this.bEdit, this.textField});
        this.addClassName("champ-choix-image");
    }

    private void onImageClick(ClickEvent<Image> event) {
        if (!this.isReadOnly()) {
            this.openImageChoiceDialog();
        }
    }

    private void onTextFieldValueChange(HasValue.ValueChangeEvent<String> event) {
        if (event.isFromClient()) {
            log.debug("New 'other' value: {}", event.getValue());
            ((ChampChoixImage)this.getField()).setValeur((String)event.getValue());
            this.fireChangeEvent();
        }
    }

    private void openImageChoiceDialog() {
        ChampChoixImage field = (ChampChoixImage)this.getField();
        ImageChoiceDialog dialog = new ImageChoiceDialog(field.getNom(), (Collection)field.getValeurs(), field.getHauteurImage());
        dialog.addImageChoiceListener(arg_0 -> this.onImageChoice(arg_0));
        dialog.addClassName("champ-choix-image-dialog");
        dialog.open();
    }

    private void updateUI() {
        boolean otherSelected;
        ChampChoixImage field = (ChampChoixImage)this.getField();
        int otherIndex = field.getIndiceAutreChoix();
        boolean bl = otherSelected = otherIndex != -1 && field.getIndexSelectionnee() == otherIndex;
        if (otherSelected) {
            this.textField.setVisible(true);
            this.textField.setValue(field.getValeurSelectionnee());
            this.image.setSrc(ComboItemIconController.Helper.createComboItemIconURL((String)field.getNom(), (String)((String)field.getValeurs().get(otherIndex))));
        } else {
            this.textField.setVisible(false);
            this.image.setSrc(ComboItemIconController.Helper.createComboItemIconURL((String)field.getNom(), (String)field.getValeurSelectionnee()));
        }
        this.imageTooltip.setText(field.getValeurSelectionnee());
    }

    protected void onSetReadOnly(boolean readOnly) {
        this.bEdit.setVisible(!readOnly);
        this.textField.setReadOnly(readOnly);
    }

    public boolean isEmpty() {
        return false;
    }

    private void onImageChoice(ImageChoiceDialog.ImageChoiceEvent event) {
        ChampChoixImage field = (ChampChoixImage)this.getField();
        int valueIndex = field.getValeurs().indexOf(event.getValue());
        field.setIndexSelectionnee(valueIndex);
        if (valueIndex == -1) {
            field.setValeur("");
        } else if (valueIndex == field.getIndiceAutreChoix()) {
            field.setValeur(this.textField.getValue());
        } else {
            field.setValeur(event.getValue());
        }
        this.fireChangeEvent();
        this.updateUI();
    }
}

