/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field;

import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampTexte;
import com.neogls.prism.central.vaadin.view.mct.common.field.AbstractFieldComponent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.textfield.TextArea;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.textfield.TextFieldBase;
import java.util.Objects;

public class ChampTexteComponent
extends AbstractFieldComponent<ChampTexte> {
    private final TextFieldBase<?, String> textField;

    public ChampTexteComponent(ChampTexte field) {
        super((Champ)field);
        if (field.getHauteur() > 0 && field.getHauteur() < 10) {
            this.textField = new TextArea();
            this.textField.setHeight((float)field.getHauteur() * 25.0f, Unit.PIXELS);
        } else {
            this.textField = new TextField();
        }
        this.textField.addClassName("p-0");
        this.textField.setValue((Object)Objects.requireNonNullElse(field.getValeur(), ""));
        this.textField.addValueChangeListener(arg_0 -> this.onValueChange(arg_0));
        this.addContent(new Component[]{this.textField});
        this.addClassName("champ-texte");
    }

    private void onValueChange(HasValue.ValueChangeEvent<String> event) {
        if (!event.isFromClient()) {
            return;
        }
        ((ChampTexte)this.getField()).setValeur((String)event.getValue());
        this.fireChangeEvent();
    }

    protected void onSetReadOnly(boolean readOnly) {
        this.textField.setReadOnly(readOnly);
    }

    public boolean isEmpty() {
        return this.textField.isEmpty();
    }
}

