/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field;

import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampOneDrive;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampOneDrive;
import com.geolocsystems.prismcentral.Log;
import com.geolocsystems.prismcentral.beans.onedrive.PrismOneDriveFile;
import com.geolocsystems.prismcentral.beans.onedrive.PrismOneDriveFolder;
import com.geolocsystems.prismcentral.onedrive.OneDriveUtils;
import com.neogls.prism.central.vaadin.view.mct.common.field.AbstractFieldComponent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexLayout;

public class ChampOneDriveFolderComponent
extends AbstractFieldComponent<ChampOneDrive> {
    private static final long serialVersionUID = 1653366760359421450L;
    private static final float RATIO_TAILLE_ICONES = 7.0f;
    private static final int LARGEUR_ICONE = 42;
    private static final int HAUTEUR_ICONE = 37;
    private Span label;
    private Div grid;
    PrismOneDriveFolder folder;
    private boolean lecture;

    protected ChampOneDriveFolderComponent(ChampOneDrive field) {
        super((Champ)field);
        try {
            ValeurChampOneDrive vc = (ValeurChampOneDrive)field.getValeurChamp();
            this.folder = OneDriveUtils.getInstance().getRoot(Boolean.valueOf(true));
            this.grid = new Div();
            String[] valeurs = OneDriveUtils.splitValueFrom((String)vc.getValeur());
            this.updateGrid(valeurs[0], valeurs[1]);
            this.addContent(new Component[]{this.grid});
            this.addClassName("champ-texte");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateGrid(String driveId, String folderId) {
        this.label = new Span(((ChampOneDrive)this.getField()).getValeur());
        try {
            this.grid.setWidth("100%");
            this.grid.removeAll();
            if ("".equals(folderId)) {
                Span labelPath = new Span("\\");
                labelPath.setWidth("100%");
                this.grid.add(new Component[]{labelPath});
                this.folder = OneDriveUtils.getInstance().getRoot(Boolean.valueOf(true));
                this.addFolderIcon(this.folder);
            } else {
                Span labelPath = new Span(OneDriveUtils.rechercheFolder((PrismOneDriveFolder)this.folder, (String)folderId).getPath());
                labelPath.setWidth("100%");
                this.grid.add(new Component[]{labelPath});
                this.addFolderIcon(OneDriveUtils.rechercheFolder((PrismOneDriveFolder)this.folder, (String)folderId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addFolderIcon(PrismOneDriveFolder folder) {
        if (folder != null) {
            Span label;
            Image img;
            FlexLayout hl;
            if (!("".equals(folder.getFolderId()) || ((ChampOneDrive)this.getField()).getValeur() != null && ((ChampOneDrive)this.getField()).getValeur().equals(OneDriveUtils.convertValueFrom((String)folder.getDriveId(), (String)folder.getFolderId())))) {
                FlexLayout hl2 = new FlexLayout();
                Image img2 = new Image("images/ico/folder.png", "FOLDER");
                img2.setWidth(42.0f, Unit.PIXELS);
                img2.setHeight(37.0f, Unit.PIXELS);
                hl2.addComponentAsFirst((Component)img2);
                Span label2 = new Span("...");
                img2.addClickListener((ComponentEventListener)new /* Unavailable Anonymous Inner Class!! */);
                hl2.add(new Component[]{label2});
                this.grid.add(new Component[]{hl2});
            }
            for (String folderKey : folder.getFoldersMap().keySet()) {
                hl = new FlexLayout();
                img = new Image("images/ico/folder.png", "FOLDER");
                img.setWidth(42.0f, Unit.PIXELS);
                img.setHeight(37.0f, Unit.PIXELS);
                hl.add(new Component[]{img});
                label = new Span(((PrismOneDriveFolder)folder.getFoldersMap().get(folderKey)).getFolderName());
                img.addClickListener((ComponentEventListener)new /* Unavailable Anonymous Inner Class!! */);
                hl.add(new Component[]{label});
                this.grid.add(new Component[]{hl});
            }
            for (String fileKey : folder.getFilesMap().keySet()) {
                hl = new FlexLayout();
                img = new Image("images/ico/file.png", "FILE");
                img.setWidth(42.0f, Unit.PIXELS);
                img.setHeight(37.0f, Unit.PIXELS);
                hl.add(new Component[]{img});
                label = new Span(((PrismOneDriveFile)folder.getFilesMap().get(fileKey)).getFileName());
                img.addClickListener((ComponentEventListener)new /* Unavailable Anonymous Inner Class!! */);
                hl.add(new Component[]{label});
                this.grid.add(new Component[]{hl});
            }
        } else {
            Log.error((Object)"Erreur addFolderIcon folder is null");
        }
    }

    protected void onSetReadOnly(boolean readOnly) {
    }

    public boolean isEmpty() {
        return false;
    }
}

