/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field;

import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiCheckBox;
import com.google.common.collect.Maps;
import com.neogls.prism.central.vaadin.view.mct.common.VaadinFieldComponentService;
import com.neogls.prism.central.vaadin.view.mct.common.field.AbstractFieldComponent;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.textfield.TextField;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChampMultiCheckBoxComponent
extends AbstractFieldComponent<ChampMultiCheckBox> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ChampMultiCheckBoxComponent.class);
    private final Map<String, Checkbox> checkboxes;
    private final Checkbox cbOther = new Checkbox();
    private final TextField tfOther = new TextField(arg_0 -> this.onTfOtherValueChange(arg_0));

    public ChampMultiCheckBoxComponent(ChampMultiCheckBox field, VaadinFieldComponentService vaadinFieldComponentService) {
        super((Champ)field);
        List values = vaadinFieldComponentService.getChampMultiCheckBoxValues(field);
        if (values.isEmpty()) {
            throw new IllegalStateException("ERREUR CONFIGURATION CHAMP AUCUNE VALEUR - " + field.getNom());
        }
        this.checkboxes = Maps.toMap((Iterable)values, arg_0 -> this.createCheckbox(arg_0));
        this.addContent((Component[])this.checkboxes.values().toArray(Component[]::new));
        if (field.getAutreLabel() != null) {
            this.cbOther.addValueChangeListener(arg_0 -> this.onCbOtherValueChange(arg_0));
            this.cbOther.setLabel(field.getAutreLabel());
            this.tfOther.setVisible(false);
            this.tfOther.addClassName("p-0");
            if (field.getAutreValeur() != null) {
                log.trace("Other value: {}", (Object)field.getAutreValeur());
                this.cbOther.setValue((Object)true);
                this.tfOther.setValue(field.getAutreValeur());
            }
            this.addContent(new Component[]{this.cbOther, this.tfOther});
        }
        this.addClassName("champ-multi-combobox");
    }

    private Checkbox createCheckbox(String value) {
        return new Checkbox(value, ((ChampMultiCheckBox)this.getField()).getValeursSelectionnee().contains(value), arg_0 -> this.onCheckboxValueChange(arg_0));
    }

    private void onCheckboxValueChange(HasValue.ValueChangeEvent<Boolean> event) {
        if (!event.isFromClient()) {
            return;
        }
        ((ChampMultiCheckBox)this.getField()).setValeursSelectionnee(this.checkboxes.entrySet().stream().filter(entry -> (Boolean)((Checkbox)entry.getValue()).getValue()).map(Map.Entry::getKey).toList());
        this.fireChangeEvent();
    }

    private void onCbOtherValueChange(HasValue.ValueChangeEvent<Boolean> event) {
        this.tfOther.setVisible(((Boolean)event.getValue()).booleanValue());
        if (((Boolean)event.getValue()).booleanValue()) {
            this.tfOther.scrollIntoView();
        }
        if (event.isFromClient()) {
            ((ChampMultiCheckBox)this.getField()).setAutreValeur((Boolean)event.getValue() != false && !this.tfOther.isEmpty() ? this.tfOther.getValue() : null);
            this.fireChangeEvent();
        }
    }

    private void onTfOtherValueChange(HasValue.ValueChangeEvent<String> event) {
        if (!event.isFromClient()) {
            return;
        }
        ((ChampMultiCheckBox)this.getField()).setAutreValeur(event.getHasValue().isEmpty() ? null : (String)event.getValue());
        this.fireChangeEvent();
    }

    protected void onSetReadOnly(boolean readOnly) {
        for (Checkbox cb : this.checkboxes.values()) {
            cb.setReadOnly(readOnly);
        }
        this.cbOther.setReadOnly(readOnly);
        this.tfOther.setReadOnly(readOnly);
    }

    public boolean isEmpty() {
        return this.checkboxes.values().stream().allMatch(AbstractField::isEmpty) && this.cbOther.isEmpty();
    }
}

