/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field;

import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampHeure;
import com.neogls.prism.central.vaadin.view.mct.common.field.AbstractFieldComponent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.timepicker.TimePicker;
import java.time.Duration;
import java.time.LocalTime;

public class ChampHeureComponent
extends AbstractFieldComponent<ChampHeure> {
    private final TimePicker timePicker = new TimePicker(arg_0 -> this.onTimePickerValueChange(arg_0));

    public ChampHeureComponent(ChampHeure field) {
        super((Champ)field);
        this.timePicker.setStep(Duration.ofMinutes(1L));
        this.timePicker.setClearButtonVisible(true);
        this.addContent(new Component[]{this.timePicker});
        if (field.isChecked()) {
            this.timePicker.setValue(LocalTime.of(field.getHeure(), field.getMinute()));
        }
    }

    private void onTimePickerValueChange(HasValue.ValueChangeEvent<LocalTime> event) {
        if (!event.isFromClient()) {
            return;
        }
        ChampHeure field = (ChampHeure)this.getField();
        if (event.getHasValue().isEmpty()) {
            field.setChecked(false);
        } else {
            field.setChecked(true);
            field.setHeure(((LocalTime)event.getValue()).getHour());
            field.setMinute(((LocalTime)event.getValue()).getMinute());
        }
        this.fireChangeEvent();
    }

    protected void onSetReadOnly(boolean readOnly) {
        this.timePicker.setReadOnly(readOnly);
    }

    public boolean isEmpty() {
        return this.timePicker.isEmpty();
    }
}

