/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDropListe;
import com.neogls.prism.central.vaadin.view.mct.common.VaadinFieldComponentService;
import com.neogls.prism.central.vaadin.view.mct.common.field.AbstractFieldComponent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.textfield.TextField;
import gls.outils.ConstantesGLS;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ChampDropListeComponent
extends AbstractFieldComponent<ChampDropListe> {
    private final ComboBox<String> comboBox = new ComboBox();
    private final TextField tfOther = new TextField();
    private final List<String> values;
    private final int otherValueIndex;
    private final boolean hasOtherValue;

    public ChampDropListeComponent(ChampDropListe field, VaadinFieldComponentService vaadinFieldComponentService) {
        super((Champ)field);
        this.values = vaadinFieldComponentService.getChampDropListValues(field);
        this.otherValueIndex = field.getIndiceAutreChoix();
        this.hasOtherValue = this.otherValueIndex != -1;
        this.comboBox.setItems((Collection)this.values);
        this.comboBox.setClearButtonVisible(true);
        this.comboBox.addValueChangeListener(arg_0 -> this.onComboBoxValueChange(arg_0));
        this.tfOther.setVisible(false);
        this.tfOther.addValueChangeListener(arg_0 -> this.onTfOtherValueChange(arg_0));
        this.addContent(new Component[]{this.comboBox, this.tfOther});
        if (MetierCommun.estValeurSysteme((String)field.getValeur())) {
            field.setValeur(null);
        } else if (field.getValeur() != null) {
            this.comboBox.setValue((Object)field.getValeur());
            if (this.hasOtherValue && field.getIndexSelectionnee() == this.otherValueIndex) {
                this.tfOther.setValue(Objects.requireNonNullElse(field.getValeur(), ""));
            }
        }
        this.addClassName("champ-drop-liste");
    }

    private void onComboBoxValueChange(HasValue.ValueChangeEvent<String> event) {
        ChampDropListe field = (ChampDropListe)this.getField();
        int selectedIndex = event.getHasValue().isEmpty() ? -1 : this.values.indexOf(event.getValue());
        boolean otherValueSelected = this.hasOtherValue && selectedIndex == this.otherValueIndex;
        this.tfOther.setVisible(otherValueSelected);
        if (!event.isFromClient()) {
            return;
        }
        field.setIndexSelectionnee(selectedIndex);
        if (otherValueSelected) {
            field.setValeur(this.tfOther.getValue());
        } else {
            field.setValeur(selectedIndex != -1 ? (String)this.values.get(selectedIndex) : null);
        }
        this.fireChangeEvent();
    }

    private void onTfOtherValueChange(HasValue.ValueChangeEvent<String> event) {
        if (!event.isFromClient()) {
            return;
        }
        ((ChampDropListe)this.getField()).setValeur((String)event.getValue());
        this.fireChangeEvent();
    }

    protected void onSetReadOnly(boolean readOnly) {
        this.comboBox.setReadOnly(readOnly);
        this.comboBox.setClearButtonVisible(!readOnly);
        this.tfOther.setReadOnly(readOnly);
        this.comboBox.setVisible(!readOnly || !this.tfOther.isVisible());
    }

    public boolean isEmpty() {
        return this.comboBox.isEmpty() || ConstantesGLS.estVide((String)((ChampDropListe)this.getField()).getValeur());
    }
}

