/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field;

import com.geolocsystems.prismandroid.model.Document;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDocuments;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampDocuments;
import com.neogls.prism.central.vaadin.view.mct.common.field.AbstractFieldComponent;
import com.neogls.prism.central.vaadin.view.mct.common.field.ChampDocumentsComponent;
import com.neogls.prism.central.vaadin.view.mct.common.field.upload.UploadFrenchI18N;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.component.upload.UploadI18N;
import com.vaadin.flow.component.upload.receivers.MultiFileMemoryBuffer;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ChampDocumentsComponent
extends AbstractFieldComponent<ChampDocuments> {
    private ChampDocuments champ;
    private List<Button> btDocuments;
    private DocumentUploader docUploader;
    private Upload upload;
    private List<HorizontalLayout> hlDocuments;
    private VerticalLayout verticalLayout;
    private boolean readOnly = false;

    public ChampDocumentsComponent(ChampDocuments c) {
        super((Champ)c);
        this.champ = c;
        this.btDocuments = new ArrayList();
        this.hlDocuments = new ArrayList();
        this.verticalLayout = new VerticalLayout();
        this.createLayoutDocument(c);
        this.docUploader = new DocumentUploader(this, this);
        MultiFileMemoryBuffer buffer = new MultiFileMemoryBuffer();
        this.upload = new Upload((Receiver)this.docUploader);
        this.upload.setI18n((UploadI18N)new UploadFrenchI18N());
        this.upload.setMaxFiles(10);
        this.upload.addSucceededListener((ComponentEventListener)this.docUploader);
        this.upload.addFileRemovedListener((ComponentEventListener & Serializable)event -> this.removeDocument(event.getFileName()));
        this.upload.setVisible(!this.readOnly);
        this.add(new Component[]{this.upload});
        this.add(new Component[]{this.verticalLayout});
    }

    private void createLayoutDocument(ChampDocuments c) {
        List documents;
        ValeurChampDocuments valeurDocument = (ValeurChampDocuments)c.getValeurChamp();
        if (valeurDocument != null && (documents = valeurDocument.getValeurs()) != null) {
            for (Document document : documents) {
                this.addDocumentButton(document);
            }
        }
    }

    private void updateLayoutDocument() {
        this.verticalLayout.removeAll();
        this.hlDocuments.clear();
        this.createLayoutDocument(this.champ);
        this.add(new Component[]{this.verticalLayout});
    }

    private void removeDocument(String fileName) {
        List documents;
        ValeurChampDocuments valeurDocument = (ValeurChampDocuments)this.champ.getValeurChamp();
        if (valeurDocument != null && (documents = valeurDocument.getValeurs()) != null) {
            for (Document document : documents) {
                if (!fileName.endsWith(document.getNom())) continue;
                documents.remove(document);
                this.updateLayoutDocument();
                return;
            }
        }
    }

    private void addDocumentButton(Document document) {
        HorizontalLayout layout = new HorizontalLayout();
        Button button = new Button();
        Image theme = new Image("images/menu/report.png", null);
        button.setIcon((Component)theme);
        button.addClassName("link-white");
        StreamResource streamPDF = new StreamResource(document.getNom(), (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(document.getContenu()));
        Anchor a = new Anchor((AbstractStreamResource)streamPDF, document.getNom());
        Image themeSupp = new Image("images/ico/cancel.png", null);
        Button suppr = new Button((Component)themeSupp);
        suppr.setVisible(!this.readOnly);
        suppr.addClickListener((ComponentEventListener & Serializable)event -> {
            ((ValeurChampDocuments)this.champ.getValeurChamp()).removeValeur(document);
            this.hlDocuments.remove(layout);
            this.updateLayoutDocument();
        });
        Image themeSynchroTous = new Image("images/ico/patrouilleur.png", null);
        Image themeSynchroFixe = new Image("images/ico/unpublish.png", null);
        Button btSynchro = new Button();
        btSynchro.setEnabled(!this.readOnly);
        btSynchro.setIcon((Component)(document.getSynchronisation() != Document.SYNCHRONISATION_FIXE ? themeSynchroTous : themeSynchroFixe));
        btSynchro.addClickListener((ComponentEventListener & Serializable)event -> {
            boolean state = btSynchro.getIcon() != themeSynchroTous;
            btSynchro.setIcon((Component)(state ? themeSynchroTous : themeSynchroFixe));
            document.setSynchronisation(state ? Document.SYNCHRONISATION_TOUS : Document.SYNCHRONISATION_FIXE);
        });
        this.btDocuments.add(button);
        layout.add(new Component[]{button});
        layout.add(new Component[]{a});
        layout.add(new Component[]{btSynchro});
        layout.add(new Component[]{suppr});
        this.hlDocuments.add(layout);
        this.verticalLayout.add(new Component[]{layout});
    }

    public void addDocument(Document document) {
        ((ValeurChampDocuments)this.champ.getValeurChamp()).addValeur(document);
        this.addDocumentButton(document);
    }

    protected void onSetReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.updateLayoutDocument();
        if (this.upload != null) {
            this.upload.setVisible(!readOnly);
        }
    }

    public boolean isEmpty() {
        ValeurChampDocuments valeurDocument = (ValeurChampDocuments)this.champ.getValeurChamp();
        return valeurDocument != null || valeurDocument.getValeurs().isEmpty();
    }
}

