/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field;

import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDecimal;
import com.neogls.prism.central.vaadin.view.mct.common.field.AbstractFieldComponent;
import com.neogls.prism.central.vaadin.view.mct.common.field.FieldComponentThemeVariant;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.NumberField;
import com.vaadin.flow.data.value.ValueChangeMode;

public class ChampDecimalComponent
extends AbstractFieldComponent<ChampDecimal> {
    private final Checkbox cbEnabled = new Checkbox(true, arg_0 -> this.onCbEnableValueChange(arg_0));
    private final NumberField valueField = new NumberField(arg_0 -> this.onValueFieldValueChange(arg_0));

    public ChampDecimalComponent(ChampDecimal field) {
        super((Champ)field);
        this.valueField.setStepButtonsVisible(true);
        this.valueField.setValueChangeMode(ValueChangeMode.LAZY);
        this.addContent(new Component[]{this.cbEnabled, this.valueField});
        this.addThemeVariants((ThemeVariant[])new FieldComponentThemeVariant[]{FieldComponentThemeVariant.CONTENT_HORIZONTAL});
        if (!field.isCheckbox()) {
            field.setChecked(true);
            this.cbEnabled.setVisible(false);
            this.cbEnabled.setEnabled(false);
        }
        this.cbEnabled.setValue((Object)field.isChecked());
        this.valueField.setMin(field.getValeurMin());
        this.valueField.setMax(field.getValeurMax());
        this.valueField.setStep(field.getPas());
        this.valueField.setValue((Number)field.getValeur());
        this.addClassName("champ-decimal");
    }

    private void writeValueToField() {
        double newValue;
        if (((Boolean)this.cbEnabled.getValue()).booleanValue()) {
            newValue = this.valueField.isEmpty() ? 0.0 : Math.min(Math.max((Double)this.valueField.getValue(), this.valueField.getMin()), this.valueField.getMax());
            this.valueField.setValue((Number)newValue);
        } else {
            newValue = 0.0;
        }
        ((ChampDecimal)this.getField()).setValeur(newValue);
    }

    private void onCbEnableValueChange(HasValue.ValueChangeEvent<Boolean> event) {
        this.valueField.setEnabled(((Boolean)event.getValue()).booleanValue());
        if (!event.isFromClient()) {
            return;
        }
        ((ChampDecimal)this.getField()).setChecked(((Boolean)event.getValue()).booleanValue());
        this.writeValueToField();
        this.fireChangeEvent();
    }

    private void onValueFieldValueChange(HasValue.ValueChangeEvent<Double> event) {
        if (!event.isFromClient()) {
            return;
        }
        this.writeValueToField();
        this.fireChangeEvent();
    }

    protected void onSetReadOnly(boolean readOnly) {
        this.cbEnabled.setReadOnly(readOnly);
        this.valueField.setReadOnly(readOnly);
        this.valueField.setStepButtonsVisible(!readOnly);
    }

    public boolean isEmpty() {
        return this.valueField.isEmpty();
    }
}

