/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field;

import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDateHeure;
import com.neogls.prism.central.vaadin.util.vaadin.DatePickerI18nUtils;
import com.neogls.prism.central.vaadin.view.mct.common.field.AbstractFieldComponent;
import com.neogls.prism.central.vaadin.view.mct.common.field.FieldComponentThemeVariant;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.datetimepicker.DateTimePicker;
import com.vaadin.flow.component.shared.ThemeVariant;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.GregorianCalendar;

public class ChampDateHeureComponent
extends AbstractFieldComponent<ChampDateHeure> {
    private final Checkbox cbEnable = new Checkbox(true, arg_0 -> this.onCbEnableValueChange(arg_0));
    private final DateTimePicker dateTimePicker = new DateTimePicker(arg_0 -> this.onDateTimePickerValueChange(arg_0));
    @Nullable
    private LocalDateTime lastValue = LocalDateTime.now();

    public ChampDateHeureComponent(ChampDateHeure field) {
        super((Champ)field);
        field.setChecked(field.isChecked() || !field.isAfficheCheckBox());
        this.cbEnable.setVisible(field.isAfficheCheckBox());
        this.cbEnable.addClassName("pr-xs");
        this.dateTimePicker.setRequiredIndicatorVisible(true);
        this.dateTimePicker.setStep(Duration.ofMinutes(1L));
        this.dateTimePicker.setDatePickerI18n(DatePickerI18nUtils.getDatePickerI18n());
        this.dateTimePicker.setValue(this.readFieldValue());
        this.cbEnable.setValue((Object)field.isChecked());
        this.addContent(new Component[]{this.cbEnable, this.dateTimePicker});
        this.addThemeVariants((ThemeVariant[])new FieldComponentThemeVariant[]{FieldComponentThemeVariant.CONTENT_HORIZONTAL});
        this.addClassName("champ-date-heure");
    }

    private LocalDateTime readFieldValue() {
        ChampDateHeure field = (ChampDateHeure)this.getField();
        if (field.getAnnee() == -1 || field.getMois() == -1 || field.getJour() == -1 || field.getHeure() == -1 || field.getMinute() == -1) {
            return null;
        }
        return new GregorianCalendar(field.getAnnee(), field.getMois(), field.getJour(), field.getHeure(), field.getMinute()).toZonedDateTime().toLocalDateTime();
    }

    private void onCbEnableValueChange(HasValue.ValueChangeEvent<Boolean> event) {
        this.dateTimePicker.setEnabled(((Boolean)event.getValue()).booleanValue());
        this.dateTimePicker.setRequiredIndicatorVisible(((Boolean)event.getValue()).booleanValue());
        if (((Boolean)event.getValue()).booleanValue()) {
            this.dateTimePicker.setValue(this.lastValue);
        } else {
            this.dateTimePicker.clear();
        }
        if (event.isFromClient()) {
            ((ChampDateHeure)this.getField()).setChecked(((Boolean)event.getValue()).booleanValue());
            if (((Boolean)event.getValue()).booleanValue() && !this.dateTimePicker.isEmpty()) {
                this.writeValueToField(this.convertToGregorianCalendar((LocalDateTime)this.dateTimePicker.getValue()));
            } else {
                this.clearField();
            }
            this.fireChangeEvent();
        }
    }

    private void onDateTimePickerValueChange(HasValue.ValueChangeEvent<LocalDateTime> event) {
        if (event.getValue() != null) {
            this.lastValue = (LocalDateTime)event.getValue();
        }
        if (!event.isFromClient() || event.getValue() == null) {
            return;
        }
        this.writeValueToField(this.convertToGregorianCalendar((LocalDateTime)event.getValue()));
        this.fireChangeEvent();
    }

    private GregorianCalendar convertToGregorianCalendar(LocalDateTime value) {
        return GregorianCalendar.from(value.atZone(ZoneId.systemDefault()));
    }

    private void writeValueToField(GregorianCalendar fieldValue) {
        ChampDateHeure field = (ChampDateHeure)this.getField();
        field.setAnnee(fieldValue.get(1));
        field.setMois(fieldValue.get(2));
        field.setJour(fieldValue.get(5));
        field.setHeure(fieldValue.get(11));
        field.setMinute(fieldValue.get(12));
    }

    private void clearField() {
        ChampDateHeure field = (ChampDateHeure)this.getField();
        field.setAnnee(-1);
        field.setMois(-1);
        field.setJour(-1);
        field.setHeure(-1);
        field.setMinute(-1);
    }

    protected void onSetReadOnly(boolean readOnly) {
        this.cbEnable.setVisible(!readOnly);
        this.dateTimePicker.setReadOnly(readOnly);
        this.dateTimePicker.setVisible(!readOnly || !this.dateTimePicker.isEmpty());
    }

    public boolean isEmpty() {
        return this.dateTimePicker.isEmpty();
    }
}

