/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field;

import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDate;
import com.neogls.prism.central.vaadin.util.vaadin.DatePickerI18nUtils;
import com.neogls.prism.central.vaadin.view.mct.common.field.AbstractFieldComponent;
import com.neogls.prism.central.vaadin.view.mct.common.field.FieldComponentThemeVariant;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.shared.ThemeVariant;
import jakarta.annotation.Nullable;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.GregorianCalendar;

public class ChampDateComponent
extends AbstractFieldComponent<ChampDate> {
    private final Checkbox cbEnable = new Checkbox(true, arg_0 -> this.onCbEnableValue(arg_0));
    private final DatePicker datePicker = new DatePicker(arg_0 -> this.onDatePickerValueChange(arg_0));
    @Nullable
    private LocalDate lastValue = LocalDate.now();

    public ChampDateComponent(ChampDate field) {
        super((Champ)field);
        this.cbEnable.addClassName("pr-xs");
        this.datePicker.setRequiredIndicatorVisible(true);
        this.datePicker.setI18n(DatePickerI18nUtils.getDatePickerI18n());
        this.datePicker.setValue(this.readFieldValue());
        this.cbEnable.setValue((Object)field.isChecked());
        this.addContent(new Component[]{this.cbEnable, this.datePicker});
        this.addThemeVariants((ThemeVariant[])new FieldComponentThemeVariant[]{FieldComponentThemeVariant.CONTENT_HORIZONTAL});
        this.addClassName("champ-date");
    }

    private LocalDate readFieldValue() {
        ChampDate field = (ChampDate)this.getField();
        if (field.getAnnee() == -1 || field.getMois() == -1 || field.getJour() == -1) {
            return null;
        }
        return new GregorianCalendar(field.getAnnee(), field.getMois(), field.getJour()).toZonedDateTime().toLocalDate();
    }

    private void onCbEnableValue(HasValue.ValueChangeEvent<Boolean> event) {
        this.datePicker.setEnabled(((Boolean)event.getValue()).booleanValue());
        this.datePicker.setRequiredIndicatorVisible(((Boolean)event.getValue()).booleanValue());
        if (((Boolean)event.getValue()).booleanValue()) {
            this.datePicker.setValue(this.lastValue);
        } else {
            this.datePicker.clear();
        }
        if (event.isFromClient()) {
            ((ChampDate)this.getField()).setChecked(((Boolean)event.getValue()).booleanValue());
            if (((Boolean)event.getValue()).booleanValue() && !this.datePicker.isEmpty()) {
                this.writeValueToField(this.convertToGregorianCalendar((LocalDate)this.datePicker.getValue()));
            } else {
                this.clearField();
            }
            this.fireChangeEvent();
        }
    }

    private void onDatePickerValueChange(HasValue.ValueChangeEvent<LocalDate> event) {
        if (event.getValue() != null) {
            this.lastValue = (LocalDate)event.getValue();
        }
        if (!event.isFromClient() || event.getValue() == null) {
            return;
        }
        this.writeValueToField(this.convertToGregorianCalendar((LocalDate)event.getValue()));
        this.fireChangeEvent();
    }

    private GregorianCalendar convertToGregorianCalendar(LocalDate value) {
        return GregorianCalendar.from(value.atStartOfDay(ZoneId.systemDefault()));
    }

    private void writeValueToField(GregorianCalendar fieldValue) {
        ChampDate field = (ChampDate)this.getField();
        field.setAnnee(fieldValue.get(1));
        field.setMois(fieldValue.get(2));
        field.setJour(fieldValue.get(5));
    }

    private void clearField() {
        ChampDate field = (ChampDate)this.getField();
        field.setAnnee(-1);
        field.setMois(-1);
        field.setJour(-1);
    }

    protected void onSetReadOnly(boolean readOnly) {
        this.cbEnable.setVisible(!readOnly);
        this.datePicker.setReadOnly(readOnly);
        this.datePicker.setVisible(!readOnly || !this.datePicker.isEmpty());
    }

    public boolean isEmpty() {
        return this.datePicker.isEmpty();
    }
}

