/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field;

import cartoj.Enregistrement;
import cartoj.ICouche;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampCoucheBox;
import com.neogls.prism.central.vaadin.service.bean.Point;
import com.neogls.prism.central.vaadin.util.LeafletUtils;
import com.neogls.prism.central.vaadin.view.mct.common.VaadinFieldComponentService;
import com.neogls.prism.central.vaadin.view.mct.common.field.AbstractFieldComponent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.textfield.TextFieldBase;
import gls.geometry.GeoPoint;
import gls.localisation.recherche.Recherche;
import java.util.Objects;
import org.vaadin.addons.componentfactory.leaflet.LeafletMap;
import org.vaadin.addons.componentfactory.leaflet.layer.events.MouseEvent;
import org.vaadin.addons.componentfactory.leaflet.types.LatLng;

public class ChampCoucheBoxComponent
extends AbstractFieldComponent<ChampCoucheBox> {
    private final TextFieldBase<?, String> textField;
    private final LeafletMap map;
    private boolean readOnly = false;
    private VaadinFieldComponentService vaadinFieldComponentService;

    public ChampCoucheBoxComponent(ChampCoucheBox field, LeafletMap map, VaadinFieldComponentService vaadinFieldComponentService) {
        super((Champ)field);
        this.map = Objects.requireNonNull(map);
        map.onClick(arg_0 -> this.onMapClick(arg_0));
        this.vaadinFieldComponentService = vaadinFieldComponentService;
        this.textField = new TextField();
        this.textField.addClassName("p-0");
        this.textField.setValue((Object)Objects.requireNonNullElse(field.getValeur(), ""));
        this.textField.addValueChangeListener(arg_0 -> this.onValueChange(arg_0));
        this.textField.setEnabled(false);
        this.addContent(new Component[]{this.textField});
        this.addClassName("champ-texte");
    }

    private void onValueChange(HasValue.ValueChangeEvent<String> event) {
        if (!event.isFromClient()) {
            return;
        }
        ((ChampCoucheBox)this.getField()).setValeur((String)event.getValue());
        this.fireChangeEvent();
    }

    private void onMapClick(MouseEvent event) {
        String resultat;
        ICouche couche;
        Point point = LeafletUtils.latLngToPoint((LatLng)event.getLatLng());
        if (((ChampCoucheBox)this.getField()).getNomCouche() != null && (couche = this.vaadinFieldComponentService.getCouche(((ChampCoucheBox)this.getField()).getNomCouche())) != null && (resultat = Recherche.getChampEnregistrement((int)((ChampCoucheBox)this.getField()).getChampCouche(), (Enregistrement)Recherche.rechercherPremierEnregistrementDistance((ICouche)couche, (GeoPoint)new GeoPoint(point.getX(), point.getY()).toUTM(), (int)((int)((ChampCoucheBox)this.getField()).getDistanceRecherche())))) != null) {
            ((ChampCoucheBox)this.getField()).setValeur(resultat);
            this.textField.setValue((Object)resultat);
        }
    }

    protected void onSetReadOnly(boolean readOnly) {
        this.textField.setReadOnly(readOnly);
    }

    public boolean isEmpty() {
        return this.textField.isEmpty();
    }
}

