/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field;

import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampChoixImageMultiple;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiCheckBox;
import com.neogls.prism.central.vaadin.rest.comboitemicon.ComboItemIconController;
import com.neogls.prism.central.vaadin.view.mct.common.VaadinFieldComponentService;
import com.neogls.prism.central.vaadin.view.mct.common.field.AbstractFieldComponent;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChampChoixImageMultipleComponent
extends AbstractFieldComponent<ChampChoixImageMultiple> {
    private final Map<String, Checkbox> checkboxes = new HashMap();

    public ChampChoixImageMultipleComponent(ChampChoixImageMultiple field, VaadinFieldComponentService vaadinFieldComponentService) {
        super((Champ)field);
        List values = vaadinFieldComponentService.getChampMultiCheckBoxValues((ChampMultiCheckBox)field);
        if (values.isEmpty()) {
            throw new IllegalStateException("ERREUR CONFIGURATION CHAMP AUCUNE VALEUR - " + field.getNom());
        }
        this.addContent((Component[])values.stream().map(arg_0 -> this.createCheckbox(arg_0)).toArray(Component[]::new));
        this.addClassName("champ-choix-image-multiple");
    }

    private Component createCheckbox(String value) {
        Checkbox cb = new Checkbox(value, ((ChampChoixImageMultiple)this.getField()).getValeursSelectionnee().contains(value), arg_0 -> this.onCheckboxValueChange(arg_0));
        this.checkboxes.put(value, cb);
        Image image = this.getImage(value);
        image.addClickListener((ComponentEventListener & Serializable)event -> {
            cb.setValue((Object)((Boolean)cb.getValue() == false ? 1 : 0));
            this.updateValue();
        });
        return new Div(new Component[]{image, cb});
    }

    private Image getImage(String value) {
        Image image = new Image();
        image.setSrc(ComboItemIconController.Helper.createComboItemIconURL((String)((ChampChoixImageMultiple)this.getField()).getNom(), (String)value));
        image.setWidth((float)((ChampChoixImageMultiple)this.getField()).getLargeurImage(), Unit.PIXELS);
        image.setWidth((float)((ChampChoixImageMultiple)this.getField()).getHauteurImage(), Unit.PIXELS);
        return image;
    }

    private void onCheckboxValueChange(HasValue.ValueChangeEvent<Boolean> event) {
        if (event.isFromClient()) {
            this.updateValue();
        }
    }

    private void updateValue() {
        ((ChampChoixImageMultiple)this.getField()).setValeursSelectionnee(this.checkboxes.entrySet().stream().filter(entry -> (Boolean)((Checkbox)entry.getValue()).getValue()).map(Map.Entry::getKey).toList());
        this.fireChangeEvent();
    }

    protected void onSetReadOnly(boolean readOnly) {
        for (Checkbox cb : this.checkboxes.values()) {
            cb.setEnabled(!readOnly);
        }
    }

    public boolean isEmpty() {
        return this.checkboxes.values().stream().allMatch(AbstractField::isEmpty);
    }
}

