/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.field;

import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.neogls.prism.central.vaadin.view.mct.common.field.AbstractFieldComponent;
import com.neogls.prism.central.vaadin.view.mct.common.field.FieldComponentThemeVariant;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.HasThemeVariant;
import com.vaadin.flow.data.binder.ValidationResult;
import java.io.Serializable;
import java.util.List;
import lombok.Generated;

public abstract class AbstractFieldComponent<T extends Champ>
extends VerticalLayout
implements HasThemeVariant<FieldComponentThemeVariant> {
    private final Div content = new Div();
    private final Span errorLabel = new Span();
    private final T field;

    protected AbstractFieldComponent(T field) {
        this.field = field;
        Span label = new Span(field.getLibelle());
        label.addClassName("field-label");
        this.content.addClassName("field-container");
        this.errorLabel.addClassName("error-label");
        this.add(new Component[]{label, this.content, this.errorLabel});
        this.setPadding(false);
        this.setSpacing(false);
        this.addClassName("field-component");
        this.getElement().setAttribute("required", field.estObligatoire());
        this.addComponentValueChangeListener((ComponentEventListener & Serializable)event -> this.isValid());
    }

    protected void addContent(Component ... components) {
        this.content.add(components);
    }

    public final void setReadOnly(boolean readOnly) {
        this.getElement().setAttribute("readonly", readOnly);
        this.onSetReadOnly(readOnly);
    }

    public final boolean isReadOnly() {
        return this.getElement().getAttribute("readonly") != null;
    }

    protected abstract void onSetReadOnly(boolean var1);

    public abstract boolean isEmpty();

    public final boolean isValid() {
        boolean isError;
        if (this.field.estObligatoire() && this.isEmpty()) {
            isError = true;
            this.setErrorMessage("Ce champ est obligatoire");
        } else {
            ValidationResult validationResult = this.validate();
            isError = validationResult.isError();
            if (isError) {
                this.setErrorMessage(validationResult.getErrorMessage());
            }
        }
        this.getElement().setAttribute("invalid", isError);
        return !isError;
    }

    protected ValidationResult validate() {
        return ValidationResult.ok();
    }

    public void setErrorMessage(String errorMessage) {
        this.errorLabel.setText(errorMessage);
    }

    protected final void fireChangeEvent() {
        this.fireEvent((ComponentEvent)new ComponentValueChangeEvent(this, true));
    }

    public final void addComponentValueChangeListener(ComponentEventListener<ComponentValueChangeEvent> listener) {
        this.addListener(ComponentValueChangeEvent.class, listener);
    }

    public List<AbstractFieldComponent<Champ>> getSubComponents() {
        return List.of();
    }

    @Generated
    public T getField() {
        return (T)this.field;
    }
}

