/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.sort;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.neogls.prism.central.vaadin.util.SerializableComparatorUtils;
import com.neogls.prism.central.vaadin.view.mct.common.event.sort.BasicSortCriteria;
import com.neogls.prism.central.vaadin.view.mct.common.event.sort.ISortCriteria;
import com.vaadin.flow.function.SerializableComparator;
import gls.outils.ConstantesGLS;
import java.util.List;
import java.util.function.Predicate;

public final class SortCriteria {
    public static final ISortCriteria DATE_ASC = new BasicSortCriteria(SerializableComparatorUtils.comparingLong(SortCriteria::getDateCreation), "mct.sort.dateasc");
    public static final ISortCriteria DATE_DESC = new BasicSortCriteria(SerializableComparatorUtils.reverse((SerializableComparator)DATE_ASC), "mct.sort.datedesc");
    public static final ISortCriteria USER = new BasicSortCriteria(SerializableComparatorUtils.comparing(SortCriteria::getCodeUtilisateur), "mct.sort.user");
    public static final ISortCriteria NATURE = new BasicSortCriteria(SerializableComparatorUtils.comparing(SortCriteria::getCodeNature), "mct.sort.nature");
    public static final ISortCriteria NON_LU = new BasicSortCriteria(SerializableComparatorUtils.reverse((SerializableComparator)SerializableComparatorUtils.comparing(SortCriteria::isNonLu)), "mct.sort.lu");
    public static final ISortCriteria RDPR = new BasicSortCriteria(SerializableComparatorUtils.comparing(SortCriteria::getCodeRDPR), "mct.sort.rdpr");
    public static final List<ISortCriteria> ALL_SORT_CRITERIA = List.of(DATE_ASC, DATE_DESC, USER, NATURE, NON_LU, RDPR);

    private static long getDateCreation(Situation situation) {
        return situation.getEvenementPrincipal().getDateCreation();
    }

    private static String getCodeUtilisateur(Situation situation) {
        return ((Evenement)situation.getEvenements().get(0)).getCodeUtilisateur();
    }

    private static String getCodeNature(Situation situation) {
        return ((Evenement)situation.getEvenements().get(0)).getValeurNature().getCode();
    }

    private static boolean isNonLu(Situation situation) {
        return situation.getEvenements().stream().anyMatch(Predicate.not(Evenement::isLu));
    }

    private static String getCodeRDPR(Situation situation) {
        if (situation.getEvenementPrincipal().getLocalisation() == null || ConstantesGLS.estVide((String)situation.getEvenementPrincipal().getLocalisation().getAxe())) {
            return "AUCUN";
        }
        String codeRdPr = ConstantesGLS.getNumRD((String)situation.getEvenementPrincipal().getLocalisation().getAxe());
        if (situation.getEvenementPrincipal().getLocalisation().getPrDebut() != -1 && situation.getEvenementPrincipal().getLocalisation().getAbsPrDebut() != -1) {
            return codeRdPr + ConstantesGLS.formatPrAbs((int)situation.getEvenementPrincipal().getLocalisation().getPrDebut(), (int)situation.getEvenementPrincipal().getLocalisation().getAbsPrDebut());
        }
        return codeRdPr + "AUCUN";
    }

    private SortCriteria() {
    }
}

