/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.list.impl;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.neogls.prism.central.vaadin.common.component.AbstractExportButton;
import com.neogls.prism.central.vaadin.rest.export.situation.ExportFormat;
import com.neogls.prism.central.vaadin.rest.export.situation.SituationExportController;
import com.vaadin.flow.component.HasValue;
import java.util.Collection;
import java.util.List;

public class SituationSelectionExportButton
extends AbstractExportButton<ExportFormat> {
    private final int maxNbSituationExport;
    private Collection<Evenement> eventSelection = List.of();
    private ExportFormat format;

    public SituationSelectionExportButton(int maxNbSituationExport) {
        super(List.of());
        this.maxNbSituationExport = maxNbSituationExport;
        this.addFormatValueChangeListener(arg_0 -> this.onFormatValueChange(arg_0));
        this.addClassName("situation-export-button");
    }

    protected String exportFormatToString(ExportFormat item) {
        if (item.getLabel() == null) {
            return item.getFormat();
        }
        return item.getLabel() + " - " + item.getFormat();
    }

    private void updateURL() {
        this.setHref(SituationExportController.Helper.createEventSelectionExportURL((Collection)this.eventSelection, (ExportFormat)this.format));
    }

    private void onFormatValueChange(HasValue.ValueChangeEvent<ExportFormat> event) {
        if (event.getHasValue().isEmpty()) {
            return;
        }
        this.format = (ExportFormat)event.getValue();
        this.updateButtonEnableState();
        this.updateURL();
    }

    public void setFormats(List<ExportFormat> formats) {
        this.setFormatsInternal(formats);
    }

    public void setEventSelection(Collection<Evenement> eventSelection) {
        if (eventSelection.equals(this.eventSelection)) {
            return;
        }
        this.eventSelection = eventSelection;
        this.updateButtonEnableState();
        this.updateURL();
    }

    private void updateButtonEnableState() {
        if (this.eventSelection.size() <= this.maxNbSituationExport || "CSV".equalsIgnoreCase(this.format.getFormat()) || "Tableau".equalsIgnoreCase(this.format.getLabel())) {
            this.setAnchorEnabled(true);
            this.setAnchorTooltip(null);
        } else {
            this.setAnchorEnabled(false);
            this.setAnchorTooltip(this.getTranslation("export.nb.evenement.max.titre", new Object[0]) + " (max: %s)".formatted(this.maxNbSituationExport));
        }
    }
}

