/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.list.impl;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.ValeurNature;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.rest.export.situation.SituationExportService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventMctListService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventSelectionActionGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.impl.SituationSelectionExportButton;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctList;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.shared.ThemeVariant;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.IntStream;
import lombok.Generated;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Primary
public class CommonEventSelectionActionGeneratorService
implements EventSelectionActionGeneratorService<EventActionListener> {
    private final UserPermissionService userPermissionService;
    private final SituationExportService situationExportService;
    private final IBusinessService businessService;
    private final ConfigurationService configurationService;
    private static final String ICON_CLOSE = "images/ico/cancel.png";
    private static final String ICON_CANCEL = "images/ico/annule.png";
    private static final String ICON_DELETE = "images/ico/dustbin.png";
    private static final String ICON_READ = "images/ico/readall.png";
    private static final String ICON_PROGRAM = "images/ico/program.png";
    private static final String ICON_DEPROGRAM = "images/ico/deprogram.png";
    private static final String FORM_LAYOUT_COLUMN_SPACING = "var(--lumo-space-s)";
    private static final int COLUMN_MIN_WIDTH = 16;
    private static final Unit COLUMN_WIDTH_UNIT = Unit.EM;
    private static final int MAX_COLUMNS = 5;
    private static final List<FormLayout.ResponsiveStep> RESPONSIVE_STEPS = IntStream.range(0, 5).mapToObj(i -> new FormLayout.ResponsiveStep(i * 16 + COLUMN_WIDTH_UNIT.getSymbol(), i + 1)).toList();

    public HasEnabled createSelectionActionComponent(EventMctListService<EventActionListener> eventMctListService, EventActionListener actionListener, MctList<?, Situation, ?, ?> eventMctList) {
        FormLayout actions = new FormLayout();
        actions.getStyle().set("--vaadin-form-layout-column-spacing", "var(--lumo-space-s)");
        actions.setResponsiveSteps(RESPONSIVE_STEPS);
        if (this.userPermissionService.canDo(3) && this.configurationService.isFastCloseModeEnabled()) {
            actions.add(new Component[]{CommonEventSelectionActionGeneratorService.createButton((String)CommonEventSelectionActionGeneratorService.getTranslation((Object)"mct.action.close", (Object[])new Object[0]), (String)"images/ico/cancel.png", (ComponentEventListener & Serializable)event -> actionListener.onClose((Collection)eventMctList.getSelectedItems()))});
        }
        if (this.userPermissionService.canDo(8)) {
            actions.add(new Component[]{CommonEventSelectionActionGeneratorService.createButton((String)CommonEventSelectionActionGeneratorService.getTranslation((Object)"mct.action.cancel", (Object[])new Object[0]), (String)"images/ico/annule.png", (ComponentEventListener & Serializable)event -> actionListener.onCancel((Collection)eventMctList.getSelectedItems()))});
        }
        if (this.userPermissionService.canDo(202)) {
            actions.add(new Component[]{CommonEventSelectionActionGeneratorService.createButton((String)CommonEventSelectionActionGeneratorService.getTranslation((Object)"mct.action.suppr", (Object[])new Object[0]), (String)"images/ico/dustbin.png", (ComponentEventListener & Serializable)event -> actionListener.onDelete((Collection)eventMctList.getSelectedItems()))});
        }
        if (this.userPermissionService.canDo(201)) {
            actions.add(new Component[]{CommonEventSelectionActionGeneratorService.createButton((String)CommonEventSelectionActionGeneratorService.getTranslation((Object)"mct.action.readall", (Object[])new Object[0]), (String)"images/ico/readall.png", (ComponentEventListener & Serializable)event -> actionListener.onReadAll((Collection)eventMctList.getSelectedItems()))});
        }
        if (this.userPermissionService.canDo(22)) {
            SituationSelectionExportButton situationSelectionExportButton = new SituationSelectionExportButton(this.configurationService.getMaxNbSituationExport());
            eventMctList.addItemsLoadListener((ComponentEventListener & Serializable)event -> {
                List<Nature> natureList = event.getItems().stream().map(Situation::getEvenements).flatMap(Collection::stream).map(Evenement::getValeurNature).map(ValeurNature::getCode).distinct().map(this.businessService.getNatures()::get).toList();
                List exportFormats = this.situationExportService.getNatureExport(natureList);
                event.registerUiAccess(ui -> situationSelectionExportButton.setFormats(exportFormats));
            });
            eventMctList.addItemsSelectionChangeListener((ComponentEventListener & Serializable)event -> {
                List<Evenement> eventSelection = event.getSelectedItems().stream().map(Situation::getEvenementPrincipal).toList();
                event.registerUiAccess(ui -> situationSelectionExportButton.setEventSelection((Collection)eventSelection));
            });
            actions.add(new Component[]{situationSelectionExportButton});
        }
        if (this.userPermissionService.canDo(200) && this.configurationService.isFastProgramModeEnabled() && eventMctListService.getPrimaryBusinessModuleCode() == 0) {
            actions.add(new Component[]{CommonEventSelectionActionGeneratorService.createButton((String)CommonEventSelectionActionGeneratorService.getTranslation((Object)"mct.action.programme", (Object[])new Object[0]), (String)"images/ico/program.png", (ComponentEventListener & Serializable)event -> actionListener.onProgram((Collection)eventMctList.getSelectedItems()))});
            actions.add(new Component[]{CommonEventSelectionActionGeneratorService.createButton((String)CommonEventSelectionActionGeneratorService.getTranslation((Object)"mct.action.deprogramme", (Object[])new Object[0]), (String)"images/ico/deprogram.png", (ComponentEventListener & Serializable)event -> actionListener.onDeprogram((Collection)eventMctList.getSelectedItems()))});
        }
        return actions;
    }

    private static Button createButton(String text, String iconName, ComponentEventListener<ClickEvent<Button>> clickListener) {
        Button button = new Button(text);
        if (iconName != null) {
            Image icon = new Image(iconName, null);
            icon.addClassName("mr-xs");
            button.setIcon((Component)icon);
        }
        if (clickListener != null) {
            button.addClickListener(clickListener);
        }
        button.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        button.addClassName("text-2xs");
        return button;
    }

    private static String getTranslation(Object key, Object ... params) {
        return UI.getCurrent().getTranslation(key, params);
    }

    @Generated
    public CommonEventSelectionActionGeneratorService(UserPermissionService userPermissionService, SituationExportService situationExportService, IBusinessService businessService, ConfigurationService configurationService) {
        this.userPermissionService = userPermissionService;
        this.situationExportService = situationExportService;
        this.businessService = businessService;
        this.configurationService = configurationService;
    }
}

