/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.list.impl;

import com.geolocsystems.prismandroid.MapDescription;
import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.service.security.SecurityService;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilter;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventRetrieverService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Primary
public class CommonEventRetrieverService
implements EventRetrieverService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonEventRetrieverService.class);
    private final IBusinessService businessService;
    private final SecurityService securityService;

    public List<Situation> getEvents(EventFilter filter) {
        IBusinessService.EvenementFiltre eventFilter = filter.getSqlFilter();
        List javaFilters = filter.getJavaFilters();
        eventFilter.codeModuleMetier = filter.getMmCodes();
        eventFilter.delegation = filter.getDelegationAndCenter().getDelegation();
        eventFilter.centre = filter.getDelegationAndCenter().getCenter();
        return this.filterSituations(eventFilter.codeModuleMetier, this.businessService.getEvenements(eventFilter, javaFilters));
    }

    private List<Situation> filterSituations(List<Integer> mmCodes, List<Situation> situations) {
        ArrayList<Situation> filteredSituations = new ArrayList<Situation>();
        HashSet<Integer> handledEvents = new HashSet<Integer>();
        Map allowedNatures = this.getNatureAAfficher(mmCodes);
        for (Situation situation : situations) {
            for (Evenement event : MetierCommun.getEvenements((Situation)situation, (Map)allowedNatures, mmCodes)) {
                if (handledEvents.contains(event.getkEventid())) {
                    log.debug("Already handled: {}", (Object)event.getCodeEvenement());
                    continue;
                }
                Situation newSituation = new Situation(situation.getSid(), situation.getEvenements());
                newSituation.setEvenementPrincipal(event);
                filteredSituations.add(newSituation);
                handledEvents.add(event.getkEventid());
            }
        }
        return filteredSituations;
    }

    private Map<String, Nature> getNatureAAfficher(List<Integer> mmCodes) {
        Map naturesAAfficher = mmCodes.stream().map(arg_0 -> this.getNaturesAAfficher(arg_0)).collect(HashMap::new, HashMap::putAll, HashMap::putAll);
        if (naturesAAfficher.isEmpty()) {
            naturesAAfficher = this.businessService.getNatures();
        }
        return this.getNaturesAAfficherProfil(naturesAAfficher);
    }

    private static boolean aFiltreNatureAAfficher(ModuleMetier moduleMetier) {
        return Optional.ofNullable(moduleMetier).map(ModuleMetier::getParametres).map(mmParams -> mmParams.getString("natures-autorisees", null)).map(Predicate.not(String::isEmpty)::test).orElse(false);
    }

    private Map<String, Nature> getNaturesAAfficher(int codeModuleMetier) {
        ModuleMetier mm = (ModuleMetier)this.businessService.getModulesMetiers().get(codeModuleMetier);
        if (!CommonEventRetrieverService.aFiltreNatureAAfficher((ModuleMetier)mm)) {
            return Map.of();
        }
        return Optional.ofNullable(mm.getParametres()).map(mmParams -> mmParams.getList("natures-autorisees")).stream().flatMap(Collection::stream).collect(Collectors.toMap(Function.identity(), this.businessService.getNatures()::get));
    }

    private Map<String, Nature> getNaturesAAfficherProfil(Map<String, Nature> naturesMm) {
        Map naturesAAfficher = this.getParametresModificationNaturesAutorisees().stream().filter(naturesMm::containsKey).collect(Collectors.toMap(Function.identity(), naturesMm::get));
        return naturesAAfficher.isEmpty() ? naturesMm : naturesAAfficher;
    }

    private List<String> getParametresModificationNaturesAutorisees() {
        return Optional.ofNullable(this.securityService.getAuthenticatedUser().getPrismUser().getProfil().getParametres()).map(profileParams -> (MapDescription)profileParams.get(2)).map(actionParams -> actionParams.getList("natures-autorisees")).orElseGet(Collections::emptyList);
    }

    @Generated
    public CommonEventRetrieverService(IBusinessService businessService, SecurityService securityService) {
        this.businessService = businessService;
        this.securityService = securityService;
    }
}

