/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.list.impl;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Position;
import com.geolocsystems.prismandroid.model.Voie;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.RaccourciNature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.ValeurNature;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.geolocsystems.prismandroid.model.tunnel.LocalisationTunnel;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.export.i18n.ReportI18n;
import com.geolocsystems.prismcentralvaadin.util.ConfigUtils;
import com.neogls.prism.central.vaadin.rest.eventicon.EventIconController;
import com.neogls.prism.central.vaadin.rest.patrouilleviseeicon.PatrouilleViseeIconController;
import com.neogls.prism.central.vaadin.service.BusinessModuleService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.util.DateTimeFormatterUtils;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventListItemGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.impl.CommonEventListItemGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctListItem;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.shared.Tooltip;
import gls.localisation.LocalisationInfo;
import gls.localisation.pr.LocalisantPr;
import gls.outils.ConstantesGLS;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Primary
public class CommonEventListItemGeneratorService
implements EventListItemGeneratorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonEventListItemGeneratorService.class);
    private final ConfigurationService configurationService;
    private final IBusinessService businessService;
    private final BusinessModuleService businessModuleService;
    private static final String ESPACE = " ";
    private static final String AXIONE_TRANSMIS_ICON = "images/ico/axione_t_s.png";
    private static final String INTERVENTION_ICON = ConfigUtils.estTypeIconeDepartInterventionGyro() ? "images/ico/gyro.png" : "images/menu/intervention.png";
    private static final String USAGER_ICON = "images/ico/usager_s.png";

    public Component createEventListItem(Situation situation) {
        Context context = this.createContext(situation);
        return new MctListItem((Component)this.createEventIcon(context), new Component[]{this.firstLine(context), this.secondLine(context), this.getInformationsComplementaires(context), this.details(context)});
    }

    private Image createEventIcon(Context context) {
        ValeurNature valeurNature = context.getEvent().getValeurNature();
        String natureCode = this.businessService.getNaturesList().stream().filter(RaccourciNature.class::isInstance).map(RaccourciNature.class::cast).filter(raccourciNature -> valeurNature.getCode().equals(raccourciNature.getNature().getCode())).filter(raccourciNature -> valeurNature.getDescription().getValeur().equals(raccourciNature.getLabel())).findFirst().map(RaccourciNature::getCode).orElseGet(() -> ((ValeurNature)valeurNature).getCode());
        Image icon = new Image(EventIconController.Helper.createEventIconURL((String)natureCode), null);
        icon.setWidth(3.0f, Unit.EM);
        icon.addClassName("block");
        return icon;
    }

    private Context createContext(Situation situation) {
        Evenement event = situation.getEvenementPrincipal();
        String natureCode = event.getValeurNature().getCode();
        Nature nature = (Nature)this.businessService.getNatures().get(natureCode);
        boolean areFieldsConfigured = this.areFieldsConfigured(natureCode).orElse(false);
        boolean fieldLocalisationEnabled = !areFieldsConfigured || this.isFieldEnabled(natureCode, "localisation").orElse(true) != false;
        List champsSupplementaires = this.getFieldConfiguration(natureCode, "supplementaires").filter(strList -> areFieldsConfigured).orElse(List.of());
        List descriptionsSupplementaires = this.getFieldConfiguration(natureCode, "description").filter(strList -> areFieldsConfigured).orElse(List.of());
        boolean plusieursDepartements = nature != null && nature.getLocalisation() != null && MetierCommun.aPlusDunElement((List)nature.getLocalisation().getDepartements());
        boolean travaux = false;
        long dateTravaux = -1L;
        int codeMmPrincipal = (Integer)this.businessService.getNaturesMm().get(natureCode);
        for (Evenement evt : situation.getEvenements()) {
            int codeMm;
            if (ConstantesGLS.egal((String)evt.getCodeEvenement(), (String)event.getCodeEvenement()) || (codeMm = ((Integer)this.businessService.getNaturesMm().get(evt.getValeurNature().getCode())).intValue()) == codeMmPrincipal || codeMm != 2) continue;
            travaux = true;
            dateTravaux = Math.max(dateTravaux, evt.getDateCreation());
        }
        return new Context(situation, event, natureCode, nature, fieldLocalisationEnabled, champsSupplementaires, descriptionsSupplementaires, plusieursDepartements, travaux, dateTravaux, MetierCommun.getMapChamps((Nature)nature, (Evenement)event));
    }

    private Component firstLine(Context context) {
        Span label = new Span(this.generateFirstLineText(context));
        label.addClassNames(new String[]{"whitespace-normal", "text-xs"});
        FlexLayout layout = new FlexLayout(new Component[]{label});
        layout.setWidthFull();
        layout.setAlignItems(FlexComponent.Alignment.CENTER);
        layout.setFlexGrow(1.0, new HasElement[]{label});
        this.addIcons(context, (HasComponents)layout);
        if (!context.getEvent().isLu() && this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "mct.nonlu.bold").orElse(false).booleanValue()) {
            label.addClassName("font-bold");
        }
        return layout;
    }

    private String generateFirstLineText(Context context) {
        Evenement event = context.getEvent();
        Nature nature = context.getNature();
        Instant creationDate = Instant.ofEpochMilli(event.getDateCreation());
        String text = nature != null ? nature.getLabel() + " " + (creationDate.isBefore(Instant.now()) ? this.getTranslation((Object)"mct.description.cree", new Object[0]) : this.getTranslation((Object)"mct.description.prevue", new Object[0])) : context.getNatureCode() + " " + this.getTranslation((Object)"mct.description.cree", new Object[0]);
        return text + " " + this.getTranslation((Object)"mct.description.le", new Object[0]) + " " + DateTimeFormatterUtils.getDateFormatter().format(creationDate) + " " + this.getTranslation((Object)"mct.description.a", new Object[0]) + " " + DateTimeFormatterUtils.getTimeFormatter().format(creationDate) + " " + this.getTranslation((Object)"mct.description.par", new Object[0]) + " " + this.getUsername(event);
    }

    private String getUsername(Evenement event) {
        String creatorName;
        PrismCentralUser creator = this.businessService.getUtilisateur(event.getIdCreateur());
        String string = creatorName = creator != null ? creator.getNom() : null;
        if (creatorName != null && !creatorName.isBlank()) {
            return creatorName;
        }
        PrismCentralUser user = this.businessService.getUtilisateur(event.getCodeUtilisateur());
        return user != null ? user.getNom() : null;
    }

    private void addIcons(Context context, HasComponents layout) {
        Evenement event = context.getEvent();
        Nature nature = context.getNature();
        if (event.isPublie()) {
            layout.add(new Component[]{CommonEventListItemGeneratorService.createIcon((String)"images/ico/publish.png", (String)this.getTranslation((Object)"mct.published", new Object[0]))});
        }
        if (!ConstantesGLS.estVide((List)event.getPhotos())) {
            layout.add(new Component[]{CommonEventListItemGeneratorService.createIcon((String)"images/ico/photo.png", (String)this.getDescriptionPhoto(event))});
        }
        if (event.getUrgence() > 0) {
            layout.add(new Component[]{CommonEventListItemGeneratorService.createIcon((String)"images/ico/urgent.png", (String)this.getTranslation((Object)"mct.urgent", new Object[0]))});
        }
        if (event.getType() != 1) {
            switch (event.getType()) {
                case 2: {
                    layout.add(new Component[]{CommonEventListItemGeneratorService.createIcon((String)"images/ico/usager_s.png", (String)this.getTranslation((Object)"mct.usager.description", new Object[0]))});
                    break;
                }
                case 4: {
                    layout.add(new Component[]{CommonEventListItemGeneratorService.createIcon((String)"images/ico/axione_t_s.png", (String)this.getTranslation((Object)"mct.axione.description", new Object[0]))});
                    break;
                }
            }
        }
        if (!event.isLu() && !this.configurationService.isEtatEvenementTraiteActive() && this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "mct.nonlu.icone").orElse(true).booleanValue()) {
            layout.add(new Component[]{CommonEventListItemGeneratorService.createIcon((String)"images/ico/unread.png", (String)this.getTranslation((Object)"mct.unread", new Object[0]))});
        }
        if (this.estSituationAvecDDP(context.getSituation())) {
            Image ddp = nature.getCodeMM() == 0 ? CommonEventListItemGeneratorService.createIcon((String)INTERVENTION_ICON, (String)"Intervention") : CommonEventListItemGeneratorService.createIcon((String)"images/ico/ddp.png", (String)"DDP");
            layout.add(new Component[]{ddp});
        }
    }

    private String getDescriptionPhoto(Evenement event) {
        return event.getPhotos().size() == 1 ? event.getPhotos().size() + " " + this.getTranslation((Object)"mct.picture", new Object[0]) : event.getPhotos().size() + " " + this.getTranslation((Object)"mct.pictures", new Object[0]);
    }

    private boolean estSituationAvecDDP(Situation situation) {
        return MetierCommun.estDDP((Situation)situation, (Map)this.businessService.getNatures()) || MetierCommun.estDDP((Evenement)situation.getEvenementPrincipal());
    }

    private Component secondLine(Context context) {
        Span label = new Span();
        label.setWidthFull();
        FlexLayout layout = new FlexLayout(new Component[]{label});
        layout.setWidthFull();
        layout.setAlignItems(FlexComponent.Alignment.CENTER);
        String result = this.getValeurDescription(context);
        if (context.isFieldLocalisationEnabled()) {
            result = Stream.of(result, this.getLocalisation(context, (HasStyle)label)).filter(Predicate.not(String::isBlank)).collect(Collectors.joining(" "));
        }
        label.setText(result);
        label.addClassNames(new String[]{"whitespace-normal", "text-xs"});
        layout.add(new Component[]{this.getImageEtat(context)});
        return layout;
    }

    private String getValeurDescription(Context context) {
        Nature nature = context.getNature();
        List natureDescription = nature.getDescription().getValeurs();
        int indexDescription = Math.max(0, context.getEvent().getValeurNature().getDescription().getIndexSelectionnee());
        if (context.getDescriptionsSupplementaires().isEmpty()) {
            return (String)natureDescription.get(indexDescription);
        }
        String descriptionsSupplementaires = this.parseFields(context, context.getDescriptionsSupplementaires());
        if (natureDescription.size() == 1) {
            return descriptionsSupplementaires;
        }
        return (String)natureDescription.get(indexDescription) + " (" + descriptionsSupplementaires + ")";
    }

    private String getLocalisation(Context context, HasStyle label) {
        Nature nature = context.getNature();
        Evenement event = context.getEvent();
        if (nature == null) {
            return "";
        }
        if (event.getEtat() == 2) {
            String result = ConstantesGLS.estVide((String)event.getLocalisation().getAxe()) || ConstantesGLS.egal((String)event.getLocalisation().getAxe(), (String)this.getTranslation((Object)"localisation.aucunaxe", new Object[0])) ? (event.getLocalisation().getCommune() != null ? this.getTranslation((Object)"mct.description.surcommune", new Object[0]) + " " + event.getLocalisation().getCommune() : " - " + CommonEventListItemGeneratorService.positionToString((Position)event.getLocalisation().getPositionDebut())) : this.getTranslation((Object)"mct.description.sur", new Object[0]) + " " + event.getLocalisation().getAxe() + " - " + Objects.requireNonNullElseGet(event.getLocalisation().getCommune(), () -> CommonEventListItemGeneratorService.positionToString((Position)event.getLocalisation().getPositionDebut()));
            return result + this.getLocalisationSpecifiqueVoie(event) + this.getLocalisationPr(event, context.isPlusieursDepartements()) + CommonEventListItemGeneratorService.getLocalisationAdresse((Evenement)event);
        }
        if (event.getEtat() == 1) {
            label.getStyle().set("color", "#FF0000");
            label.addClassName("font-bold");
            return this.getTranslation((Object)"mct.description.paslocal", new Object[0]);
        }
        if (event.getEtat() == 3) {
            label.getStyle().set("color", "#FF0000");
            label.addClassName("font-bold");
            return event.getErreur();
        }
        return "";
    }

    private String getLocalisationSpecifiqueVoie(Evenement event) {
        if (Voie.isTunnel((String)event.getLocalisation().getVoie())) {
            LocalisationTunnel localisationTunnel = MetierCommun.getLocalisationTunnel((int)event.getLocalisation().getPointParticulier(), (List)this.businessService.getTunnels());
            return String.valueOf(localisationTunnel);
        }
        return "";
    }

    private String getLocalisationPr(Evenement event, boolean plusieursdepartements) {
        if (LocalisationInfo.estLocalisableParPrpk) {
            int prDeb = event.getLocalisation().getPrDebut();
            int prFin = event.getLocalisation().getPrFin();
            int absPrDeb = event.getLocalisation().getAbsPrDebut();
            int absPrFin = event.getLocalisation().getAbsPrFin();
            if (prDeb == -1 && prFin == -1) {
                return "";
            }
            if (prFin != -1 && (prDeb != prFin || absPrDeb != absPrFin)) {
                return " -  " + this.getTranslation((Object)"mct.description.frompr", new Object[0]) + CommonEventListItemGeneratorService.getLibellePrDebut((ValeurChampLocalisation)event.getLocalisation(), (boolean)plusieursdepartements) + CommonEventListItemGeneratorService.getLibelleAbscissePr((int)absPrDeb) + " " + this.getTranslation((Object)"mct.description.topr", new Object[0]) + CommonEventListItemGeneratorService.getLibellePrFin((ValeurChampLocalisation)event.getLocalisation(), (boolean)plusieursdepartements) + CommonEventListItemGeneratorService.getLibelleAbscissePr((int)absPrFin);
            }
            return " -  " + this.getTranslation((Object)"mct.description.atpr", new Object[0]) + CommonEventListItemGeneratorService.getLibellePrDebut((ValeurChampLocalisation)event.getLocalisation(), (boolean)plusieursdepartements) + CommonEventListItemGeneratorService.getLibelleAbscissePr((int)absPrDeb);
        }
        return "";
    }

    private Image getImageEtat(Context context) {
        Evenement event = context.getEvent();
        if (event.getEtat() == 3) {
            return CommonEventListItemGeneratorService.createIcon((String)"images/ico/etat_erreur.png", (String)this.getTranslation((Object)"mct.etat_erreur", new Object[0]));
        }
        if (event.isProgramme()) {
            if (context.isTravaux()) {
                return CommonEventListItemGeneratorService.createIcon((String)(context.getDateTravaux() > System.currentTimeMillis() ? "images/ico/etat_travaux_programme.png" : "images/ico/etat_travaux.png"), (String)(context.getDateTravaux() > System.currentTimeMillis() ? this.getTranslation((Object)"mct.etat_travaux_programme", new Object[0]) : this.getTranslation((Object)"mct.etat_travaux", new Object[0])));
            }
            if (event.isPrevisionnel()) {
                return CommonEventListItemGeneratorService.createIcon((String)"images/ico/etat_previsionnel_prog.png", (String)this.getCommentairePlanification(event));
            }
            if (this.estGestionDateButoir().orElse(false).booleanValue()) {
                if (event.getDateFin() < System.currentTimeMillis()) {
                    return CommonEventListItemGeneratorService.createIcon((String)"images/ico/etat_depasse.png", (String)this.getCommentairePlanification(event));
                }
                return CommonEventListItemGeneratorService.createIcon((String)"images/ico/etat_programme.png", (String)this.getCommentairePlanification(event));
            }
            return CommonEventListItemGeneratorService.createIcon((String)"images/ico/etat_programme.png", (String)this.getCommentairePlanification(event));
        }
        if (event.isPrevisionnel()) {
            return CommonEventListItemGeneratorService.createIcon((String)"images/ico/etat_previsionnel.png", (String)this.getTranslation((Object)"mct.etat_previsionnel", new Object[0]));
        }
        if (event.isAnnule()) {
            return CommonEventListItemGeneratorService.createIcon((String)"images/ico/etat_annule.png", (String)this.getTranslation((Object)"mct.etat_annule", new Object[0]));
        }
        if (event.isTermine()) {
            return CommonEventListItemGeneratorService.createIcon((String)"images/ico/etat_cloture.png", (String)this.getTranslation((Object)"mct.etat_cloture", new Object[0]));
        }
        if (event.isTraite() && this.configurationService.isEtatEvenementTraiteActive()) {
            if (this.estModulePatrouillage(context.getNature())) {
                return CommonEventListItemGeneratorService.createIcon((String)"images/ico/etat_traite.png", (String)this.getTranslation((Object)"mct.etat_traite", new Object[0]));
            }
            if (this.estModuleIntervention(context.getNature())) {
                return CommonEventListItemGeneratorService.createIcon((String)PatrouilleViseeIconController.Helper.createPatrouilleViseeIconURL((boolean)true), (String)this.getTranslation((Object)"mct.etat_vise", new Object[0]));
            }
            return CommonEventListItemGeneratorService.createIcon((String)"images/ico/etat_traite.png", (String)this.getTranslation((Object)"mct.etat_traite", new Object[0]));
        }
        return CommonEventListItemGeneratorService.createIcon((String)"images/ico/etat_encours_vide.png", (String)this.getTranslation((Object)"mct.etat_encours", new Object[0]));
    }

    private String getCommentairePlanification(Evenement event) {
        StringBuilder sb = new StringBuilder(this.getTranslation((Object)"mct.etat_programme", new Object[0]));
        if (MetierCommun.estEntretien((Evenement)event, (List)this.businessService.getNaturesList()) && event.getDateCreation() > System.currentTimeMillis()) {
            sb.append(" le ").append(DateTimeFormatterUtils.getDateFormatter().format(Instant.ofEpochMilli(event.getDateCreation())));
        }
        return sb.toString();
    }

    private String getCommentaireDepasse(Evenement event) {
        StringBuilder sb = new StringBuilder(this.getTranslation((Object)"mct.etat_depasse", new Object[0]));
        if (MetierCommun.estEntretien((Evenement)event, (List)this.businessService.getNaturesList()) && event.getDateCreation() > System.currentTimeMillis()) {
            sb.append(" le ").append(DateTimeFormatterUtils.getDateFormatter().format(Instant.ofEpochMilli(event.getDateCreation())));
        }
        return sb.toString();
    }

    private Component getInformationsComplementaires(Context context) {
        String text;
        Evenement event = context.getEvent();
        StringBuilder buffer = new StringBuilder();
        if (MetierCommun.estComplementDiffrentRD((ValeurChampLocalisation)event.getLocalisation())) {
            buffer.append(event.getLocalisation().getComplementLocalisation());
        }
        if (!context.getChampsSupplementaires().isEmpty()) {
            buffer.append(this.parseFields(context, context.getChampsSupplementaires()));
        }
        if (!(text = buffer.toString()).isBlank()) {
            Span label = new Span(text);
            label.setWidthFull();
            label.addClassNames(new String[]{"whitespace-normal", "text-xs"});
            return label;
        }
        return null;
    }

    private Component details(Context context) {
        if (!this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "afficheIdEvenement").orElse(false).booleanValue()) {
            return null;
        }
        Span label = new Span("ID : " + context.getEvent().getCodeEvenement());
        label.setWidthFull();
        label.addClassNames(new String[]{"whitespace-normal", "text-xs"});
        return label;
    }

    private String parseFields(Context context, List<String> fields) {
        if (fields.isEmpty()) {
            return null;
        }
        return fields.stream().map(field -> this.parseField(context, field)).filter(Predicate.not(String::isBlank)).collect(Collectors.joining(" -- "));
    }

    private String parseField(Context context, String field) {
        String[] champParse = field.split(":");
        String nomChamp = champParse[0];
        Map mapChamps = context.getFieldMap();
        Object libelleChamp = champParse.length > 1 ? champParse[1] + " : " : "";
        String valeurChamp = (String)mapChamps.get(nomChamp);
        if (ConstantesGLS.estVide((String)valeurChamp) || ConstantesGLS.egal((String)valeurChamp, (String)"null") || MetierCommun.estValeurSysteme((String)valeurChamp)) {
            return "";
        }
        return (String)libelleChamp + valeurChamp;
    }

    private Optional<Boolean> areFieldsConfigured(String natureCode) {
        return this.isFieldEnabled(natureCode, null);
    }

    private Optional<Boolean> isFieldEnabled(String natureCode, String fieldName) {
        return this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, CommonEventListItemGeneratorService.getFieldsConfigName((String)natureCode, (String)fieldName));
    }

    private Optional<List<String>> getFieldConfiguration(String natureCode, String fieldName) {
        return this.configurationService.getList(ConfigurationService.ConfigurationType.DATABASE, CommonEventListItemGeneratorService.getFieldsConfigName((String)natureCode, (String)fieldName));
    }

    private boolean estModulePatrouillage(Nature nature) {
        return this.businessModuleService.isInheritedModule(nature.getCodeMM(), 0);
    }

    private Optional<Boolean> estGestionDateButoir() {
        return this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "gestionDateButoir");
    }

    private boolean estModuleIntervention(Nature nature) {
        return this.businessModuleService.isInheritedModule(nature.getCodeMM(), 5);
    }

    private String getTranslation(Object key, Object ... params) {
        return UI.getCurrent().getTranslation(key, params);
    }

    private static Image createIcon(String href, String tooltip) {
        Image icon = new Image(href, null);
        icon.addClassNames(new String[]{"box-border", "icon-m", "p-xs"});
        if (tooltip != null) {
            Tooltip.forComponent((Component)icon).withText(tooltip);
        }
        return icon;
    }

    private static String getFieldsConfigName(String natureCode, String field) {
        return "listitem." + Objects.requireNonNull(natureCode) + ".affichage.champs" + (String)(field != null ? "." + field : "");
    }

    private static String positionToString(Position position) {
        return "(" + position.getX() + ";" + position.getY() + ")";
    }

    public static String getLibellePrDebut(ValeurChampLocalisation v, boolean plusieursDepartements) {
        if (plusieursDepartements) {
            return LocalisantPr.toString((int)v.getPrDebut(), (String)v.getDeptDebut());
        }
        return LocalisantPr.toString((int)v.getPrDebut(), (String)"-1");
    }

    public static String getLibellePrFin(ValeurChampLocalisation v, boolean plusieursDepartements) {
        if (plusieursDepartements) {
            return LocalisantPr.toString((int)v.getPrFin(), (String)v.getDeptFin());
        }
        return LocalisantPr.toString((int)v.getPrFin(), (String)"-1");
    }

    private static String getLibelleAbscissePr(int abscissePr) {
        if (abscissePr < 0) {
            return String.valueOf(abscissePr);
        }
        return "+" + abscissePr;
    }

    private static String getLocalisationAdresse(Evenement e) {
        if (!LocalisationInfo.estLocalisableParAdresse || ConstantesGLS.estVide((String)e.getLocalisation().getAdresseDebut())) {
            return "";
        }
        StringBuilder buf = new StringBuilder(" ");
        if (ConstantesGLS.estVide((String)e.getLocalisation().getAdresseFin())) {
            buf.append(ReportI18n.getString((String)"aunumero")).append(" ").append(e.getLocalisation().getAdresseDebut()).append(" ");
        } else {
            buf.append(ReportI18n.getString((String)"dunumero")).append(" ").append(e.getLocalisation().getAdresseDebut()).append(" ");
            buf.append(ReportI18n.getString((String)"aunumero")).append(" ").append(e.getLocalisation().getAdresseFin()).append(" ");
        }
        return buf.toString();
    }

    @Generated
    public CommonEventListItemGeneratorService(ConfigurationService configurationService, IBusinessService businessService, BusinessModuleService businessModuleService) {
        this.configurationService = configurationService;
        this.businessService = businessService;
        this.businessModuleService = businessModuleService;
    }
}

