/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.list.impl;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.rest.export.situation.SituationExportService;
import com.neogls.prism.central.vaadin.rest.patrouilleviseeicon.PatrouilleViseeIconController;
import com.neogls.prism.central.vaadin.service.BusinessModuleService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.util.DateTimeFormatterUtils;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventDetailsGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.impl.SituationExportButton;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import java.io.Serializable;
import java.sql.SQLException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Primary
public class CommonEventDetailsGeneratorService
implements EventDetailsGeneratorService<EventActionListener> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CommonEventDetailsGeneratorService.class);
    private final ConfigurationService configurationService;
    private final IBusinessService businessService;
    private final UserPermissionService userPermissionService;
    private final BusinessModuleService businessModuleService;
    private final SituationExportService situationExportService;
    private static final String ICON_VIEW = "images/ico/view.png";
    private static final String ICON_EDIT = "images/ico/edit.png";
    private static final String ICON_CLOSE = "images/ico/cancel.png";
    private static final String ICON_UNCLOSE = "images/ico/uncancel.png";
    private static final String ICON_PUBLISH = "images/ico/publish.png";
    private static final String ICON_UNPUBLISH = "images/ico/unpublish.png";
    private static final String ICON_ASSOCIATE = "images/ico/associate.png";
    private static final String ICON_PROGRAM = "images/ico/program.png";
    private static final String ICON_DEPROGRAM = "images/ico/deprogram.png";
    private static final String ICON_CANCEL = "images/ico/annule.png";
    private static final String ICON_AXIONE = "images/ico/axione_s.png";
    private static final String ICON_VISA_INTERVENTION = PatrouilleViseeIconController.Helper.createPatrouilleViseeIconURL((boolean)true);
    private static final String ICON_ENLEVER_VISA_INTERVENTION = PatrouilleViseeIconController.Helper.createPatrouilleViseeIconURL((boolean)false);
    private static final String ICON_CREER_TRAVAUX = "images/ico/creer_travaux.png";
    private static final String ICON_SUPPRIMER_TRAVAUX = "images/ico/supprimer_travaux.png";
    private static final String ICON_DELETE = "images/ico/dustbin.png";
    private static final String ICON_CALL = "images/ico/appel.png";
    private static final String FORM_LAYOUT_COLUMN_SPACING = "var(--lumo-space-s)";
    private static final int COLUMN_MIN_WIDTH = 16;
    private static final Unit COLUMN_WIDTH_UNIT = Unit.EM;
    private static final int MAX_COLUMNS = 5;
    private static final List<FormLayout.ResponsiveStep> RESPONSIVE_STEPS = IntStream.range(0, 5).mapToObj(i -> new FormLayout.ResponsiveStep(i * 16 + COLUMN_WIDTH_UNIT.getSymbol(), i + 1)).toList();

    public Component createEventDetails(Situation situation, EventActionListener eventActionListener) {
        Evenement event = situation.getEvenementPrincipal();
        Span lastEdition = new Span(this.getLastEditionText(event));
        lastEdition.setWidthFull();
        lastEdition.addClassName("text-2xs");
        FormLayout actions = new FormLayout();
        this.addActionButtons(actions, situation, event, eventActionListener);
        actions.getStyle().set("--vaadin-form-layout-column-spacing", "var(--lumo-space-s)");
        actions.setResponsiveSteps(RESPONSIVE_STEPS);
        VerticalLayout details = new VerticalLayout(new Component[]{lastEdition, actions});
        details.setPadding(false);
        details.setSpacing(false);
        return details;
    }

    private String getLastEditionText(Evenement event) {
        if (event.getNumVersion() <= 1) {
            return null;
        }
        Instant lastUpdateTime = Instant.ofEpochMilli(event.getDateMaj());
        PrismCentralUser user = this.businessService.getUtilisateur(event.getCodeUtilisateur());
        String userName = user != null ? user.getNom() : "(Anonyme)";
        return String.format("Derni\u00e8re modification le %s %s %s %s %s", DateTimeFormatterUtils.getDateFormatter().format(lastUpdateTime), CommonEventDetailsGeneratorService.getTranslation((Object)"mct.description.a", (Object[])new Object[0]), DateTimeFormatterUtils.getTimeFormatter().format(lastUpdateTime), CommonEventDetailsGeneratorService.getTranslation((Object)"mct.description.par", (Object[])new Object[0]), userName);
    }

    private void addActionButtons(FormLayout actions, Situation situation, Evenement event, EventActionListener eventActionListener) {
        Nature nature = (Nature)this.businessService.getNatures().get(event.getValeurNature().getCode());
        boolean confBoutonOuvrir = this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "mct.bouton.ouvrir").orElse(false);
        boolean canEditEventsOfNature = this.userPermissionService.canCreateEventOfNature(nature);
        boolean canCancelClosedEvents = this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "mct.annulecloture").orElse(true);
        if (confBoutonOuvrir) {
            Button bOpen = canEditEventsOfNature && (!event.isTermine() || this.userPermissionService.canEditClosedEvent()) ? this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.open", (Object[])new Object[0]), "images/ico/edit.png", (ComponentEventListener & Serializable)e -> eventActionListener.onEdit(situation)) : this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.open", (Object[])new Object[0]), "images/ico/view.png", (ComponentEventListener & Serializable)e -> eventActionListener.onView(situation));
            actions.add(new Component[]{bOpen});
        } else {
            Button bView = this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.view", (Object[])new Object[0]), "images/ico/view.png", (ComponentEventListener & Serializable)e -> eventActionListener.onView(situation));
            actions.add(new Component[]{bView});
            if (canEditEventsOfNature && (!event.isTermine() || this.userPermissionService.canEditClosedEvent())) {
                Button bEdit = this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.edit", (Object[])new Object[0]), "images/ico/edit.png", (ComponentEventListener & Serializable)e -> eventActionListener.onEdit(situation));
                actions.add(new Component[]{bEdit});
            }
        }
        if (canEditEventsOfNature) {
            if (!event.isTermine() && this.userPermissionService.canCloseEventsOfNature(nature)) {
                Button bClose = this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.close", (Object[])new Object[0]), "images/ico/cancel.png", (ComponentEventListener & Serializable)e -> eventActionListener.onClose(situation));
                actions.add(new Component[]{bClose});
            }
            if (event.isTermine() && this.userPermissionService.canUncloseEventsOfNature(nature)) {
                Button bUnclose = this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.unclose", (Object[])new Object[0]), "images/ico/uncancel.png", (ComponentEventListener & Serializable)e -> eventActionListener.onUnclose(situation));
                actions.add(new Component[]{bUnclose});
            }
            if (!event.isAnnule() && this.userPermissionService.canDo(8) && (canCancelClosedEvents || !event.isTermine())) {
                Button bCancel = this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.cancel", (Object[])new Object[0]), "images/ico/annule.png", (ComponentEventListener & Serializable)e -> eventActionListener.onCancel(situation));
                actions.add(new Component[]{bCancel});
            }
            if (event.isAnnule() && this.userPermissionService.canDo(202)) {
                Button bDelete = this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.suppr", (Object[])new Object[0]), "images/ico/dustbin.png", (ComponentEventListener & Serializable)e -> eventActionListener.onDelete(situation));
                actions.add(new Component[]{bDelete});
            }
        }
        if (!event.isTermine() && this.userPermissionService.canPublishEventsOfNature(nature)) {
            Button bPublish = this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)(event.isPublie() ? "mct.action.modifpublish" : "mct.action.publish"), (Object[])new Object[0]), "images/ico/publish.png", (ComponentEventListener & Serializable)e -> eventActionListener.onPublish(situation));
            actions.add(new Component[]{bPublish});
            if (event.isPublie()) {
                Button bUnpublish = this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.unpublish", (Object[])new Object[0]), "images/ico/unpublish.png", (ComponentEventListener & Serializable)e -> eventActionListener.onUnpublish(situation));
                actions.add(new Component[]{bUnpublish});
            }
        }
        if (this.isButtonAssociateVisible(event)) {
            Button bAssociate = this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.associate", (Object[])new Object[0]), "images/ico/associate.png", (ComponentEventListener & Serializable)e -> eventActionListener.onAssociate(situation));
            actions.add(new Component[]{bAssociate});
            if (MetierCommun.estDDP((Situation)situation, (Map)this.businessService.getNatures()) || MetierCommun.estDDP((Evenement)event)) {
                bAssociate.setEnabled(false);
            }
        }
        if (this.isButtonProgramVisible(event).booleanValue()) {
            Button bProgram = this.createProgramButton(situation, event, eventActionListener);
            actions.add(new Component[]{bProgram});
        }
        if (MetierCommun.estIntervention((Evenement)event, (List)this.businessService.getNaturesList()) && !event.isTermine() && this.userPermissionService.canDo(503)) {
            Button bCall = this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.appel", (Object[])new Object[0]), "images/ico/appel.png", (ComponentEventListener & Serializable)e -> eventActionListener.onCall(situation));
            actions.add(new Component[]{bCall});
        }
        if (this.userPermissionService.canDo(22)) {
            List eventToExport = situation.getEvenements();
            SituationExportButton situationExportButton = new SituationExportButton(eventToExport, this.situationExportService.getNatureExport(nature));
            actions.add(new Component[]{situationExportButton});
        }
        if (this.isButtonAxioneExportVisible(event)) {
            Button bAxioneExport = this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.axione", (Object[])new Object[0]), "images/ico/axione_s.png", (ComponentEventListener & Serializable)e -> eventActionListener.onAxioneExport(situation));
            actions.add(new Component[]{bAxioneExport});
        }
        this.createVisaInterventionButton(situation, event, nature, eventActionListener).ifPresent(xva$0 -> actions.add(new Component[]{xva$0}));
    }

    private Button createProgramButton(Situation situation, Evenement event, EventActionListener eventActionListener) {
        Button bProgram;
        if (!event.isProgramme()) {
            bProgram = this.configurationService.isProgrammationTravauxActive() && MetierCommun.estPatrouillage((Evenement)event, (List)this.businessService.getNaturesList()) ? this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.creer_travaux", (Object[])new Object[0]), "images/ico/creer_travaux.png", (ComponentEventListener & Serializable)e -> eventActionListener.onProgram(situation)) : this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.programme", (Object[])new Object[0]), "images/ico/program.png", (ComponentEventListener & Serializable)e -> eventActionListener.onProgram(situation));
            if (event.isTraite()) {
                bProgram.setEnabled(false);
                bProgram.setTooltipText("L'\u00e9v\u00e9nement est indiqu\u00e9 trait\u00e9, sa programmation est impossible");
            }
        } else {
            bProgram = this.configurationService.isProgrammationTravauxActive() && MetierCommun.estPatrouillage((Evenement)event, (List)this.businessService.getNaturesList()) ? this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.supprimer_travaux", (Object[])new Object[0]), "images/ico/supprimer_travaux.png", (ComponentEventListener & Serializable)e -> eventActionListener.onDeprogram(situation)) : this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.deprogramme", (Object[])new Object[0]), "images/ico/deprogram.png", (ComponentEventListener & Serializable)e -> eventActionListener.onDeprogram(situation));
        }
        return bProgram;
    }

    private Optional<Button> createVisaInterventionButton(Situation situation, Evenement event, Nature nature, EventActionListener eventActionListener) {
        if (this.businessModuleService.isInheritedModule(nature.getCodeMM(), 5)) {
            if (!event.isTraite() && this.userPermissionService.canDo(91)) {
                return Optional.of(this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.visa_intervention", (Object[])new Object[0]), ICON_VISA_INTERVENTION, (ComponentEventListener & Serializable)e -> eventActionListener.onVisaIntervention(situation)));
            }
            if (event.isTraite() && this.userPermissionService.canDo(92)) {
                return Optional.of(this.createButton(CommonEventDetailsGeneratorService.getTranslation((Object)"mct.action.cancel_visa_intervention", (Object[])new Object[0]), ICON_ENLEVER_VISA_INTERVENTION, (ComponentEventListener & Serializable)e -> eventActionListener.onVisaInterventionCancel(situation)));
            }
        }
        return Optional.empty();
    }

    private boolean isButtonAssociateVisible(Evenement event) {
        return this.userPermissionService.canDo(5) && MetierCommun.estPatrouillage((Evenement)event, (List)this.businessService.getNaturesList());
    }

    private Boolean isButtonProgramVisible(Evenement event) {
        return !event.isTermine() && this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "gestionProgrammation").orElse(false) != false && this.userPermissionService.canDo(200) && (MetierCommun.estPatrouillage((Evenement)event, (List)this.businessService.getNaturesList()) || MetierCommun.estEntretien((Evenement)event, (List)this.businessService.getNaturesList()));
    }

    private boolean isButtonAxioneExportVisible(Evenement event) {
        try {
            return MetierCommun.aTypeUtilisateurAxione((List)this.businessService.getTypesUtilisateur()) && MetierCommun.estTypeDefautPrism((int)event.getType()) && !this.businessService.getListePartenaireExportEvenementAxione(event.getValeurNature().getCode()).isEmpty();
        }
        catch (SQLException e) {
            log.error("", (Throwable)e);
            return false;
        }
    }

    private Button createButton(String text, ComponentEventListener<ClickEvent<Button>> clickListener) {
        return this.createButton(text, null, clickListener);
    }

    private Button createButton(String text, String iconName, ComponentEventListener<ClickEvent<Button>> clickListener) {
        Button button = new Button(text);
        if (iconName != null) {
            Image icon = new Image(iconName, null);
            icon.addClassName("mr-xs");
            button.setIcon((Component)icon);
        }
        if (clickListener != null) {
            button.addClickListener(clickListener);
        }
        button.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_SMALL});
        button.addClassName("text-2xs");
        return button;
    }

    private static String getTranslation(Object key, Object ... params) {
        return UI.getCurrent().getTranslation(key, params);
    }

    @Generated
    public CommonEventDetailsGeneratorService(ConfigurationService configurationService, IBusinessService businessService, UserPermissionService userPermissionService, BusinessModuleService businessModuleService, SituationExportService situationExportService) {
        this.configurationService = configurationService;
        this.businessService = businessService;
        this.userPermissionService = userPermissionService;
        this.businessModuleService = businessModuleService;
        this.situationExportService = situationExportService;
    }
}

