/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.list.impl;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.common.component.confirmdialog.ButtonConfig;
import com.neogls.prism.central.vaadin.common.component.confirmdialog.ConfirmDialog;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.event.EventService;
import com.neogls.prism.central.vaadin.view.addcommentdialog.AddActionDialog;
import com.neogls.prism.central.vaadin.view.addcommentdialog.AddActionDialogService;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventassociationdialog.EventAssociationDialog;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventassociationdialog.EventAssociationDialogService;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialog;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialogFactory;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.list.AbstractActionListener;
import com.neogls.prism.central.vaadin.view.publish.EventPublishDialog;
import com.neogls.prism.central.vaadin.view.publish.EventPublishDialogService;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Primary
@Scope(value="prototype")
public class CommonEventActionListener
extends AbstractActionListener<Situation>
implements EventActionListener {
    private final EventService eventService;
    private final UserPermissionService userPermissionService;
    private final IBusinessService businessService;
    private final AddActionDialogService service;
    private final ConfigurationService configurationService;
    private final EventSheetDialogFactory eventSheetDialogFactory;
    private final EventAssociationDialogService eventAssociationDialogService;
    private final EventPublishDialogService eventPublishDialogService;

    public void onReadAll(Collection<Situation> situations) {
        ConfirmDialog.builder().title(CommonEventActionListener.getTranslation((String)"mct.read.confirm.title", (Object[])new Object[0])).text(CommonEventActionListener.getTranslation((String)"mct.read.confirm.message", (Object[])new Object[0])).confirm(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.confirm.ok", (Object[])new Object[0])).listener((ComponentEventListener & Serializable)event -> {
            this.eventService.readEvents(situations);
            this.refreshAll();
        }).build()).cancel(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.confirm.nok", (Object[])new Object[0])).build()).build().open();
    }

    public void onOpen(Situation situation) {
        Evenement event = situation.getEvenementPrincipal();
        Nature nature = (Nature)this.businessService.getNatures().get(event.getValeurNature().getCode());
        boolean userCanEditEvents = this.userPermissionService.canDo(2);
        boolean canEditThisEvent = !event.isTermine() || this.userPermissionService.canEditClosedEvent();
        boolean canEditEventOfNature = this.userPermissionService.canCreateEventOfNature(nature);
        if (userCanEditEvents && canEditThisEvent && canEditEventOfNature) {
            this.onEdit(situation);
        } else {
            this.onView(situation);
        }
    }

    public void onView(Situation situation) {
        if (this.eventService.canReadEvent()) {
            this.eventService.readEvent(situation);
            this.refreshItem((Object)situation);
        }
        this.eventSheetDialogFactory.createEventSheetDialogReadOnly(situation).open();
    }

    public void onEdit(Situation situation) {
        if (this.eventService.canReadEvent()) {
            this.eventService.readEvent(situation);
        }
        EventSheetDialog eventSheetDialog = this.eventSheetDialogFactory.createEventSheetDialogForEdition(situation);
        eventSheetDialog.addEventSaveListener((ComponentEventListener & Serializable)event -> this.eventService.saveEvent(event.getEvent(), event.getPhotoList()));
        eventSheetDialog.addOpenedChangeListener((ComponentEventListener & Serializable)event -> {
            if (!event.isOpened()) {
                this.refreshAll();
            }
        });
        eventSheetDialog.open();
    }

    public void onClose(Situation situation) {
        if (this.configurationService.isFastCloseModeEnabled()) {
            ConfirmDialog.builder().title(CommonEventActionListener.getTranslation((String)"mct.close.confirm.title", (Object[])new Object[0])).text(CommonEventActionListener.getTranslation((String)"mct.close.confirm.message", (Object[])new Object[0])).confirm(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.close.confirm.ok", (Object[])new Object[0])).listener((ComponentEventListener & Serializable)event -> {
                this.eventService.closeEvent(situation);
                this.refreshAll();
            }).build()).cancel(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.close.confirm.nok", (Object[])new Object[0])).build()).build().open();
        } else {
            EventSheetDialog eventSheetDialog = this.eventSheetDialogFactory.createDefaultEventSheet(situation, false);
            eventSheetDialog.setSaveButtonText(CommonEventActionListener.getTranslation((String)"mct.action.close", (Object[])new Object[0]));
            eventSheetDialog.setSaveButtonIcon(null);
            eventSheetDialog.addEventSaveListener((ComponentEventListener & Serializable)event -> this.eventService.editAndCloseEvent(event.getEvent(), event.getPhotoList()));
            eventSheetDialog.addOpenedChangeListener((ComponentEventListener & Serializable)event -> {
                if (!event.isOpened()) {
                    this.refreshAll();
                }
            });
            eventSheetDialog.open();
        }
    }

    public void onClose(Collection<Situation> situations) {
        ConfirmDialog.builder().title(CommonEventActionListener.getTranslation((String)"mct.close.confirm.title", (Object[])new Object[0])).text(CommonEventActionListener.getTranslation((String)"mct.close.confirm.message", (Object[])new Object[0])).confirm(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.confirm.ok", (Object[])new Object[0])).listener((ComponentEventListener & Serializable)event -> {
            this.eventService.closeEvents(situations);
            this.refreshAll();
        }).build()).cancel(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.confirm.nok", (Object[])new Object[0])).build()).build().open();
    }

    public void onUnclose(Situation situation) {
        ConfirmDialog.builder().title(CommonEventActionListener.getTranslation((String)"mct.unclose.confirm.title", (Object[])new Object[0])).text(CommonEventActionListener.getTranslation((String)"mct.unclose.confirm.message", (Object[])new Object[0])).confirm(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.confirm.ok", (Object[])new Object[0])).listener((ComponentEventListener & Serializable)event -> {
            this.eventService.uncloseEvent(situation);
            this.refreshAll();
        }).build()).cancel(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.confirm.nok", (Object[])new Object[0])).build()).build().open();
    }

    public void onCancel(Situation situation) {
        ConfirmDialog.builder().title(CommonEventActionListener.getTranslation((String)"mct.cancel.confirm.title", (Object[])new Object[0])).text(CommonEventActionListener.getTranslation((String)"mct.cancel.confirm.message", (Object[])new Object[0])).confirm(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.cancel.confirm.ok", (Object[])new Object[0])).listener((ComponentEventListener & Serializable)event -> {
            this.eventService.cancelEvent(situation);
            this.refreshAll();
        }).build()).cancel(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.cancel.confirm.nok", (Object[])new Object[0])).build()).build().open();
    }

    public void onCancel(Collection<Situation> situations) {
        ConfirmDialog.builder().title(CommonEventActionListener.getTranslation((String)"mct.cancel.confirm.title", (Object[])new Object[0])).text(CommonEventActionListener.getTranslation((String)"mct.cancel.confirm.message", (Object[])new Object[0])).confirm(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.confirm.ok", (Object[])new Object[0])).listener((ComponentEventListener & Serializable)event -> {
            this.eventService.cancelEvents(situations);
            this.refreshAll();
        }).build()).cancel(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.confirm.nok", (Object[])new Object[0])).build()).build().open();
    }

    public void onDelete(Situation situation) {
        ConfirmDialog.builder().title(CommonEventActionListener.getTranslation((String)"mct.suppr.confirm.title", (Object[])new Object[0])).text(CommonEventActionListener.getTranslation((String)"mct.suppr.confirm.message", (Object[])new Object[0])).confirm(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.suppr.confirm.ok", (Object[])new Object[0])).listener((ComponentEventListener & Serializable)event -> {
            this.eventService.deleteEvent(situation);
            this.refreshAll();
        }).build()).cancel(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.suppr.confirm.nok", (Object[])new Object[0])).build()).build().open();
    }

    public void onDelete(Collection<Situation> situations) {
        ConfirmDialog.builder().title(CommonEventActionListener.getTranslation((String)"mct.suppr.confirm.title", (Object[])new Object[0])).text(CommonEventActionListener.getTranslation((String)"mct.suppr.confirm.message", (Object[])new Object[0])).confirm(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.confirm.ok", (Object[])new Object[0])).listener((ComponentEventListener & Serializable)event -> {
            this.eventService.deleteEvents(situations);
            this.refreshAll();
        }).build()).cancel(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.confirm.nok", (Object[])new Object[0])).build()).build().open();
    }

    public void onPublish(Situation situation) {
        this.onPublish(situation.getEvenementPrincipal(), false);
    }

    public void onPublish(Evenement event, boolean auto) {
        EventPublishDialog window = new EventPublishDialog(this.eventPublishDialogService, event);
        boolean erreur = window.estErreur();
        if (auto) {
            if (erreur || this.configurationService.estModePublicationAutomatiqueAffichageToujours()) {
                window.open();
            } else {
                window.publish();
            }
        } else {
            window.open();
        }
    }

    public void onUnpublish(Situation situation) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void onAssociate(Situation situation) {
        EventAssociationDialog associationDialog = new EventAssociationDialog(this.eventAssociationDialogService, situation.getEvenementPrincipal());
        associationDialog.addOpenedChangeListener((ComponentEventListener & Serializable)event -> {
            if (!event.isOpened()) {
                this.refreshAll();
            }
        });
        associationDialog.open();
    }

    public void onProgram(Situation situation) {
        Evenement event = situation.getEvenementPrincipal();
        this.eventService.prepareEventProgramming(event);
        if (this.configurationService.isFastProgramModeEnabled()) {
            this.eventService.fastProgramEvent(event);
            this.refreshAll();
        } else {
            EventSheetDialog eventSheetDialog = this.eventSheetDialogFactory.createDefaultEventSheet(situation, false);
            eventSheetDialog.setSaveButtonText(CommonEventActionListener.getTranslation((String)(this.configurationService.isProgrammationTravauxActive() && MetierCommun.estPatrouillage((Evenement)event, (List)this.businessService.getNaturesList()) ? "mct.action.creer_travaux" : "mct.action.programme"), (Object[])new Object[0]));
            eventSheetDialog.setSaveButtonIcon(null);
            eventSheetDialog.addEventSaveListener((ComponentEventListener & Serializable)eventSaveEvent -> this.eventService.editAndProgramEvent(eventSaveEvent.getEvent(), eventSaveEvent.getPhotoList()));
            eventSheetDialog.addOpenedChangeListener((ComponentEventListener & Serializable)openedChangeEvent -> {
                if (!openedChangeEvent.isOpened()) {
                    this.refreshAll();
                }
            });
            eventSheetDialog.open();
        }
    }

    public void onProgram(Collection<Situation> situations) {
        ConfirmDialog.builder().title(CommonEventActionListener.getTranslation((String)"mct.program.confirm.title", (Object[])new Object[0])).text(CommonEventActionListener.getTranslation((String)"mct.program.confirm.message", (Object[])new Object[0])).confirm(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.confirm.ok", (Object[])new Object[0])).listener((ComponentEventListener & Serializable)event -> {
            this.eventService.programEvents(situations);
            this.refreshAll();
        }).build()).cancel(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.confirm.nok", (Object[])new Object[0])).build()).build().open();
    }

    public void onDeprogram(Situation situation) {
        this.eventService.deprogramEvent(situation.getEvenementPrincipal());
        this.refreshAll();
    }

    public void onDeprogram(Collection<Situation> situations) {
        ConfirmDialog.builder().title(CommonEventActionListener.getTranslation((String)"mct.deprogram.confirm.title", (Object[])new Object[0])).text(CommonEventActionListener.getTranslation((String)"mct.deprogram.confirm.message", (Object[])new Object[0])).confirm(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.confirm.ok", (Object[])new Object[0])).listener((ComponentEventListener & Serializable)event -> {
            this.eventService.deprogramEvents(situations);
            this.refreshAll();
        }).build()).cancel(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.confirm.nok", (Object[])new Object[0])).build()).build().open();
    }

    public void onCall(Situation situation) {
        new AddActionDialog(this.service, situation.getEvenementPrincipal()).open();
    }

    public void onMainCourante(Situation situation) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void onAxioneExport(Situation situation) {
        ConfirmDialog.builder().title(CommonEventActionListener.getTranslation((String)"mct.axione.confirm.title", (Object[])new Object[0])).text(CommonEventActionListener.getTranslation((String)"mct.axione.confirm.message", (Object[])new Object[0])).confirm(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.axione.confirm.ok", (Object[])new Object[0])).listener((ComponentEventListener & Serializable)event -> {
            if (this.eventService.exportAxione(situation.getEvenementPrincipal())) {
                Notification.show((String)CommonEventActionListener.getTranslation((String)"mct.export.axione.ok", (Object[])new Object[0])).addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
            } else {
                Notification.show((String)CommonEventActionListener.getTranslation((String)"mct.export.axione.erreur", (Object[])new Object[0])).addThemeVariants((ThemeVariant[])new NotificationVariant[]{NotificationVariant.LUMO_ERROR});
            }
            this.refreshAll();
        }).build()).cancel(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.axione.confirm.nok", (Object[])new Object[0])).build()).build().open();
    }

    public void onVisaIntervention(Situation situation) {
        ConfirmDialog.builder().title(CommonEventActionListener.getTranslation((String)"mct.intervention.visa.confirm.title", (Object[])new Object[0])).text(CommonEventActionListener.getTranslation((String)"mct.intervention.visa.confirm.message", (Object[])new Object[0])).confirm(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.intervention.visa.confirm.ok", (Object[])new Object[0])).listener((ComponentEventListener & Serializable)e -> {
            if (this.eventService.visaIntervention(situation.getEvenementPrincipal())) {
                Notification.show((String)UI.getCurrent().getTranslation("mct.intervention.visa.ok", new Object[0]));
            }
            this.refreshItem((Object)situation);
        }).build()).cancel(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.intervention.visa.confirm.nok", (Object[])new Object[0])).build()).build().open();
    }

    public void onVisaInterventionCancel(Situation situation) {
        ConfirmDialog.builder().title(CommonEventActionListener.getTranslation((String)"mct.intervention.cancelvisa.confirm.title", (Object[])new Object[0])).text(CommonEventActionListener.getTranslation((String)"mct.intervention.cancelvisa.confirm.message", (Object[])new Object[0])).confirm(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.intervention.cancelvisa.confirm.ok", (Object[])new Object[0])).listener((ComponentEventListener & Serializable)e -> {
            if (this.eventService.cancelVisaIntervention(situation.getEvenementPrincipal())) {
                Notification.show((String)UI.getCurrent().getTranslation("mct.intervention.visa.ok", new Object[0]));
            }
            this.refreshItem((Object)situation);
        }).build()).cancel(ButtonConfig.builder().text(CommonEventActionListener.getTranslation((String)"mct.intervention.cancelvisa.confirm.nok", (Object[])new Object[0])).build()).build().open();
    }

    private static String getTranslation(String key, Object ... params) {
        return UI.getCurrent().getTranslation(key, params);
    }

    @Generated
    public CommonEventActionListener(EventService eventService, UserPermissionService userPermissionService, IBusinessService businessService, AddActionDialogService service, ConfigurationService configurationService, EventSheetDialogFactory eventSheetDialogFactory, EventAssociationDialogService eventAssociationDialogService, EventPublishDialogService eventPublishDialogService) {
        this.eventService = eventService;
        this.userPermissionService = userPermissionService;
        this.businessService = businessService;
        this.service = service;
        this.configurationService = configurationService;
        this.eventSheetDialogFactory = eventSheetDialogFactory;
        this.eventAssociationDialogService = eventAssociationDialogService;
        this.eventPublishDialogService = eventPublishDialogService;
    }
}

