/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.list;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.TypeUtilisateur;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.service.BusinessModuleService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.service.util.AuthenticatedUserUtils;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilter;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilterFormService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventDetailsGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventListItemGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventMctListService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventRetrieverService;
import com.neogls.prism.central.vaadin.view.mct.common.event.list.EventSelectionActionGeneratorService;
import com.neogls.prism.central.vaadin.view.mct.common.list.AbstractMctListService;
import com.neogls.prism.central.vaadin.view.mct.common.list.ActionListener;
import com.neogls.prism.central.vaadin.view.mct.common.list.MctList;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasEnabled;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public abstract class AbstractEventMctListService<L extends ActionListener<Situation>>
extends AbstractMctListService<Situation, EventFilter, L>
implements EventMctListService<L> {
    private final IBusinessService businessService;
    private final ConfigurationService configurationService;
    private final EventRetrieverService eventRetrieverService;
    private final EventListItemGeneratorService eventListItemGeneratorService;
    private final EventDetailsGeneratorService<L> eventDetailsGeneratorService;
    private final EventSelectionActionGeneratorService<L> eventSelectionActionGeneratorService;
    private final EventFilterFormService eventFilterFormService;

    protected AbstractEventMctListService(IBusinessService businessService, UserPermissionService userPermissionService, BusinessModuleService businessModuleService, ConfigurationService configurationService, EventRetrieverService eventRetrieverService, EventListItemGeneratorService eventListItemGeneratorService, EventDetailsGeneratorService<L> eventDetailsGeneratorService, EventSelectionActionGeneratorService<L> eventSelectionActionGeneratorService, EventFilterFormService eventFilterFormService) {
        super(businessService, userPermissionService, businessModuleService);
        this.businessService = businessService;
        this.configurationService = configurationService;
        this.eventRetrieverService = eventRetrieverService;
        this.eventListItemGeneratorService = eventListItemGeneratorService;
        this.eventDetailsGeneratorService = eventDetailsGeneratorService;
        this.eventSelectionActionGeneratorService = eventSelectionActionGeneratorService;
        this.eventFilterFormService = eventFilterFormService;
    }

    public List<EventFilter> getFilters() {
        AuthenticatedUser currentUser = this.getCurrentUser();
        String delegation = AuthenticatedUserUtils.getDeletationString((AuthenticatedUser)currentUser);
        String center = AuthenticatedUserUtils.getCenterString((AuthenticatedUser)currentUser);
        List mmCodes = this.getBusinessModuleCodes();
        ArrayList<EventFilter> filters = new ArrayList<EventFilter>();
        filters.add(this.getEmptyCustomFilter());
        EventFilter fEncours = EventFilter.builder().unlocalizedName("mct.filtre.evenements.encours").delegationAndCenter(this.getCurrentUserDelegationAndCenter()).mmCodes(mmCodes).sqlFilter(this.getEmptyFilter()).build();
        filters.add(fEncours);
        EventFilter fJournee = EventFilter.builder().unlocalizedName("mct.filtre.evenements.journee").delegationAndCenter(this.getCurrentUserDelegationAndCenter()).mmCodes(mmCodes).sqlFilter(IBusinessService.EvenementFiltre.deLaJournee((String)delegation, (String)center)).build();
        filters.add(fJournee);
        EventFilter fVeille = EventFilter.builder().unlocalizedName("mct.filtre.evenements.veille").delegationAndCenter(this.getCurrentUserDelegationAndCenter()).mmCodes(mmCodes).sqlFilter(IBusinessService.EvenementFiltre.deLaVeille((String)delegation, (String)center)).build();
        filters.add(fVeille);
        EventFilter fSemaine = EventFilter.builder().unlocalizedName("mct.filtre.evenements.semaine").delegationAndCenter(this.getCurrentUserDelegationAndCenter()).mmCodes(mmCodes).sqlFilter(IBusinessService.EvenementFiltre.deLaSemaineEcoulee((String)delegation, (String)center)).build();
        filters.add(fSemaine);
        if (this.configurationService.getProgrammation()) {
            EventFilter fProg = EventFilter.builder().unlocalizedName("mct.filtre.evenements.prog").delegationAndCenter(this.getCurrentUserDelegationAndCenter()).mmCodes(mmCodes).sqlFilter(IBusinessService.EvenementFiltre.programmes((String)delegation, (String)center)).build();
            filters.add(fProg);
            EventFilter fnonProg = EventFilter.builder().unlocalizedName("mct.filtre.evenements.nonprog").delegationAndCenter(this.getCurrentUserDelegationAndCenter()).mmCodes(mmCodes).sqlFilter(IBusinessService.EvenementFiltre.nonProgrammes((String)delegation, (String)center)).build();
            filters.add(fnonProg);
        }
        if (this.configurationService.getPrevisionnel()) {
            EventFilter fPrev = EventFilter.builder().unlocalizedName("mct.filtre.evenements.prev").delegationAndCenter(this.getCurrentUserDelegationAndCenter()).sqlFilter(this.getEmptyFilter()).build();
            fPrev.getSqlFilter().previsionnels = 1;
            filters.add(fPrev);
        }
        if (this.configurationService.getPublication()) {
            EventFilter fPublie = EventFilter.builder().unlocalizedName("mct.filtre.evenements.publie").delegationAndCenter(this.getCurrentUserDelegationAndCenter()).sqlFilter(this.getEmptyFilter()).build();
            fPublie.getSqlFilter().publies = 1;
            filters.add(fPublie);
        }
        if (this.configurationService.isEtatEvenementTraiteActive()) {
            EventFilter fTraites = EventFilter.builder().unlocalizedName("mct.filtre.evenements.traite").delegationAndCenter(this.getCurrentUserDelegationAndCenter()).sqlFilter(IBusinessService.EvenementFiltre.traitesNonTermines()).build();
            filters.add(fTraites);
            EventFilter fNonTraites = EventFilter.builder().unlocalizedName("mct.filtre.evenements.nontraite").delegationAndCenter(this.getCurrentUserDelegationAndCenter()).sqlFilter(IBusinessService.EvenementFiltre.nonTraitesNonTermines()).build();
            filters.add(fNonTraites);
        }
        EventFilter fIntervention = EventFilter.builder().unlocalizedName("mct.filtre.evenements.intervention").mmCodes(mmCodes).delegationAndCenter(this.getCurrentUserDelegationAndCenter()).sqlFilter(IBusinessService.EvenementFiltre.ddp((String)delegation, (String)center)).build();
        filters.add(fIntervention);
        if (this.configurationService.getFiltreEvenementParType()) {
            for (TypeUtilisateur userType : this.businessService.getTypesUtilisateur()) {
                if (MetierCommun.estTypeDefautPrism((TypeUtilisateur)userType)) continue;
                EventFilter filtreAutoType = EventFilter.builder().unlocalizedName("mct.filtre.evenements." + userType.getLibelle().toLowerCase()).mmCodes(mmCodes).delegationAndCenter(this.getCurrentUserDelegationAndCenter()).sqlFilter(this.getEmptyFilter()).build();
                filtreAutoType.getSqlFilter().type = userType.getCode();
                filters.add(filtreAutoType);
            }
        }
        return filters;
    }

    public EventFilter getDefaultFilter() {
        return EventFilter.builder().unlocalizedName("mct.filtre.evenements.encours").mmCodes(this.getBusinessModuleCodes()).delegationAndCenter(this.getCurrentUserDelegationAndCenter()).sqlFilter(this.getEmptyFilter()).build();
    }

    public List<Situation> getItems(EventFilter filter) {
        return this.eventRetrieverService.getEvents(filter);
    }

    public Component createListItem(Situation item) {
        return this.eventListItemGeneratorService.createEventListItem(item);
    }

    public Component createDetails(Situation item, L actionListener) {
        return this.eventDetailsGeneratorService.createEventDetails(item, actionListener);
    }

    public HasEnabled createSelectionActionComponent(L actionListener, MctList<?, Situation, ?, ?> mctList) {
        return this.eventSelectionActionGeneratorService.createSelectionActionComponent((EventMctListService)this, actionListener, mctList);
    }

    protected IBusinessService.EvenementFiltre getEmptyFilter() {
        AuthenticatedUser user = this.getCurrentUser();
        return IBusinessService.EvenementFiltre.moduleMetier((String)AuthenticatedUserUtils.getDeletationString((AuthenticatedUser)user), (String)AuthenticatedUserUtils.getCenterString((AuthenticatedUser)user), (List)this.getBusinessModuleCodes());
    }

    protected EventFilter getEmptyCustomFilter() {
        return EventFilter.builder().unlocalizedName("mct.filtre.evenements.perso").delegationAndCenter(this.getCurrentUserDelegationAndCenter()).sqlFilter(this.getEmptyFilter()).isCustom(true).build();
    }

    @Generated
    public EventFilterFormService getEventFilterFormService() {
        return this.eventFilterFormService;
    }
}

