/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.filter.field;

import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampVraiFaux;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreCollectionChoixUnique;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJava;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.AbstractEventFilterField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.List;

public class ChampVraiFauxEventFilterField
extends AbstractEventFilterField<ChampVraiFaux> {
    private final Checkbox checkbox = new Checkbox();
    private final RadioButtonGroup<String> rbg = new RadioButtonGroup();
    @Nullable
    private final Nature nature;

    public ChampVraiFauxEventFilterField(ChampVraiFaux field, @Nullable Nature nature) {
        super((Champ)field);
        this.nature = nature;
        this.add(new Component[]{this.configureCheckBox(), this.configureRadioButtonGroup()});
        this.addClassName("champ-vrai-faux");
    }

    private Component configureCheckBox() {
        this.checkbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.rbg.setEnabled(((Boolean)event.getValue()).booleanValue()));
        return this.checkbox;
    }

    private Component configureRadioButtonGroup() {
        this.rbg.setItems(List.of("Oui", "Non"));
        this.rbg.setEnabled(false);
        return this.rbg;
    }

    protected boolean isFilterAcceptable(FiltreJava javaFilter) {
        return javaFilter instanceof FiltreCollectionChoixUnique;
    }

    protected FiltreJava generateModelValue() {
        if (!((Boolean)this.checkbox.getValue()).booleanValue() || this.rbg.isEmpty()) {
            return (FiltreJava)this.getEmptyValue();
        }
        return new FiltreCollectionChoixUnique(this.nature, this.getField(), List.of((String)this.rbg.getValue()));
    }

    protected void setPresentationValue(FiltreJava newPresentationValue) {
        if (newPresentationValue == null) {
            this.checkbox.setValue((Object)false);
            this.rbg.clear();
            return;
        }
        FiltreCollectionChoixUnique filter = (FiltreCollectionChoixUnique)newPresentationValue;
        List filterValue = (List)filter.getValeur();
        if (filterValue.isEmpty()) {
            this.checkbox.setValue((Object)false);
            this.rbg.clear();
        } else {
            this.checkbox.setValue((Object)true);
            this.rbg.setValue((Object)((String)filterValue.get(0)));
        }
    }
}

