/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.filter.field;

import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampTexte;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreChampTexte;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJava;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.AbstractEventFilterField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.textfield.TextField;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.List;

public class ChampTexteEventFilterField
extends AbstractEventFilterField<ChampTexte> {
    private final TextField textField = new TextField();
    @Nullable
    private final Nature nature;

    public ChampTexteEventFilterField(ChampTexte field, @Nullable Nature nature) {
        super((Champ)field);
        this.nature = nature;
        this.textField.setClearButtonVisible(true);
        this.textField.getStyle().setFlexGrow("1");
        this.add(new Component[]{this.textField});
    }

    protected boolean isFilterAcceptable(FiltreJava javaFilter) {
        return javaFilter instanceof FiltreChampTexte;
    }

    protected FiltreJava generateModelValue() {
        if (this.textField.isEmpty()) {
            return (FiltreJava)this.getEmptyValue();
        }
        return new FiltreChampTexte(this.nature, this.getField(), Arrays.asList(this.textField.getValue().split(",")));
    }

    protected void setPresentationValue(FiltreJava newPresentationValue) {
        if (newPresentationValue == null) {
            this.textField.clear();
            return;
        }
        FiltreChampTexte filter = (FiltreChampTexte)newPresentationValue;
        List filterValue = (List)filter.getValeur();
        this.textField.setValue(String.join((CharSequence)",", filterValue));
    }
}

