/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.filter.field;

import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiple;
import com.geolocsystems.prismandroid.model.evenements.champs.IComposantFactory;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJava;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.AbstractEventFilterField;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.CompositeJavaFilter;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.IVaadinEventFilterFieldFactory;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ChampMultipleEventFilterField
extends AbstractEventFilterField<ChampMultiple> {
    private final Map<String, AbstractEventFilterField<?>> subFieldComponents;
    @Nullable
    private final Nature nature;

    public ChampMultipleEventFilterField(ChampMultiple field, @Nullable Nature nature, IVaadinEventFilterFieldFactory factory) {
        super((Champ)field);
        this.nature = nature;
        this.subFieldComponents = this.createSubFieldComponents(factory);
        this.add((Component[])this.subFieldComponents.values().toArray(Component[]::new));
        this.addClassName("champ-multiple");
    }

    private Map<String, AbstractEventFilterField<?>> createSubFieldComponents(IVaadinEventFilterFieldFactory factory) {
        LinkedHashMap<String, AbstractEventFilterField> ret = new LinkedHashMap<String, AbstractEventFilterField>();
        for (Champ subField : ((ChampMultiple)this.getField()).getChamps()) {
            AbstractEventFilterField subComponent = (AbstractEventFilterField)subField.getView((IComposantFactory)factory);
            if (subComponent == null) continue;
            ret.put(subField.getNom(), subComponent);
        }
        return Collections.unmodifiableMap(ret);
    }

    protected boolean isFilterAcceptable(FiltreJava javaFilter) {
        return javaFilter instanceof CompositeJavaFilter;
    }

    protected FiltreJava generateModelValue() {
        if (this.subFieldComponents.values().stream().allMatch(AbstractField::isEmpty)) {
            return (FiltreJava)this.getEmptyValue();
        }
        return new CompositeJavaFilter(this.nature, this.getField(), this.subFieldComponents.values().stream().map(AbstractField::getValue).filter(Objects::nonNull).toList());
    }

    protected void setPresentationValue(FiltreJava newPresentationValue) {
        if (newPresentationValue == null) {
            this.subFieldComponents.values().forEach(HasValue::clear);
            return;
        }
        CompositeJavaFilter filter = (CompositeJavaFilter)newPresentationValue;
        for (FiltreJava subFilter : filter.getValeur()) {
            ((AbstractEventFilterField)this.subFieldComponents.get(subFilter.getChampNom())).setValue(subFilter);
        }
    }
}

