/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.filter.field;

import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampDropListe;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreCollectionChoixUnique;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJava;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.AbstractEventFilterField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ChampDropListeEventFilterField
extends AbstractEventFilterField<ChampDropListe> {
    private final MultiSelectComboBox<String> mscb = new MultiSelectComboBox();
    @Nullable
    private final Nature nature;

    public ChampDropListeEventFilterField(ChampDropListe field, @Nullable Nature nature) {
        super((Champ)field);
        this.nature = nature;
        this.mscb.setAutoExpand(MultiSelectComboBox.AutoExpandMode.VERTICAL);
        this.mscb.addClassName("flex-grow");
        this.mscb.setClearButtonVisible(true);
        this.mscb.setItems((Collection)((ChampDropListe)this.getField()).getValeurs());
        this.add(new Component[]{this.mscb});
    }

    protected boolean isFilterAcceptable(FiltreJava javaFilter) {
        return javaFilter instanceof FiltreCollectionChoixUnique;
    }

    protected FiltreJava generateModelValue() {
        if (this.mscb.isEmpty()) {
            return (FiltreJava)this.getEmptyValue();
        }
        return new FiltreCollectionChoixUnique(this.nature, this.getField(), List.copyOf(this.mscb.getValue()));
    }

    protected void setPresentationValue(FiltreJava newPresentationValue) {
        if (newPresentationValue == null) {
            this.mscb.clear();
            return;
        }
        FiltreCollectionChoixUnique filter = (FiltreCollectionChoixUnique)newPresentationValue;
        List filterValue = (List)filter.getValeur();
        if (filterValue.isEmpty()) {
            this.mscb.clear();
        } else {
            this.mscb.setValue(new HashSet(filterValue));
        }
    }
}

