/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.filter.field;

import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJava;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.AbstractEventFilterField;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.checkbox.CheckboxGroup;
import com.vaadin.flow.component.checkbox.CheckboxGroupVariant;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.shared.ThemeVariant;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;

public abstract class AbstractMultiSelectEventFilterField<T extends Champ>
extends AbstractEventFilterField<T> {
    private final AbstractField<?, Set<String>> fieldComponent;
    @Nullable
    private final Nature nature;
    private final Function<T, List<String>> fieldValuesGetter;

    protected AbstractMultiSelectEventFilterField(T field, @Nullable Nature nature, Function<T, List<String>> fieldValuesGetter) {
        super(field);
        this.nature = nature;
        this.fieldValuesGetter = fieldValuesGetter;
        this.fieldComponent = fieldValuesGetter.apply(field).size() > 2 ? this.createMultiSelectComboBox() : this.createCheckBoxGroup();
        this.add(new Component[]{this.fieldComponent});
    }

    private MultiSelectComboBox<String> createMultiSelectComboBox() {
        MultiSelectComboBox mscb = new MultiSelectComboBox();
        mscb.setAutoExpand(MultiSelectComboBox.AutoExpandMode.VERTICAL);
        mscb.addClassName("flex-grow");
        mscb.setClearButtonVisible(true);
        mscb.setItems((Collection)this.fieldValuesGetter.apply(this.getField()));
        return mscb;
    }

    private CheckboxGroup<String> createCheckBoxGroup() {
        CheckboxGroup cbg = new CheckboxGroup();
        cbg.addThemeVariants((ThemeVariant[])new CheckboxGroupVariant[]{CheckboxGroupVariant.LUMO_VERTICAL});
        cbg.setItems((Collection)this.fieldValuesGetter.apply(this.getField()));
        return cbg;
    }

    protected abstract FiltreJava createJavaFilter(@Nullable Nature var1, Champ var2, List<String> var3);

    protected FiltreJava generateModelValue() {
        if (this.fieldComponent.isEmpty()) {
            return (FiltreJava)this.getEmptyValue();
        }
        return this.createJavaFilter(this.nature, this.getField(), List.copyOf((Collection)this.fieldComponent.getValue()));
    }

    protected void setPresentationValue(FiltreJava newPresentationValue) {
        if (newPresentationValue == null) {
            this.fieldComponent.clear();
            return;
        }
        List filterValue = (List)newPresentationValue.getValeur();
        if (filterValue.isEmpty()) {
            this.fieldComponent.clear();
        } else {
            this.fieldComponent.setValue(Set.copyOf(filterValue));
        }
    }
}

