/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.filter;

import com.geolocsystems.prismandroid.model.evenements.DescriptionNature;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJava;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.NatureFieldForm;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.AbstractEventFilterField;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.IVaadinEventFilterFieldFactory;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import gls.outils.ConstantesGLS;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class NatureFieldForm
extends HorizontalLayout {
    private final Table<String, String, AbstractEventFilterField<?>> natureFields = HashBasedTable.create();
    private final Map<String, MultiSelectComboBox<DescriptionNatureBean>> descriptionsFields = new HashMap();
    private final Multimap<String, DescriptionNatureBean> descriptionsByNatureCode = HashMultimap.create();
    private final Map<String, DescriptionNatureBean> descriptionByCode;
    private final Div tabContainer = new Div();
    private final Collection<Nature> selectedNatures;
    private final Collection<String> commonFieldNames;
    private final IVaadinEventFilterFieldFactory factory;

    public NatureFieldForm(Collection<Nature> selectedNatures, Map<String, List<DescriptionNature>> descriptionsNatureMap, Collection<String> commonFieldNames, IVaadinEventFilterFieldFactory factory) {
        this.selectedNatures = selectedNatures;
        this.commonFieldNames = commonFieldNames;
        this.factory = factory;
        descriptionsNatureMap.forEach((natureCode, descriptions) -> {
            for (DescriptionNature description : descriptions) {
                this.descriptionsByNatureCode.put(natureCode, (Object)new DescriptionNatureBean(natureCode, description.getCode(), description.getLibelle()));
            }
        });
        this.descriptionByCode = Maps.uniqueIndex((Iterable)this.descriptionsByNatureCode.values(), DescriptionNatureBean::getCode);
        this.tabContainer.setHeightFull();
        this.tabContainer.getStyle().set("overflow-y", "auto");
        this.tabContainer.addClassName("pr-m");
        this.add(new Component[]{this.createTabs(), this.tabContainer});
    }

    private Component createTabs() {
        Tabs tabs = new Tabs(false, new Tab[0]);
        HashMap<Tab, FlexLayout> tabComponents = new HashMap<Tab, FlexLayout>();
        for (Nature nature : this.selectedNatures) {
            Collection components = this.createComponents(nature);
            FlexLayout tabContent = new FlexLayout();
            MultiSelectComboBox mscbDescription = new MultiSelectComboBox("Descriptions");
            mscbDescription.setItemLabelGenerator(DescriptionNatureBean::getLabel);
            mscbDescription.setPlaceholder("Toutes les descriptions");
            mscbDescription.setClearButtonVisible(true);
            mscbDescription.setItems(this.descriptionsByNatureCode.get((Object)nature.getCode()));
            tabContent.add(new Component[]{mscbDescription});
            this.descriptionsFields.put(nature.getCode(), mscbDescription);
            if (!components.isEmpty()) {
                tabContent.add(Collections.unmodifiableCollection(components));
            }
            tabContent.setFlexDirection(FlexLayout.FlexDirection.COLUMN);
            tabContent.setWidth(500.0f, Unit.PIXELS);
            tabContent.setVisible(false);
            this.tabContainer.add(new Component[]{tabContent});
            Tab tab = new Tab(nature.getLabel());
            tabs.add(new Tab[]{tab});
            tabComponents.put(tab, tabContent);
            mscbDescription.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateTabDefaultValueIndicator(nature, tab, mscbDescription, components));
            components.forEach(component -> component.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.updateTabDefaultValueIndicator(nature, tab, mscbDescription, components)));
        }
        tabs.setOrientation(Tabs.Orientation.VERTICAL);
        tabs.addSelectedChangeListener((ComponentEventListener & Serializable)event -> {
            tabComponents.values().forEach(component -> component.setVisible(false));
            if (event.getSelectedTab() != null) {
                ((Component)tabComponents.get(event.getSelectedTab())).setVisible(true);
            }
        });
        tabs.setSelectedIndex(0);
        return tabs;
    }

    private void updateTabDefaultValueIndicator(Nature nature, Tab tab, MultiSelectComboBox<DescriptionNatureBean> mscbDescription, Collection<AbstractEventFilterField<?>> components) {
        tab.setLabel(nature.getLabel() + (mscbDescription.isEmpty() && components.stream().allMatch(AbstractField::isEmpty) ? "" : " *"));
    }

    private Collection<AbstractEventFilterField<?>> createComponents(Nature nature) {
        ArrayList ret = new ArrayList();
        this.factory.runWithContext(nature, () -> {
            for (Champ field : nature.getChamps()) {
                AbstractEventFilterField component;
                if (this.commonFieldNames.contains(field.getNom()) || ConstantesGLS.egal((String)field.getNom(), (String)"description") || (component = this.factory.getView(field)) == null) continue;
                ret.add(component);
                this.natureFields.put((Object)nature.getCode(), (Object)field.getNom(), (Object)component);
            }
        });
        return ret;
    }

    public void setValue(List<String> descriptions, List<FiltreJava> value) {
        this.descriptionsFields.values().forEach(HasValue::clear);
        descriptions.stream().map(this.descriptionByCode::get).collect(Collectors.groupingBy(DescriptionNatureBean::getNatureCode, HashMap::new, Collectors.toSet())).forEach((natureCode, selectedDescriptions) -> {
            if (selectedDescriptions.equals(this.descriptionsByNatureCode.get(natureCode))) {
                ((MultiSelectComboBox)this.descriptionsFields.get(natureCode)).clear();
            } else {
                ((MultiSelectComboBox)this.descriptionsFields.get(natureCode)).setValue(selectedDescriptions);
            }
        });
        for (FiltreJava javaFilter : value) {
            AbstractEventFilterField field;
            if (javaFilter == null || (field = (AbstractEventFilterField)this.natureFields.get((Object)javaFilter.getNatureNom(), (Object)javaFilter.getChampNom())) == null) continue;
            field.setValue(javaFilter);
        }
    }

    public List<String> getSelectedDescriptions() {
        return this.descriptionsFields.entrySet().stream().map(arg_0 -> this.getSelectedDescriptionsForNature(arg_0)).flatMap(Collection::stream).map(DescriptionNatureBean::getCode).toList();
    }

    private Collection<DescriptionNatureBean> getSelectedDescriptionsForNature(Map.Entry<String, MultiSelectComboBox<DescriptionNatureBean>> entry) {
        MultiSelectComboBox<DescriptionNatureBean> field = entry.getValue();
        return field.isEmpty() ? this.descriptionsByNatureCode.get((Object)entry.getKey()) : field.getValue();
    }

    public List<FiltreJava> getValue() {
        return this.natureFields.values().stream().filter(Predicate.not(AbstractField::isEmpty)).map(AbstractField::getValue).filter(Objects::nonNull).toList();
    }
}

