/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.filter;

import com.geolocsystems.prismandroid.model.evenements.DescriptionNature;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJava;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.NatureFieldDialog;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.NatureFieldForm;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.IVaadinEventFilterFieldFactory;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.shared.ThemeVariant;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class NatureFieldDialog
extends Dialog {
    private final NatureFieldForm natureFieldForm;

    public NatureFieldDialog(Collection<Nature> selectedNatures, Map<String, List<DescriptionNature>> descriptionsNatureMap, Collection<String> commonFieldNames, IVaadinEventFilterFieldFactory factory) {
        this.natureFieldForm = new NatureFieldForm(selectedNatures, descriptionsNatureMap, commonFieldNames, factory);
        this.natureFieldForm.setSizeFull();
        this.setHeaderTitle("Filtres sp\u00e9cifiques aux natures s\u00e9lectionn\u00e9es");
        this.add(new Component[]{this.natureFieldForm});
        this.configureFooter();
        this.setHeightFull();
    }

    private void configureFooter() {
        Button bValidate = new Button(this.getTranslation("generic.validate", new Object[0]), arg_0 -> this.onValidateClick(arg_0));
        bValidate.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        Button bCancel = new Button(this.getTranslation("generic.cancel", new Object[0]), arg_0 -> this.onCancelClick(arg_0));
        this.getFooter().add(new Component[]{bCancel, bValidate});
        bValidate.addClassName("ml-auto");
        this.setCloseOnEsc(false);
        this.setCloseOnOutsideClick(false);
        bCancel.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
    }

    private void onValidateClick(ClickEvent<Button> event) {
        this.fireEvent((ComponentEvent)new ValidateEvent(this, event.isFromClient(), this.natureFieldForm.getSelectedDescriptions(), this.natureFieldForm.getValue()));
        this.close();
    }

    private void onCancelClick(ClickEvent<Button> event) {
        this.close();
    }

    public void setValue(List<String> descriptions, List<FiltreJava> value) {
        this.natureFieldForm.setValue(descriptions, value);
    }

    public void addValidateEventListener(ComponentEventListener<ValidateEvent> listener) {
        this.addListener(ValidateEvent.class, listener);
    }
}

