/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.filter;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismandroid.model.evenements.DescriptionNature;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampTexte;
import com.geolocsystems.prismcentral.beans.PrismCentralUser;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.ICartoService;
import com.geolocsystems.prismcentralvaadin.util.PrismUtils;
import com.neogls.prism.central.vaadin.service.BusinessModuleService;
import com.neogls.prism.central.vaadin.service.ConfigurationService;
import com.neogls.prism.central.vaadin.service.UserPermissionService;
import com.neogls.prism.central.vaadin.service.bean.UserVaadinBean;
import com.neogls.prism.central.vaadin.service.mapper.UserVaadinBeanMapper;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import gls.outils.ConstantesGLS;
import gls.outils.GLS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class EventFilterFormService {
    private final IBusinessService businessService;
    private final ICartoService cartoService;
    private final ConfigurationService configurationService;
    private final UserPermissionService userPermissionService;
    private final BusinessModuleService businessModuleService;

    public Collection<ModuleMetier> getBusinessModulesForFiltering(List<Integer> businessModuleCodes) {
        return this.isContextFilterEnable() ? this.businessModuleService.getBusinessModulesByCode(businessModuleCodes) : this.businessModuleService.getInheritedBusinessModules(businessModuleCodes);
    }

    public boolean isContextFilterEnable() {
        return this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "mct.filtre.contexteSaisie").orElse(false);
    }

    public List<ModuleMetier> getBusinessModulesForCreationContext(List<Integer> businessModuleCodes) {
        if (businessModuleCodes.contains(-1)) {
            return this.businessModuleService.getBusinessModules();
        }
        return this.businessModuleService.getBusinessModules().stream().filter(moduleMetier -> businessModuleCodes.contains(moduleMetier.getCode()) || businessModuleCodes.contains(moduleMetier.getModuleHerite()) || businessModuleCodes.contains(0) && moduleMetier.isCreationEvenementPatrouille()).toList();
    }

    public Collection<Nature> getNaturesForBusinessModules(Collection<? extends ModuleMetier> businessModules) {
        if (businessModules.stream().anyMatch(mm -> mm.getCode() == -1)) {
            return this.businessService.getNatures().values();
        }
        return this.businessService.getNatures().values().stream().filter(nature -> this.businessModuleService.containsInheritedModule(businessModules, nature.getCodeMM())).toList();
    }

    public Collection<Champ> getCommonFields(Collection<? extends ModuleMetier> businessModules) {
        HashMap commonFields = new HashMap();
        HashMap allFields = new HashMap();
        this.getNaturesForBusinessModules(businessModules).stream().map(Nature::getChamps).flatMap(Collection::stream).filter(c -> allFields.putIfAbsent(c.getNom(), c) != null).filter(c -> !ConstantesGLS.egal((String)c.getNom(), (String)"description")).forEach(c -> commonFields.putIfAbsent(c.getNom(), c));
        return commonFields.values();
    }

    public Collection<Circuit> getCircuits() {
        return this.businessService.getListeCircuits();
    }

    public Collection<String> getAxes() {
        return Objects.requireNonNullElse(this.cartoService.getListeAxe(), List.of());
    }

    public Map<String, Nature> getNatureAAfficher(IBusinessService.EvenementFiltre filtreBase) {
        Map naturesAAfficher = PrismUtils.getNaturesAAfficher((List)filtreBase.codeModuleMetier);
        if (naturesAAfficher == null || naturesAAfficher.isEmpty()) {
            naturesAAfficher = this.businessService.getNatures();
        }
        return PrismUtils.getNaturesAAfficherProfil((Map)naturesAAfficher);
    }

    private String getNomOperation(Evenement e) {
        ValeurChampTexte champOperation;
        try {
            champOperation = (ValeurChampTexte)MetierCommun.getValeurChamp((Evenement)e, (String)"nomOperation");
        }
        catch (Exception ex) {
            champOperation = null;
        }
        if (champOperation != null && !MetierCommun.estVide((String)champOperation.getValeur())) {
            return champOperation.getValeur();
        }
        return null;
    }

    public Collection<String> getOperations() {
        IBusinessService.EvenementFiltre filtreBase = IBusinessService.EvenementFiltre.moduleMetier(null, null, (int)8);
        filtreBase.evenementAssocies = true;
        ArrayList filtresJava = new ArrayList();
        List situations = this.businessService.getEvenements(filtreBase, filtresJava);
        ArrayList<Situation> situationsFiltrees = new ArrayList<Situation>();
        Map natureAAfficher = this.getNatureAAfficher(filtreBase);
        HashMap<Integer, String> evtDejaTraite = new HashMap<Integer, String>();
        ArrayList<String> listeOperations = new ArrayList<String>();
        for (Situation s : situations) {
            for (Evenement e : MetierCommun.getEvenements((Situation)s, (Map)natureAAfficher, (List)filtreBase.codeModuleMetier)) {
                String nomOperation = this.getNomOperation(e);
                if (evtDejaTraite.get(e.getkEventid()) != null) continue;
                Situation sit = new Situation(s.getSid(), s.getEvenements());
                sit.setEvenementPrincipal(e);
                situationsFiltrees.add(sit);
                if (!GLS.estVide((String)nomOperation) && !listeOperations.contains(nomOperation)) {
                    listeOperations.add(nomOperation);
                }
                evtDejaTraite.put(e.getkEventid(), e.getCodeEvenement());
            }
        }
        return Objects.requireNonNullElse(listeOperations, List.of());
    }

    public Collection<String> getPrListForAxe(String axe) {
        return Objects.requireNonNullElse(this.cartoService.getListePR(axe), List.of());
    }

    public boolean isEventCategoriesEnable() {
        return this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "mct.filtre.contexteSaisie").orElse(false);
    }

    public boolean isEventCodeFilterEnable() {
        return this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "genereCodeClair").orElse(false) != false && this.configurationService.getBoolean(ConfigurationService.ConfigurationType.DATABASE, "evenement.code.filtre").orElse(true) != false;
    }

    public Collection<String> getEventCategories(Collection<? extends ModuleMetier> businessModules) {
        return businessModules.stream().map(ModuleMetier::getCode).map(this.businessService.getListeCategoriesNatureMm()::get).filter(Objects::nonNull).flatMap(Collection::stream).distinct().toList();
    }

    public Collection<UserVaadinBean> getAgents() {
        return this.businessService.rechercheToutUtilisateur().stream().filter(Predicate.not(PrismCentralUser::isSysteme)).map(arg_0 -> ((UserVaadinBeanMapper)UserVaadinBeanMapper.INSTANCE).mapToVaadinBean(arg_0)).toList();
    }

    public Collection<Delegation> getActiveDelegationsAndCenters() {
        return this.businessService.getDelegationsActives();
    }

    public boolean doitVerrouillerDelegation(int codeMM) {
        return this.businessModuleService.isAutoLockDelegationAndCenter(codeMM) && this.userPermissionService.doitVerrouillerDelegation(codeMM);
    }

    public boolean doitVerrouillerCentre(int codeMM) {
        return this.businessModuleService.isAutoLockDelegationAndCenter(codeMM) && this.userPermissionService.doitVerrouillerCentre(codeMM);
    }

    public AuthenticatedUser getCurrentUser() {
        return this.userPermissionService.getCurrentUser();
    }

    public Map<String, List<DescriptionNature>> getDescriptionsNatureMap() {
        return this.businessService.getDescriptionsNatureMap();
    }

    @Generated
    public EventFilterFormService(IBusinessService businessService, ICartoService cartoService, ConfigurationService configurationService, UserPermissionService userPermissionService, BusinessModuleService businessModuleService) {
        this.businessService = businessService;
        this.cartoService = cartoService;
        this.configurationService = configurationService;
        this.userPermissionService = userPermissionService;
        this.businessModuleService = businessModuleService;
    }
}

