/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.filter;

import com.geolocsystems.deepcopyutil.DeepCopy;
import com.geolocsystems.prismandroid.model.Centre;
import com.geolocsystems.prismandroid.model.Circuit;
import com.geolocsystems.prismandroid.model.Delegation;
import com.geolocsystems.prismandroid.model.ModuleMetier;
import com.geolocsystems.prismandroid.model.evenements.Nature;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampMultiple;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.geolocsystems.prismcentral.data.filtrejava.FiltreJava;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.neogls.prism.central.vaadin.common.component.datetimeinterval.DateTimeRange;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenter;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenterField;
import com.neogls.prism.central.vaadin.common.component.delegationandcenterfield.DelegationAndCenterFieldThemeVariant;
import com.neogls.prism.central.vaadin.common.component.optional.field.OptionalDateTimeRangePicker;
import com.neogls.prism.central.vaadin.service.bean.UserVaadinBean;
import com.neogls.prism.central.vaadin.service.security.AuthenticatedUser;
import com.neogls.prism.central.vaadin.service.util.ListUtils;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilter;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilterEditForm;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilterFormService;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.NatureFieldDialog;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.AbstractEventFilterField;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.IVaadinEventFilterFieldFactory;
import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.accordion.Accordion;
import com.vaadin.flow.component.accordion.AccordionPanel;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.CheckboxGroup;
import com.vaadin.flow.component.checkbox.CheckboxGroupVariant;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.details.DetailsVariant;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.ValidationResult;
import com.vaadin.flow.function.SerializablePredicate;
import gls.outils.ConstantesGLS;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public class EventFilterEditForm
extends HorizontalLayout {
    private final CheckboxGroup<ModuleMetier> cbgBusinessModule = new CheckboxGroup(this.getTranslation("report.evenement.module.metier", new Object[0]));
    private final MultiSelectComboBox<ModuleMetier> mscbCreationContext = new MultiSelectComboBox(this.getTranslation("report.evenement.contexteCreation", new Object[0]));
    private final MultiSelectComboBox<Nature> mscbNature = new MultiSelectComboBox(this.getTranslation("report.evenement.nature", new Object[0]));
    private final Button bNatureFilter = new Button("Filtres sp\u00e9cifiques aux natures");
    private final OptionalDateTimeRangePicker odtrpDateMinMax = new OptionalDateTimeRangePicker(this.getTranslation("report.evenement.dates", new Object[0]));
    private final ComboBox<EventState> cbEventState = new ComboBox(this.getTranslation("report.evenement.termine", new Object[0]));
    private final DelegationAndCenterField delegationAndCenterField;
    private final ComboBox<Circuit> cbCircuit = new ComboBox(this.getTranslation("report.evenement.circuit", new Object[0]));
    private final ComboBox<String> cbAxe = new ComboBox(this.getTranslation("report.evenement.axe", new Object[0]));
    private final ComboBox<String> cbPrDebut = new ComboBox(this.getTranslation("report.evenement.pr.du", new Object[0]));
    private final ComboBox<String> cbPrFin = new ComboBox(this.getTranslation("report.evenement.pr.au", new Object[0]));
    private final MultiSelectComboBox<String> mscbEventCategory = new MultiSelectComboBox(this.getTranslation("report.evenement.categorieNature.titre", new Object[0]));
    private final MultiSelectComboBox<UserVaadinBean> mscbAgent = new MultiSelectComboBox(this.getTranslation("report.evenement.agents.titre", new Object[0]));
    private final RadioButtonGroup<AggregationValue> rbgAggregation = new RadioButtonGroup(this.getTranslation("stats.statistiques.agregation", new Object[0]));
    private final TextField tfEventCode = new TextField(this.getTranslation("report.evenement.code.titre", new Object[0]));
    private final VerticalLayout dynamicComponentsContainer = new VerticalLayout();
    private final Map<String, AbstractEventFilterField<?>> commonFields = new HashMap();
    private final EventFilter oldValue;
    private final EventFilterFormService service;
    private final IVaadinEventFilterFieldFactory factory;
    private final boolean aggregationEnabled;
    private final Integer primaryBusinessModuleCode;
    private final Map<Integer, ModuleMetier> businessModules;
    private final Map<Integer, ModuleMetier> contextCreationBusinessModules;
    private final Map<String, Circuit> circuitsById;
    private List<String> descriptions = List.of();
    private List<FiltreJava> natureFilters = List.of();

    public EventFilterEditForm(EventFilter oldValue, List<Integer> businessModuleCodes, EventFilterFormService service, IVaadinEventFilterFieldFactory factory) {
        this(oldValue, businessModuleCodes, service, factory, false);
    }

    public EventFilterEditForm(EventFilter oldValue, List<Integer> businessModuleCodes, EventFilterFormService service, IVaadinEventFilterFieldFactory factory, boolean aggregationEnabled) {
        this.oldValue = oldValue;
        this.service = service;
        this.factory = factory;
        this.aggregationEnabled = aggregationEnabled;
        this.primaryBusinessModuleCode = businessModuleCodes.isEmpty() ? null : businessModuleCodes.get(0);
        this.businessModules = Maps.uniqueIndex((Iterable)service.getBusinessModulesForFiltering(businessModuleCodes), ModuleMetier::getCode);
        this.contextCreationBusinessModules = Maps.uniqueIndex((Iterable)service.getBusinessModulesForCreationContext(businessModuleCodes), ModuleMetier::getCode);
        this.circuitsById = Maps.uniqueIndex((Iterable)service.getCircuits(), Circuit::getId);
        this.delegationAndCenterField = new DelegationAndCenterField(service.getActiveDelegationsAndCenters());
        VerticalLayout commonComponents = new VerticalLayout(new Component[]{this.configureBusinessModulesField(), this.configureContextField(), this.configureNatureField(), this.configureNatureFilterButton(), this.configureDateField(), this.configureEventStateField()});
        commonComponents.add(this.configureLocalisationComponents());
        commonComponents.add(new Component[]{this.configureEventCategoriesField(), this.configureAgentField(), this.configureAggregation(), this.configureCodeFilter()});
        this.configureDelegationAndCenterRestrictions();
        commonComponents.setPadding(false);
        commonComponents.setSpacing(false);
        commonComponents.setAlignItems(FlexComponent.Alignment.STRETCH);
        this.dynamicComponentsContainer.setPadding(false);
        this.dynamicComponentsContainer.setSpacing(false);
        commonComponents.setWidth(500.0f, Unit.PIXELS);
        this.dynamicComponentsContainer.setWidth(500.0f, Unit.PIXELS);
        this.add(new Component[]{new Scroller((Component)commonComponents, Scroller.ScrollDirection.VERTICAL), this.dynamicComponentsContainer});
        this.setPadding(false);
        this.setSpacing(false);
        this.setAlignItems(FlexComponent.Alignment.STRETCH);
        this.addClassName("gap-s");
        this.readValue(oldValue);
    }

    private Component configureBusinessModulesField() {
        this.cbgBusinessModule.setItemLabelGenerator(ModuleMetier::getLibelle);
        this.cbgBusinessModule.addThemeVariants((ThemeVariant[])new CheckboxGroupVariant[]{CheckboxGroupVariant.LUMO_VERTICAL});
        this.cbgBusinessModule.setItems(this.businessModules.values());
        this.cbgBusinessModule.setVisible(this.businessModules.size() > 1);
        this.cbgBusinessModule.addValueChangeListener(arg_0 -> this.onBusinessModuleValueChange(arg_0));
        return this.cbgBusinessModule;
    }

    private Component configureContextField() {
        this.mscbCreationContext.setItemLabelGenerator(ModuleMetier::getLibelle);
        this.mscbCreationContext.setItems(this.contextCreationBusinessModules.values());
        this.mscbCreationContext.setAutoExpand(MultiSelectComboBox.AutoExpandMode.VERTICAL);
        this.mscbCreationContext.setClearButtonVisible(true);
        this.mscbCreationContext.setVisible(this.service.isContextFilterEnable() && this.contextCreationBusinessModules.size() > 1);
        return this.mscbCreationContext;
    }

    private Component configureNatureField() {
        this.mscbNature.setItemLabelGenerator(Nature::getLabel);
        this.mscbNature.setAutoExpand(MultiSelectComboBox.AutoExpandMode.VERTICAL);
        this.mscbNature.setPlaceholder(this.getTranslation("report.evenement.nature.toutes", new Object[0]));
        this.mscbNature.setClearButtonVisible(true);
        return this.mscbNature;
    }

    private Component configureNatureFilterButton() {
        this.bNatureFilter.setEnabled(false);
        this.bNatureFilter.addClickListener(arg_0 -> this.onNatureFilterClick(arg_0));
        this.mscbNature.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> this.bNatureFilter.setEnabled(!event.getHasValue().isEmpty()));
        return this.bNatureFilter;
    }

    private Component configureDateField() {
        this.odtrpDateMinMax.setCheckboxLabel(this.getTranslation("report.evenement.date", new Object[0]));
        this.odtrpDateMinMax.setLabel(this.getTranslation("report.evenement.date.debut", new Object[0]), this.getTranslation("report.evenement.date.fin", new Object[0]));
        this.odtrpDateMinMax.setStep(Duration.ofMinutes(1L));
        return this.odtrpDateMinMax;
    }

    private Component configureEventStateField() {
        this.cbEventState.setItemLabelGenerator((ItemLabelGenerator & Serializable)item -> this.getTranslation(item.getI18nLabel(), new Object[0]));
        this.cbEventState.setItems((Object[])EventState.values());
        return this.cbEventState;
    }

    private Component[] configureLocalisationComponents() {
        this.delegationAndCenterField.addThemeVariants((ThemeVariant[])new DelegationAndCenterFieldThemeVariant[]{DelegationAndCenterFieldThemeVariant.HORIZONTAL});
        this.delegationAndCenterField.setDelegationPlaceholder(this.getTranslation("report.evenement.delegation.toutes", new Object[0]));
        this.delegationAndCenterField.setCenterPlaceholder(this.getTranslation("report.evenement.centre.tous", new Object[0]));
        this.cbCircuit.setItemLabelGenerator(arg_0 -> this.circuitToStringWithCenter(arg_0));
        this.cbCircuit.setPlaceholder(this.getTranslation("report.evenement.circuit.tous", new Object[0]));
        this.cbCircuit.setClearButtonVisible(true);
        this.cbCircuit.setItems(this.circuitsById.values());
        this.delegationAndCenterField.addValueChangeListener(arg_0 -> this.onDelegationAndCenterValueChange(arg_0));
        this.cbAxe.setClearButtonVisible(true);
        this.cbAxe.addValueChangeListener(arg_0 -> this.onAxeValueChange(arg_0));
        this.cbAxe.setItems(this.service.getAxes());
        this.cbPrDebut.setClearButtonVisible(true);
        this.cbPrDebut.addValueChangeListener(arg_0 -> this.onPrDebutValueChange(arg_0));
        this.cbPrDebut.setEnabled(false);
        this.cbPrFin.setClearButtonVisible(true);
        this.cbPrFin.setEnabled(false);
        HorizontalLayout axePrContainer = new HorizontalLayout(new Component[]{this.cbAxe, this.cbPrDebut, this.cbPrFin});
        axePrContainer.setSpacing(false);
        axePrContainer.addClassName("gap-s");
        axePrContainer.getStyle().set("--vaadin-field-default-width", "7em");
        axePrContainer.setFlexGrow(1.0, new HasElement[]{this.cbAxe});
        return new Component[]{this.delegationAndCenterField, this.cbCircuit, axePrContainer};
    }

    private Component configureEventCategoriesField() {
        this.mscbEventCategory.setClearButtonVisible(true);
        this.mscbEventCategory.setVisible(this.service.isEventCategoriesEnable());
        return this.mscbEventCategory;
    }

    private Component configureAgentField() {
        this.mscbAgent.setItemLabelGenerator((ItemLabelGenerator & Serializable)user -> user.getNom() + " (" + user.getCode() + ")");
        this.mscbAgent.setAutoExpand(MultiSelectComboBox.AutoExpandMode.VERTICAL);
        this.mscbAgent.setPlaceholder("Tous les agents");
        this.mscbAgent.setItems(this.service.getAgents());
        return this.mscbAgent;
    }

    private Component configureAggregation() {
        this.rbgAggregation.setItemLabelGenerator((ItemLabelGenerator & Serializable)item -> this.getTranslation(item.getI18nLabel(), new Object[0]));
        this.rbgAggregation.setItems(Arrays.asList(AggregationValue.values()));
        this.rbgAggregation.setValue((Object)AggregationValue.CENTRE);
        this.rbgAggregation.setVisible(this.aggregationEnabled);
        return this.rbgAggregation;
    }

    private Component configureCodeFilter() {
        this.tfEventCode.setClearButtonVisible(true);
        this.tfEventCode.setVisible(this.service.isEventCodeFilterEnable());
        return this.tfEventCode;
    }

    private void configureDelegationAndCenterRestrictions() {
        AuthenticatedUser currentUser = this.service.getCurrentUser();
        Delegation delegation = currentUser.getDelegation();
        Centre centre = currentUser.getCentre();
        if (this.primaryBusinessModuleCode != null) {
            if (this.service.doitVerrouillerCentre(this.primaryBusinessModuleCode.intValue())) {
                this.delegationAndCenterField.setReadOnly(true);
            } else if (this.service.doitVerrouillerDelegation(this.primaryBusinessModuleCode.intValue())) {
                this.delegationAndCenterField.setDelegationReadOnly();
            }
        }
        this.delegationAndCenterField.setValue((Object)DelegationAndCenter.of((Delegation)delegation, (Centre)centre));
    }

    private String circuitToStringWithCenter(Circuit circuit) {
        return circuit.getNom() + " (" + circuit.getCentre() + ")";
    }

    private Accordion createNatureFields(Collection<? extends ModuleMetier> selectedBusinessModules) {
        Accordion ret = new Accordion();
        ret.addClassName("event-filter-accordion");
        Collection fields = this.service.getCommonFields(selectedBusinessModules);
        ArrayList<Champ> rootFields = new ArrayList<Champ>();
        ArrayList<ChampMultiple> subFields = new ArrayList<ChampMultiple>();
        for (Object field : fields) {
            if (field instanceof ChampMultiple) {
                ChampMultiple champMultiple = (ChampMultiple)field;
                subFields.add(champMultiple);
                continue;
            }
            rootFields.add((Champ)field);
        }
        ArrayList<AbstractEventFilterField> rootComponents = new ArrayList<AbstractEventFilterField>(rootFields.size());
        for (Champ field : rootFields) {
            AbstractEventFilterField component2 = this.factory.getView(field);
            if (component2 == null) continue;
            rootComponents.add(component2);
            this.commonFields.put(field.getNom(), component2);
        }
        String rootPanelSummary = "Filtres communs";
        AccordionPanel rootPanel = new AccordionPanel("Filtres communs");
        rootPanel.add(Collections.unmodifiableList(rootComponents));
        rootPanel.addThemeVariants((ThemeVariant[])new DetailsVariant[]{DetailsVariant.FILLED});
        ret.add(rootPanel);
        rootComponents.forEach(component -> component.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> rootPanel.setSummaryText("Filtres communs" + (rootComponents.stream().allMatch(AbstractField::isEmpty) ? "" : " *"))));
        for (ChampMultiple field : subFields) {
            AbstractEventFilterField component3 = this.factory.getView((Champ)field);
            if (component3 == null) continue;
            component3.addClassName("no-style");
            this.commonFields.put(field.getNom(), component3);
            String panelSummary = field.getLibelle() + " (" + field.getNom() + ")";
            AccordionPanel panel = new AccordionPanel(panelSummary, (Component)component3);
            panel.addThemeVariants((ThemeVariant[])new DetailsVariant[]{DetailsVariant.FILLED});
            ret.add(panel);
            component3.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> panel.setSummaryText(panelSummary + (event.getHasValue().isEmpty() ? "" : " *")));
        }
        return ret;
    }

    private void onBusinessModuleValueChange(HasValue.ValueChangeEvent<Set<ModuleMetier>> event) {
        this.dynamicComponentsContainer.removeAll();
        this.descriptions = List.of();
        this.natureFilters = List.of();
        Set tmpSelectedNatures = this.mscbNature.getValue();
        Collection natures = this.service.getNaturesForBusinessModules((Collection)event.getValue());
        this.mscbNature.setItems(natures);
        this.mscbNature.setValue((Set)tmpSelectedNatures.stream().filter(natures::contains).collect(Collectors.toCollection(LinkedHashSet::new)));
        if (this.service.isEventCategoriesEnable()) {
            Collection eventCategories = this.service.getEventCategories((Collection)event.getValue());
            this.mscbEventCategory.setItems(eventCategories);
            this.mscbEventCategory.setReadOnly(eventCategories.size() < 2);
            this.mscbEventCategory.setPlaceholder(eventCategories.size() == 1 ? (String)eventCategories.iterator().next() : null);
        }
        this.commonFields.clear();
        this.factory.runWithContext(null, () -> {
            Accordion dynamicComponents = this.createNatureFields((Collection)event.getValue());
            dynamicComponents.setSizeFull();
            this.dynamicComponentsContainer.add(new Component[]{dynamicComponents});
        });
    }

    private void onNatureFilterClick(ClickEvent<Button> event) {
        NatureFieldDialog dialog = new NatureFieldDialog((Collection)this.mscbNature.getValue(), this.service.getDescriptionsNatureMap(), this.commonFields.keySet(), this.factory);
        dialog.setValue(this.descriptions, this.natureFilters);
        dialog.addValidateEventListener(arg_0 -> this.onNatureFieldDialogValidate(arg_0));
        dialog.open();
    }

    private void onNatureFieldDialogValidate(NatureFieldDialog.ValidateEvent event) {
        this.descriptions = event.getSelectedDescriptions();
        this.natureFilters = event.getNatureFilters();
    }

    private void onDelegationAndCenterValueChange(HasValue.ValueChangeEvent<DelegationAndCenter> event) {
        DelegationAndCenter value = (DelegationAndCenter)event.getValue();
        String delegation = value.getDelegation();
        String center = value.getCenter();
        this.cbCircuit.clear();
        this.cbCircuit.setItemLabelGenerator((ItemLabelGenerator)(center != null ? Circuit::getNom : arg_0 -> this.circuitToStringWithCenter(arg_0)));
        if (value.isEmpty()) {
            this.cbCircuit.getListDataView().removeFilters();
        } else {
            this.cbCircuit.getListDataView().setFilter(this.getCircuitFilter(value));
        }
        this.mscbAgent.clear();
        if (value.isEmpty()) {
            this.mscbAgent.getListDataView().removeFilters();
        } else {
            this.mscbAgent.getListDataView().setFilter((SerializablePredicate & Serializable)userVaadinBean -> !(delegation != null && !delegation.equalsIgnoreCase(userVaadinBean.getDelegation()) && userVaadinBean.getDelegation() != null || center != null && !center.equalsIgnoreCase(userVaadinBean.getCentre()) && userVaadinBean.getCentre() != null));
        }
    }

    private SerializablePredicate<Circuit> getCircuitFilter(DelegationAndCenter delegationAndCenter) {
        if (delegationAndCenter.isEmpty()) {
            return null;
        }
        String delegationName = delegationAndCenter.getDelegation();
        String centerName = delegationAndCenter.getCenter();
        return (SerializablePredicate & Serializable)circuit -> !(!ConstantesGLS.estVide((String)delegationName) && !ConstantesGLS.egal((String)delegationName, (String)circuit.getDelegation()) || !ConstantesGLS.estVide((String)centerName) && !ConstantesGLS.egal((String)centerName, (String)circuit.getCentre()));
    }

    private void onAxeValueChange(HasValue.ValueChangeEvent<String> event) {
        if (event.getHasValue().isEmpty()) {
            this.cbPrDebut.clear();
            this.cbPrDebut.setEnabled(false);
        } else {
            this.cbPrDebut.setEnabled(true);
            this.cbPrDebut.clear();
            Collection prList = this.service.getPrListForAxe((String)event.getValue());
            this.cbPrDebut.setItems(prList);
            this.cbPrFin.setItems(prList);
        }
    }

    private void onPrDebutValueChange(HasValue.ValueChangeEvent<String> event) {
        this.cbPrFin.setEnabled(!event.getHasValue().isEmpty());
    }

    private void readValue(EventFilter oldValue) {
        IBusinessService.EvenementFiltre sqlFilter = oldValue.getSqlFilter();
        List javaFilters = ListUtils.emptyIfNull((List)oldValue.getJavaFilters());
        this.cbgBusinessModule.setValue(sqlFilter.codeModuleMetier == null ? Set.of() : sqlFilter.codeModuleMetier.stream().map(this.businessModules::get).collect(Collectors.toUnmodifiableSet()));
        this.mscbCreationContext.setValue(ListUtils.emptyIfNull((List)sqlFilter.contexteCreation).stream().map(this.contextCreationBusinessModules::get).collect(Collectors.toSet()));
        ImmutableMap naturesByCode = Maps.uniqueIndex((Iterable)this.service.getNaturesForBusinessModules((Collection)this.cbgBusinessModule.getValue()), Nature::getCode);
        this.mscbNature.setValue((Set)ListUtils.emptyIfNull((List)sqlFilter.nature).stream().map(((Map)naturesByCode)::get).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new)));
        DateTimeRange dateTimeRange = new DateTimeRange(sqlFilter.dateMin == null ? null : sqlFilter.dateMin.toLocalDateTime(), sqlFilter.dateMax == null ? null : sqlFilter.dateMax.toLocalDateTime());
        this.odtrpDateMinMax.setValue(Optional.of(dateTimeRange).filter(Predicate.not(arg_0 -> ((DateTimeRange)DateTimeRange.empty()).equals(arg_0))));
        this.cbEventState.setValue((Object)EventState.getByValue((int)sqlFilter.termines));
        this.delegationAndCenterField.setValue((Object)oldValue.getDelegationAndCenter());
        if (sqlFilter.idCircuit != null) {
            this.cbCircuit.setValue((Object)((Circuit)this.circuitsById.get(sqlFilter.idCircuit)));
        }
        if (sqlFilter.route != null) {
            this.cbAxe.setValue((Object)sqlFilter.route);
            if (sqlFilter.prDeb != null) {
                this.cbPrDebut.setValue((Object)sqlFilter.prDeb);
                if (sqlFilter.prFin != null) {
                    this.cbPrFin.setValue((Object)sqlFilter.prFin);
                }
            }
        }
        this.mscbEventCategory.setValue(ListUtils.emptyIfNull((List)sqlFilter.categorieNature).stream().filter(this.mscbEventCategory.getListDataView().getItems().toList()::contains).collect(Collectors.toSet()));
        HashSet selectedAgentIds = new HashSet(ListUtils.emptyIfNull((List)sqlFilter.agents));
        this.mscbAgent.setValue(this.mscbAgent.getListDataView().getItems().filter(user -> selectedAgentIds.contains(user.getId())).toList());
        if (this.aggregationEnabled && !ConstantesGLS.estVide((String)sqlFilter.agregation)) {
            this.rbgAggregation.setValue((Object)AggregationValue.getByValue((String)sqlFilter.agregation));
        }
        if (this.tfEventCode.isVisible()) {
            if (sqlFilter.code == null || sqlFilter.code.isEmpty()) {
                this.tfEventCode.clear();
            } else {
                this.tfEventCode.setValue(String.join((CharSequence)",", sqlFilter.code));
            }
        }
        for (FiltreJava javaFilter : javaFilters) {
            AbstractEventFilterField field;
            if (javaFilter == null || (field = (AbstractEventFilterField)this.commonFields.get(javaFilter.getChampNom())) == null) continue;
            field.setValue(javaFilter);
        }
        this.descriptions = ListUtils.emptyIfNull((List)sqlFilter.descriptions);
        this.natureFilters = javaFilters;
    }

    public ValidationResult validate() {
        if (this.cbgBusinessModule.isEmpty()) {
            return ValidationResult.error((String)this.getTranslation("mct.filtre.codeModuleMetierVide.message", new Object[0]));
        }
        if (this.cbEventState.isEmpty()) {
            return ValidationResult.error((String)"NO STATE SELECTED");
        }
        return ValidationResult.ok();
    }

    public EventFilter getValue() {
        Objects.requireNonNull(this.oldValue);
        IBusinessService.EvenementFiltre sqlFilter = (IBusinessService.EvenementFiltre)DeepCopy.copy((Object)this.oldValue.getSqlFilter());
        LinkedList javaFilters = new LinkedList();
        sqlFilter.codeModuleMetier = ((Set)this.cbgBusinessModule.getValue()).stream().map(ModuleMetier::getCode).toList();
        if (this.service.isContextFilterEnable()) {
            sqlFilter.contexteCreation = this.mscbCreationContext.getValue().stream().map(ModuleMetier::getCode).toList();
        }
        sqlFilter.nature = this.mscbNature.isEmpty() ? null : this.mscbNature.getValue().stream().map(Nature::getCode).toList();
        sqlFilter.dateMin = ((Optional)this.odtrpDateMinMax.getValue()).map(DateTimeRange::getStart).map(Timestamp::valueOf).orElse(null);
        sqlFilter.dateMax = ((Optional)this.odtrpDateMinMax.getValue()).map(DateTimeRange::getEnd).map(Timestamp::valueOf).orElse(null);
        sqlFilter.termines = ((EventState)this.cbEventState.getValue()).getValue();
        sqlFilter.idCircuit = this.cbCircuit.getOptionalValue().map(Circuit::getId).orElse(null);
        if (this.cbAxe.isEmpty()) {
            sqlFilter.route = null;
            sqlFilter.prDeb = null;
            sqlFilter.prFin = null;
        } else {
            sqlFilter.route = (String)this.cbAxe.getValue();
            if (this.cbPrDebut.isEmpty()) {
                sqlFilter.prDeb = null;
                sqlFilter.prFin = null;
            } else {
                sqlFilter.prDeb = (String)this.cbPrDebut.getValue();
                sqlFilter.prFin = this.cbPrFin.getOptionalValue().orElse(null);
            }
        }
        if (this.service.isEventCategoriesEnable()) {
            sqlFilter.categorieNature = List.copyOf(this.mscbEventCategory.getValue());
        }
        sqlFilter.agents = this.mscbAgent.getValue().stream().map(UserVaadinBean::getId).toList();
        if (this.aggregationEnabled && !this.rbgAggregation.isEmpty()) {
            sqlFilter.agregation = ((AggregationValue)this.rbgAggregation.getValue()).getValue();
        }
        sqlFilter.code = this.tfEventCode.isVisible() && !this.tfEventCode.isEmpty() ? List.of(this.tfEventCode.getValue().split(",")) : null;
        this.commonFields.values().stream().map(AbstractField::getValue).filter(Objects::nonNull).forEach(javaFilters::add);
        if (sqlFilter.nature != null) {
            this.natureFilters.stream().filter(java -> sqlFilter.nature.contains(java.getNatureNom())).forEach(javaFilters::add);
        }
        sqlFilter.descriptions = this.descriptions.isEmpty() ? null : this.descriptions;
        return EventFilter.builder().unlocalizedName("mct.filtre.evenements.perso").mmCodes(sqlFilter.codeModuleMetier).delegationAndCenter((DelegationAndCenter)this.delegationAndCenterField.getValue()).sqlFilter(sqlFilter).javaFilters(javaFilters).isCustom(true).build();
    }
}

