/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.filter;

import com.neogls.prism.central.vaadin.common.component.ErrorDialog;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilter;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilterEditDialog;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilterEditForm;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.EventFilterFormService;
import com.neogls.prism.central.vaadin.view.mct.common.event.filter.field.IVaadinEventFilterFieldFactory;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.binder.ValidationResult;
import java.util.List;

public class EventFilterEditDialog
extends Dialog {
    private final Button bValidate = new Button(this.getTranslation("mct.filtre.valider", new Object[0]), arg_0 -> this.onValidateClick(arg_0));
    private final Button bCancel = new Button(this.getTranslation("mct.filtre.annuler", new Object[0]), arg_0 -> this.onCancelClick(arg_0));
    private final EventFilterEditForm eventFilterEditForm;

    public EventFilterEditDialog(EventFilter value, List<Integer> businessModuleCodes, EventFilterFormService service, IVaadinEventFilterFieldFactory factory) {
        this.bValidate.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.bCancel.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
        this.eventFilterEditForm = new EventFilterEditForm(value, businessModuleCodes, service, factory);
        this.eventFilterEditForm.setSizeFull();
        this.setHeaderTitle(this.getTranslation("mct.filter.edit", new Object[0]));
        this.add(new Component[]{this.eventFilterEditForm});
        this.getFooter().add(new Component[]{this.bCancel, this.bValidate});
        this.setCloseOnOutsideClick(false);
        this.setCloseOnEsc(false);
        this.setHeightFull();
    }

    private void onValidateClick(ClickEvent<Button> event) {
        ValidationResult validationResult = this.eventFilterEditForm.validate();
        if (validationResult.isError()) {
            ErrorDialog.builder().title("").message(validationResult.getErrorMessage()).build().open();
        } else {
            this.fireEvent((ComponentEvent)new ValidateEvent(this, event.isFromClient(), this.eventFilterEditForm.getValue()));
            this.close();
        }
    }

    private void onCancelClick(ClickEvent<Button> event) {
        this.fireEvent((ComponentEvent)new CancelEvent(this, event.isFromClient()));
        this.close();
    }

    public void addValidateListener(ComponentEventListener<ValidateEvent> listener) {
        this.addListener(ValidateEvent.class, listener);
    }

    public void addCancelListener(ComponentEventListener<CancelEvent> listener) {
        this.addListener(CancelEvent.class, listener);
    }
}

