/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismcentral.export.i18n.ReportI18n;
import com.google.common.collect.Maps;
import com.neogls.prism.central.vaadin.util.DateTimeFormatterUtils;
import com.vaadin.flow.component.combobox.ComboBox;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

public class EventVersionComboBox
extends ComboBox<Evenement> {
    private final Map<Integer, Evenement> versionByNumber;
    private final Function<Evenement, String> eventEditorUsernameGetter;

    public EventVersionComboBox(Evenement event, Collection<Evenement> versions, Function<Evenement, String> eventEditorUsernameGetter) {
        this.versionByNumber = Maps.uniqueIndex(versions, Evenement::getNumVersion);
        this.eventEditorUsernameGetter = eventEditorUsernameGetter;
        this.setItemLabelGenerator(arg_0 -> this.eventToVersionString(arg_0));
        this.setItems(this.versionByNumber.values());
        this.setValue((Object)((Evenement)this.versionByNumber.get(event.getNumVersion())));
        this.setReadOnly(this.versionByNumber.size() < 2);
    }

    private String eventToVersionString(Evenement event) {
        String username = (String)this.eventEditorUsernameGetter.apply(event);
        Instant updateTimestamp = Instant.ofEpochMilli(event.getDateMaj());
        return event.getNumVersion() + " " + this.getCodeLibelleEtatEvenement(event) + " : " + DateTimeFormatterUtils.getDateFormatter().format(updateTimestamp) + " " + this.getTranslation("mct.description.a", new Object[0]) + " " + DateTimeFormatterUtils.getTimeFormatter().format(updateTimestamp) + " " + this.getTranslation("mct.description.par", new Object[0]) + " " + username + " (" + this.getLibelleEtatEvenement(event, (Evenement)this.versionByNumber.get(event.getNumVersion() - 1)) + ")";
    }

    private String getCodeLibelleEtatEvenement(Evenement event) {
        if (event.getNumVersion() <= 1) {
            if (!event.isTermine()) {
                return " C ";
            }
            return "C/F";
        }
        if (event.isTermine()) {
            if (event.isAnnule()) {
                return " X ";
            }
            return " F ";
        }
        if (event.isProgramme()) {
            return "M/P";
        }
        return " M ";
    }

    private String getLibelleEtatEvenement(Evenement nouveau, Evenement ancien) {
        if (nouveau.getNumVersion() <= 1) {
            if (!nouveau.isTermine()) {
                return ReportI18n.getString((String)"mcig.libelleCreation");
            }
            return ReportI18n.getString((String)"mcig.libelleCreation") + " / " + ReportI18n.getString((String)"mcig.libelleCloture");
        }
        if (nouveau.isTermine()) {
            if (nouveau.isAnnule()) {
                return ReportI18n.getString((String)"mcig.libelleAnnule");
            }
            return ReportI18n.getString((String)"mcig.libelleCloture");
        }
        if (ancien != null && MetierCommun.estTypeDefautPrism((int)ancien.getType()) && nouveau.getType() == 4) {
            return ReportI18n.getString((String)"mcig.libelleAxioneTransmis");
        }
        if (!nouveau.isProgramme()) {
            return ReportI18n.getString((String)"mcig.libelleModification");
        }
        return ReportI18n.getString((String)"mcig.libelleModification") + " / " + ReportI18n.getString((String)"mcig.libelleProgrammation");
    }
}

