/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog;

import com.geolocsystems.prismandroid.MetierCommun;
import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.NatureOuRaccourci;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismcentral.data.IBusinessService;
import com.neogls.prism.central.vaadin.common.bean.Point3D;
import com.neogls.prism.central.vaadin.service.event.EventService;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet.EventSheet;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.DDPEventSheetDialog;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.DefaultEventSheetDialog;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialog;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialogService;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class EventSheetDialogFactory {
    private final EventService eventService;
    private final EventSheetDialogService eventSheetDialogService;
    private final IBusinessService businessService;

    public Optional<EventSheetDialog> createFromEventId(int eventId, boolean readonly) {
        return this.eventService.findSituationByEventId(eventId).map(situation -> this.createEventSheetDialogForExistingEvent(situation, readonly));
    }

    public EventSheetDialog createEventSheetDialogForCreation(@Nonnull NatureOuRaccourci natureOuRaccourci, Point3D centerZoom) {
        EventSheet eventSheet = this.eventSheetDialogService.newEventSheet(natureOuRaccourci, centerZoom);
        return natureOuRaccourci.getCodeMM() == 5 ? new DDPEventSheetDialog(this.eventSheetDialogService, null, eventSheet, false) : new DefaultEventSheetDialog(eventSheet, false);
    }

    public EventSheetDialog createEventSheetDialogForEdition(@Nonnull Situation situation) {
        return this.createEventSheetDialogForExistingEvent(situation, false);
    }

    public EventSheetDialog createEventSheetDialogReadOnly(@Nonnull Situation situation) {
        return this.createEventSheetDialogForExistingEvent(situation, true);
    }

    public EventSheetDialog createEventSheetDialogForExistingEvent(@Nonnull Situation situation, boolean readonly) {
        EventSheet eventSheet = this.eventSheetDialogService.newEventSheet(situation.getEvenementPrincipal(), readonly);
        return this.isDDP(situation) ? new DDPEventSheetDialog(this.eventSheetDialogService, situation, eventSheet, readonly) : new DefaultEventSheetDialog(eventSheet, readonly);
    }

    private boolean isDDP(Situation situation) {
        return MetierCommun.estDDP((Situation)situation, (Map)this.businessService.getNatures()) || MetierCommun.estIntervention((Evenement)situation.getEvenementPrincipal(), (List)this.businessService.getNaturesList());
    }

    public EventSheetDialog createDefaultEventSheet(@Nonnull Situation situation, boolean readonly) {
        EventSheet eventSheet = this.eventSheetDialogService.newEventSheet(situation.getEvenementPrincipal(), readonly);
        return new DefaultEventSheetDialog(eventSheet, readonly);
    }

    @Generated
    public EventSheetDialogFactory(EventService eventService, EventSheetDialogService eventSheetDialogService, IBusinessService businessService) {
        this.eventService = eventService;
        this.eventSheetDialogService = eventSheetDialogService;
        this.businessService = businessService;
    }
}

