/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog;

import com.neogls.prism.central.vaadin.common.component.confirmdialog.ButtonConfig;
import com.neogls.prism.central.vaadin.common.component.confirmdialog.ConfirmDialog;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet.EventSheet;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSaveEvent;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialog;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import java.io.Serializable;

public class DefaultEventSheetDialog
extends EventSheetDialog {
    private final boolean readOnly;
    private final Button bSave = new Button(this.getTranslation("ficheevt.sauvegarder", new Object[0]), (Component)VaadinIcon.CHECK.create(), arg_0 -> this.onSaveClick(arg_0));
    private final EventSheet eventSheet;

    DefaultEventSheetDialog(EventSheet eventSheet, boolean readonly) {
        this.eventSheet = eventSheet;
        this.readOnly = readonly;
        eventSheet.addEventVersionChangeListener((ComponentEventListener & Serializable)event -> this.bSave.setEnabled(((EventSheet)event.getSource()).isMainVersionSelected()));
        eventSheet.setSizeFull();
        this.add(new Component[]{eventSheet});
        this.createButtons();
        this.setCloseOnOutsideClick(false);
        this.setSizeFull();
        this.addClassName("event-sheet-dialog");
    }

    private void createButtons() {
        Icon cancelIcon = VaadinIcon.CLOSE.create();
        cancelIcon.setColor("red");
        Button bCancel = new Button(this.getTranslation("ficheevt.retour", new Object[0]), (Component)cancelIcon);
        if (this.readOnly) {
            bCancel.addClickListener((ComponentEventListener & Serializable)event -> this.close());
            this.getFooter().add(new Component[]{bCancel});
        } else {
            this.setCloseOnEsc(false);
            bCancel.addClickListener(arg_0 -> this.onCancelClick(arg_0));
            bCancel.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
            this.getFooter().add(new Component[]{bCancel, this.bSave});
        }
    }

    private void onCancelClick(ClickEvent<Button> event) {
        ConfirmDialog.builder().title(this.getTranslation("ficheevt.annuler.title", new Object[0])).text(this.getTranslation("ficheevt.annuler.message", new Object[0])).confirm(ButtonConfig.builder().text(this.getTranslation("ficheevt.annuler.ok", new Object[0])).listener((ComponentEventListener & Serializable)e -> this.close()).build()).cancel(ButtonConfig.builder().text(this.getTranslation("ficheevt.annuler.nok", new Object[0])).build()).build().open();
    }

    private void onSaveClick(ClickEvent<Button> event) {
        if (!this.eventSheet.isValid()) {
            ConfirmDialog.builder().title(this.getTranslation("ficheevt.erreursauvegarde", new Object[0])).text(this.getTranslation("ficheevt.erreursauvegarde.message", new Object[0])).confirm(ButtonConfig.builder().text(this.getTranslation("ficheevt.annuler.nok", new Object[0])).build()).build().open();
            return;
        }
        this.fireEvent((ComponentEvent)new EventSaveEvent((EventSheetDialog)this, event.isFromClient(), this.eventSheet.getEvent(), this.eventSheet.getPhotoList()));
        this.close();
    }

    public void setSaveButtonText(String text) {
        this.bSave.setText(text);
    }

    public void setSaveButtonIcon(Component icon) {
        this.bSave.setIcon(icon);
    }
}

