/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog;

import com.geolocsystems.prismandroid.model.evenements.Evenement;
import com.geolocsystems.prismandroid.model.evenements.Situation;
import com.geolocsystems.prismandroid.model.evenements.champs.Champ;
import com.geolocsystems.prismandroid.model.evenements.champs.ChampLocalisation;
import com.geolocsystems.prismandroid.model.evenements.valeurchamps.ValeurChampLocalisation;
import com.neogls.prism.central.vaadin.common.component.confirmdialog.ButtonConfig;
import com.neogls.prism.central.vaadin.common.component.confirmdialog.ConfirmDialog;
import com.neogls.prism.central.vaadin.common.component.tabsheet.PrismTabSheet;
import com.neogls.prism.central.vaadin.view.mct.common.event.NatureSelectionComponent;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet.EventSheet;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSaveEvent;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialog;
import com.neogls.prism.central.vaadin.view.mct.common.event.eventsheetdialog.EventSheetDialogService;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import jakarta.annotation.Nullable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDPEventSheetDialog
extends EventSheetDialog {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DDPEventSheetDialog.class);
    private final EventSheetDialogService service;
    private final EventSheet mainEventSheet;
    private final boolean readonly;
    private final String situationId;
    private final Map<Tab, Evenement> eventsByTab = new HashMap();
    private final Map<Tab, EventSheet> eventSheetsByTab = new HashMap();
    private final PrismTabSheet tabSheet = new PrismTabSheet(true);
    @Nullable
    private EventSheet currentEventSheet = null;
    @Nullable
    private ValeurChampLocalisation interventionEventLocation = null;
    private final Button bCancel = new Button(this.getTranslation("ficheevt.retour", new Object[0]), (Component)VaadinIcon.CLOSE.create(), arg_0 -> this.onCancelClick(arg_0));
    private final Button bSave = new Button(this.getTranslation("ficheevt.sauvegarder", new Object[0]), (Component)VaadinIcon.CHECK.create(), arg_0 -> this.onSaveClick(arg_0));

    public DDPEventSheetDialog(EventSheetDialogService service, @Nullable Situation situation, EventSheet eventSheet, boolean readonly) {
        this.service = service;
        this.mainEventSheet = eventSheet;
        this.readonly = readonly;
        this.situationId = this.getOrCreateSituationId(situation);
        PrismTabSheet tabSheet = this.createTabSheet(situation);
        this.add(new Component[]{tabSheet});
        tabSheet.setSizeFull();
        this.createFooter();
        this.setCloseOnOutsideClick(false);
        this.setSizeFull();
        this.addClassName("ddp-event-sheet-dialog");
    }

    private String getOrCreateSituationId(@Nullable Situation situation) {
        if (situation != null) {
            return situation.getSid();
        }
        return new Evenement().getIdSituation();
    }

    private List<Evenement> createEventList(Situation situation) {
        if (situation == null) {
            return List.of();
        }
        LinkedList<Evenement> eventList = new LinkedList<Evenement>();
        for (Evenement event : situation.getEvenements()) {
            if (this.service.getEventBusinessModuleCode(event) == 5) {
                eventList.addFirst(event);
                continue;
            }
            eventList.addLast(event);
        }
        return eventList;
    }

    private PrismTabSheet createTabSheet(@Nullable Situation situation) {
        this.tabSheet.setAutoselect(false);
        Tab mainTab = null;
        if (situation == null) {
            Tab tab = this.createEventSheetTab(this.mainEventSheet);
            this.tabSheet.addTab(tab, (Component)this.mainEventSheet);
            mainTab = tab;
        } else {
            List eventList = this.createEventList(situation);
            this.interventionEventLocation = ((Evenement)eventList.get(0)).getLocalisation();
            for (Evenement event2 : eventList) {
                EventSheet eventSheet = situation.getEvenementPrincipal() != event2 ? this.service.newEventSheet(event2, this.readonly) : this.mainEventSheet;
                Tab tab = this.createEventSheetTab(eventSheet);
                this.tabSheet.addTab(tab, (Component)eventSheet);
                this.eventsByTab.put(tab, event2);
                if (eventSheet != this.mainEventSheet) continue;
                mainTab = tab;
            }
        }
        ((EventSheet)this.eventSheetsByTab.get(this.tabSheet.getTabAt(0))).addEventValueChangeListener((ComponentEventListener & Serializable)event -> {
            Champ patt4842$temp = event.getField();
            if (patt4842$temp instanceof ChampLocalisation) {
                ChampLocalisation localisation = (ChampLocalisation)patt4842$temp;
                this.interventionEventLocation = (ValeurChampLocalisation)localisation.getValeurChamp();
            }
        });
        this.tabSheet.addSelectedChangeListener(arg_0 -> this.onSelectedTabChange(arg_0));
        if (!this.readonly) {
            NatureSelectionComponent natureSelectionComponent = new NatureSelectionComponent(this.service.getNaturesOuRaccourcisPatrouillage());
            Tab tabNewDDP = new Tab(new Component[]{new Span(new Component[]{new Image("images/ajouterddp.png", null), new Text(this.getTranslation("mct.onglet.ddp", new Object[0]))})});
            this.tabSheet.addTab(tabNewDDP, (Component)natureSelectionComponent);
            natureSelectionComponent.addNatureSelectionListener(arg_0 -> this.onNatureSelection(arg_0));
        }
        this.tabSheet.setSelectedTab(mainTab);
        return this.tabSheet;
    }

    private Tab createEventSheetTab(EventSheet eventSheet) {
        eventSheet.setSizeFull();
        Image tabIcon = new Image(eventSheet.getIconURL(), null);
        Span tabTitle = new Span(this.getTabTitle(eventSheet));
        Tab tab = new Tab(new Component[]{new Span(new Component[]{tabIcon, tabTitle})});
        this.eventSheetsByTab.put(tab, eventSheet);
        eventSheet.addEventValueChangeListener((ComponentEventListener & Serializable)event -> tabTitle.setText(this.getTabTitle(eventSheet)));
        eventSheet.addEventVersionChangeListener((ComponentEventListener & Serializable)event -> this.bSave.setEnabled(((EventSheet)event.getSource()).isMainVersionSelected()));
        return tab;
    }

    private void createFooter() {
        this.setCloseOnEsc(false);
        this.bCancel.addClickShortcut(Key.ESCAPE, new KeyModifier[0]);
        this.bCancel.addClassName("btn-cancel");
        this.bSave.setVisible(!this.readonly);
        this.getFooter().add(new Component[]{this.bCancel, this.bSave});
    }

    private void onSelectedTabChange(Tabs.SelectedChangeEvent event) {
        this.currentEventSheet = (EventSheet)this.eventSheetsByTab.get(event.getSelectedTab());
        log.debug("onSelectedTabChange: {}", (Object)(this.currentEventSheet == null ? "null" : this.currentEventSheet.getTitle()));
        this.bCancel.setEnabled(this.currentEventSheet != null);
        this.bSave.setEnabled(this.currentEventSheet != null && this.currentEventSheet.isMainVersionSelected());
    }

    private void onNatureSelection(NatureSelectionComponent.NatureSelectionEvent event) {
        EventSheet eventSheet = this.service.newEventSheet(event.getNatureOuRaccourci(), this.interventionEventLocation);
        Tab tab = this.createEventSheetTab(eventSheet);
        this.tabSheet.addTabAtIndex(tab, (Component)eventSheet, this.tabSheet.getComponentCount() - 1);
        this.tabSheet.setSelectedTab(tab);
    }

    private String getTabTitle(EventSheet eventSheet) {
        return eventSheet.isModified() ? eventSheet.getTitle() + " *" : eventSheet.getTitle();
    }

    private void onCancelClick(ClickEvent<Button> event) {
        Objects.requireNonNull(this.currentEventSheet);
        if (this.readonly) {
            this.close();
        } else if (this.tabSheet.getSelectedIndex() == 0) {
            this.onCancelIntervention();
        } else if (!this.eventsByTab.containsKey(this.tabSheet.getSelectedTab())) {
            this.onCancelNewDDP();
        } else if (this.currentEventSheet.isModified()) {
            this.onCancelModifiedDDP();
        }
    }

    private void onCancelIntervention() {
        if (this.isDDPModified()) {
            ConfirmDialog.builder().title(this.getTranslation("ficheevt.ddp.title", new Object[0])).text(this.getTranslation("ficheevt.ddp.message", new Object[0])).confirm(ButtonConfig.builder().text(this.getTranslation("generic.yes", new Object[0])).listener((ComponentEventListener & Serializable)event -> this.close()).build()).cancel(ButtonConfig.builder().text(this.getTranslation("generic.no", new Object[0])).build()).build().open();
        } else {
            this.createDefaultCancelConfirmDialog((ComponentEventListener & Serializable)event -> this.close()).open();
        }
    }

    private boolean isDDPModified() {
        return IntStream.range(1, this.tabSheet.getComponentCount() - 1).mapToObj(arg_0 -> ((PrismTabSheet)this.tabSheet).getTabAt(arg_0)).map(this.eventSheetsByTab::get).anyMatch(EventSheet::isModified);
    }

    private void onCancelNewDDP() {
        this.createDefaultCancelConfirmDialog((ComponentEventListener & Serializable)event -> {
            Tab currentTab = this.tabSheet.getSelectedTab();
            this.tabSheet.setSelectedIndex(0);
            this.tabSheet.remove(new Tab[]{currentTab});
            this.eventSheetsByTab.remove(currentTab);
        }).open();
    }

    private void onCancelModifiedDDP() {
        this.createDefaultCancelConfirmDialog((ComponentEventListener & Serializable)event -> {
            int index = this.tabSheet.getSelectedIndex();
            Tab tabAtIndex = this.tabSheet.getTabAt(index);
            this.tabSheet.setSelectedTab(null);
            EventSheet eventSheet = this.service.newEventSheet((Evenement)this.eventsByTab.get(tabAtIndex), false);
            Tab tab = this.createEventSheetTab(eventSheet);
            this.eventsByTab.put(tab, (Evenement)this.eventsByTab.remove(tabAtIndex));
            this.tabSheet.remove(new Tab[]{tabAtIndex});
            this.tabSheet.addTabAtIndex(tab, (Component)eventSheet, index);
            this.tabSheet.setSelectedTab(tab);
        }).open();
    }

    private ConfirmDialog createDefaultCancelConfirmDialog(ComponentEventListener<ClickEvent<Button>> confirmListener) {
        return ConfirmDialog.builder().title(this.getTranslation("ficheevt.annuler.title", new Object[0])).text(this.getTranslation("ficheevt.annuler.message", new Object[0])).confirm(ButtonConfig.builder().text(this.getTranslation("generic.yes", new Object[0])).listener(confirmListener).build()).cancel(ButtonConfig.builder().text(this.getTranslation("generic.no", new Object[0])).build()).build();
    }

    private void onSaveClick(ClickEvent<Button> e) {
        Objects.requireNonNull(this.currentEventSheet);
        if (!this.currentEventSheet.isValid()) {
            ConfirmDialog.builder().title(this.getTranslation("ficheevt.erreursauvegarde", new Object[0])).text(this.getTranslation("ficheevt.erreursauvegarde.message", new Object[0])).confirm(ButtonConfig.builder().text(this.getTranslation("ficheevt.annuler.nok", new Object[0])).build()).build().open();
            return;
        }
        if (this.tabSheet.getSelectedIndex() == 0) {
            this.saveInterventionEvent(this.currentEventSheet, e.isFromClient());
        } else {
            this.saveDDPEvent(this.currentEventSheet, e.isFromClient());
        }
    }

    private void saveInterventionEvent(EventSheet eventSheet, boolean fromClient) {
        if (this.isDDPModified()) {
            ConfirmDialog.builder().title(this.getTranslation("ficheevt.ddp.title", new Object[0])).text(this.getTranslation("ficheevt.ddp.message", new Object[0])).confirm(ButtonConfig.builder().text(this.getTranslation("generic.yes", new Object[0])).listener((ComponentEventListener & Serializable)event -> {
                this.saveEvent(eventSheet, fromClient);
                this.close();
            }).build()).cancel(ButtonConfig.builder().text(this.getTranslation("generic.no", new Object[0])).build()).build().open();
        } else {
            this.saveEvent(eventSheet, fromClient);
            this.close();
        }
    }

    private void saveDDPEvent(EventSheet eventSheet, boolean fromClient) {
        Evenement event = this.saveEvent(eventSheet, fromClient);
        int index = this.tabSheet.getSelectedIndex();
        Tab tabAtIndex = this.tabSheet.getTabAt(index);
        this.tabSheet.setSelectedTab(null);
        EventSheet newEventSheet = this.service.newEventSheet(event, false);
        Tab tab = this.createEventSheetTab(newEventSheet);
        this.eventsByTab.remove(tabAtIndex);
        this.eventsByTab.put(tab, event);
        this.tabSheet.remove(new Tab[]{tabAtIndex});
        this.tabSheet.addTabAtIndex(tab, (Component)newEventSheet, index);
        this.tabSheet.setSelectedIndex(0);
    }

    private Evenement saveEvent(EventSheet eventSheet, boolean fromClient) {
        Evenement event = eventSheet.getEvent();
        List photoList = eventSheet.getPhotoList();
        event.setIdSituation(this.situationId);
        this.fireEvent((ComponentEvent)new EventSaveEvent((EventSheetDialog)this, fromClient, event, photoList));
        return event;
    }

    public void setSaveButtonText(String text) {
        throw new UnsupportedOperationException();
    }

    public void setSaveButtonIcon(Component icon) {
        throw new UnsupportedOperationException();
    }
}

