/*
 * Decompiled with CFR 0.152.
 */
package com.neogls.prism.central.vaadin.view.mct.common.event.eventsheet.photo;

import com.neogls.prism.central.vaadin.service.bean.IPhotoItem;
import com.neogls.prism.central.vaadin.util.vaadin.PhotoItemVaadinUtils;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.dom.Style;
import java.io.Serializable;
import java.util.List;

public class PhotoViewerDialog
extends Dialog {
    private final Image image = new Image();
    private float height;
    private final List<IPhotoItem> photoList;
    private int index;

    public PhotoViewerDialog(List<IPhotoItem> photoList, IPhotoItem photoItem) {
        this.photoList = List.copyOf(photoList);
        this.index = this.photoList.indexOf(photoItem);
        if (this.index == -1) {
            throw new IllegalArgumentException("PhotoItem not in list");
        }
        this.image.getStyle().setMargin("auto");
        Div imageContainer = new Div(new Component[]{this.image});
        imageContainer.getStyle().setDisplay(Style.Display.FLEX).setOverflow(Style.Overflow.AUTO);
        imageContainer.setSizeFull();
        HorizontalLayout controls = new HorizontalLayout(new Component[]{new Button((Component)VaadinIcon.ANGLE_DOUBLE_LEFT.create(), (ComponentEventListener & Serializable)e -> this.nextImage()), new Button((Component)VaadinIcon.SEARCH_MINUS.create(), (ComponentEventListener & Serializable)e -> this.setImageHeight(this.height / 1.2f)), new Button((Component)VaadinIcon.SEARCH_PLUS.create(), (ComponentEventListener & Serializable)e -> this.setImageHeight(this.height * 1.2f)), new Button((Component)VaadinIcon.ANGLE_DOUBLE_RIGHT.create(), (ComponentEventListener & Serializable)e -> this.previousImage())});
        controls.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        controls.setSpacing(false);
        controls.addClassName("gap-s");
        HorizontalLayout closeButtonContainer = new HorizontalLayout(new Component[]{new Button(this.getTranslation("generic.close", new Object[0]), (Component)VaadinIcon.CLOSE.create(), (ComponentEventListener & Serializable)e -> this.close())});
        closeButtonContainer.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        HorizontalLayout footer = new HorizontalLayout(new Component[]{new Div(), controls, closeButtonContainer});
        footer.setFlexGrow(1.0, (HasElement[])footer.getChildren().toArray(Component[]::new));
        footer.getChildren().forEach(component -> component.getStyle().setFlexBasis("0"));
        footer.setWidthFull();
        this.getFooter().add(new Component[]{footer});
        this.add(new Component[]{imageContainer});
        this.setSizeFull();
        this.updatePhotoItem();
    }

    private void nextImage() {
        if (++this.index >= this.photoList.size()) {
            this.index = 0;
        }
        this.updatePhotoItem();
    }

    private void previousImage() {
        if (--this.index < 0) {
            this.index = this.photoList.size() - 1;
        }
        this.updatePhotoItem();
    }

    private void setImageHeight(float height) {
        this.height = height;
        this.image.setHeight(height, Unit.PERCENTAGE);
    }

    private void updatePhotoItem() {
        PhotoItemVaadinUtils.setImageSrc((Image)this.image, (IPhotoItem)((IPhotoItem)this.photoList.get(this.index)));
        this.setImageHeight(100.0f);
    }
}

